/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.utils;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.http.api.FilterableReservedStreamingHttpConnection;
import io.servicetalk.http.api.FilterableStreamingHttpClient;
import io.servicetalk.http.api.FilterableStreamingHttpConnection;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpExecutionStrategyInfluencer;
import io.servicetalk.http.api.HttpRequestMetaData;
import io.servicetalk.http.api.HttpRequestMethod;
import io.servicetalk.http.api.HttpResponseStatus;
import io.servicetalk.http.api.RedirectConfig;
import io.servicetalk.http.api.RedirectConfigBuilder;
import io.servicetalk.http.api.ReservedStreamingHttpConnectionFilter;
import io.servicetalk.http.api.StreamingHttpClientFilter;
import io.servicetalk.http.api.StreamingHttpClientFilterFactory;
import io.servicetalk.http.api.StreamingHttpConnectionFilter;
import io.servicetalk.http.api.StreamingHttpConnectionFilterFactory;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpRequester;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.utils.RedirectSingle;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public final class RedirectingHttpRequesterFilter
implements StreamingHttpClientFilterFactory,
StreamingHttpConnectionFilterFactory,
HttpExecutionStrategyInfluencer {
    private static final RedirectConfig DEFAULT_CONFIG = new RedirectConfigBuilder().build();
    private final RedirectConfig config;

    public RedirectingHttpRequesterFilter() {
        this(DEFAULT_CONFIG);
    }

    @Deprecated
    public RedirectingHttpRequesterFilter(int maxRedirects) {
        this(true, maxRedirects);
    }

    @Deprecated
    public RedirectingHttpRequesterFilter(boolean onlyRelativeClient) {
        this(onlyRelativeClient, 5);
    }

    @Deprecated
    public RedirectingHttpRequesterFilter(boolean onlyRelativeClient, int maxRedirects) {
        this(new BackwardCompatibleRedirectConfig(maxRedirects, !onlyRelativeClient));
    }

    @Deprecated
    public RedirectingHttpRequesterFilter(boolean onlyRelativeClient, boolean onlyRelativeConnection) {
        this(onlyRelativeClient, 5);
    }

    @Deprecated
    public RedirectingHttpRequesterFilter(boolean onlyRelativeClient, boolean onlyRelativeConnection, int maxRedirects) {
        this(onlyRelativeClient, maxRedirects);
    }

    public RedirectingHttpRequesterFilter(RedirectConfig config) {
        this.config = Objects.requireNonNull(config);
    }

    @Override
    public StreamingHttpClientFilter create(FilterableStreamingHttpClient client) {
        return new StreamingHttpClientFilter(client){

            @Override
            protected Single<StreamingHttpResponse> request(StreamingHttpRequester delegate, HttpExecutionStrategy strategy, StreamingHttpRequest request) {
                return RedirectingHttpRequesterFilter.this.request(delegate, strategy, request, RedirectingHttpRequesterFilter.this.config.allowNonRelativeRedirects());
            }

            @Override
            public Single<? extends FilterableReservedStreamingHttpConnection> reserveConnection(HttpExecutionStrategy strategy, HttpRequestMetaData metaData) {
                return this.delegate().reserveConnection(strategy, metaData).map(r -> new ReservedStreamingHttpConnectionFilter((FilterableReservedStreamingHttpConnection)r){

                    @Override
                    protected Single<StreamingHttpResponse> request(StreamingHttpRequester delegate, HttpExecutionStrategy strategy, StreamingHttpRequest request) {
                        return RedirectingHttpRequesterFilter.this.request(delegate, strategy, request, false);
                    }
                });
            }
        };
    }

    @Override
    public StreamingHttpConnectionFilter create(FilterableStreamingHttpConnection connection) {
        return new StreamingHttpConnectionFilter(connection){

            @Override
            public Single<StreamingHttpResponse> request(HttpExecutionStrategy strategy, StreamingHttpRequest request) {
                return RedirectingHttpRequesterFilter.this.request(this.delegate(), strategy, request, false);
            }
        };
    }

    private Single<StreamingHttpResponse> request(StreamingHttpRequester delegate, HttpExecutionStrategy strategy, StreamingHttpRequest request, boolean allowNonRelativeRedirects) {
        Single<StreamingHttpResponse> response = delegate.request(strategy, request.transformMessageBody(p -> p.map(item -> {
            if (item instanceof Buffer) {
                return ((Buffer)item).duplicate();
            }
            return item;
        })));
        if (this.config.maxRedirects() <= 0) {
            return response;
        }
        return new RedirectSingle(delegate, strategy, request, response, allowNonRelativeRedirects, this.config);
    }

    @Override
    public HttpExecutionStrategy influenceStrategy(HttpExecutionStrategy strategy) {
        return strategy;
    }

    @Deprecated
    private static final class BackwardCompatibleRedirectConfig
    implements RedirectConfig {
        static final int DEFAULT_MAX_REDIRECTS = 5;
        private static final Set<HttpRequestMethod> DEFAULT_ALLOWED_METHODS = BackwardCompatibleRedirectConfig.toSet(HttpRequestMethod.GET, HttpRequestMethod.HEAD, HttpRequestMethod.POST, HttpRequestMethod.PUT, HttpRequestMethod.DELETE, HttpRequestMethod.PATCH);
        private static final RedirectConfig.RedirectPredicate DEFAULT_SHOULD_REDIRECT_PREDICATE = (relative, redirectCnt, previousRequest, redirectResponse) -> true;
        private static final RedirectConfig.RedirectRequestTransformer DEFAULT_REDIRECT_REQUEST_TRANSFORMER = (relative, previousRequest, redirectResponse, redirectRequest) -> {
            int statusCode = redirectResponse.status().code();
            if ((statusCode == HttpResponseStatus.MOVED_PERMANENTLY.code() || statusCode == HttpResponseStatus.FOUND.code()) && HttpRequestMethod.POST.name().equals(previousRequest.method().name())) {
                redirectRequest.method(HttpRequestMethod.GET);
            }
            return redirectRequest;
        };
        private final int maxRedirects;
        private final boolean allowNonRelativeRedirects;

        BackwardCompatibleRedirectConfig(int maxRedirects, boolean allowNonRelativeRedirects) {
            this.maxRedirects = maxRedirects;
            this.allowNonRelativeRedirects = allowNonRelativeRedirects;
        }

        @Override
        public int maxRedirects() {
            return this.maxRedirects;
        }

        @Override
        public Set<HttpRequestMethod> allowedMethods() {
            return DEFAULT_ALLOWED_METHODS;
        }

        @Override
        public boolean allowNonRelativeRedirects() {
            return this.allowNonRelativeRedirects;
        }

        @Override
        public RedirectConfig.RedirectPredicate redirectPredicate() {
            return DEFAULT_SHOULD_REDIRECT_PREDICATE;
        }

        @Override
        public RedirectConfig.RedirectRequestTransformer redirectRequestTransformer() {
            return DEFAULT_REDIRECT_REQUEST_TRANSFORMER;
        }

        private static Set<HttpRequestMethod> toSet(HttpRequestMethod ... allowedMethods) {
            HashSet<HttpRequestMethod> set = new HashSet<HttpRequestMethod>((int)((float)allowedMethods.length / 0.75f) + 1);
            set.addAll(Arrays.asList(allowedMethods));
            return Collections.unmodifiableSet(set);
        }
    }
}

