/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.util.concurrent.PromiseCombiner;
import io.netty.util.internal.StringUtil;
import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.CharSequences;
import io.servicetalk.buffer.netty.BufferUtils;
import io.servicetalk.http.api.HeaderUtils;
import io.servicetalk.http.api.HttpHeaderNames;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.api.HttpMetaData;
import io.servicetalk.http.api.HttpProtocolVersion;
import io.servicetalk.http.netty.HttpKeepAlive;
import io.servicetalk.transport.netty.internal.CloseHandler;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.annotation.Nullable;

abstract class HttpObjectEncoder<T extends HttpMetaData>
extends ChannelDuplexHandler {
    static final int CRLF_SHORT = 3338;
    private static final int ZERO_CRLF_MEDIUM = 3149066;
    private static final byte[] ZERO_CRLF_CRLF = new byte[]{48, 13, 10, 13, 10};
    private static final ByteBuf CRLF_BUF = Unpooled.unreleasableBuffer(Unpooled.directBuffer(2).writeByte(13).writeByte(10).asReadOnly());
    private static final ByteBuf ZERO_CRLF_CRLF_BUF = Unpooled.unreleasableBuffer(Unpooled.directBuffer(ZERO_CRLF_CRLF.length).writeBytes(ZERO_CRLF_CRLF).asReadOnly());
    private static final float HEADERS_WEIGHT_NEW = 0.2f;
    private static final float HEADERS_WEIGHT_HISTORICAL = 0.8f;
    private static final float TRAILERS_WEIGHT_NEW = 0.2f;
    private static final float TRAILERS_WEIGHT_HISTORICAL = 0.8f;
    private static final int COLON_AND_SPACE_SHORT = 14880;
    private static final int ST_INIT = 0;
    private static final int ST_CONTENT_NON_CHUNK = 1;
    private static final int ST_CONTENT_CHUNK = 2;
    private static final int ST_CONTENT_ALWAYS_EMPTY = 3;
    private int state = 0;
    private float headersEncodedSizeAccumulator;
    private float trailersEncodedSizeAccumulator;
    private final CloseHandler closeHandler;
    private boolean messageSent;

    HttpObjectEncoder(int headersEncodedSizeAccumulator, int trailersEncodedSizeAccumulator, CloseHandler closeHandler) {
        this.headersEncodedSizeAccumulator = Math.max(16, headersEncodedSizeAccumulator);
        this.trailersEncodedSizeAccumulator = Math.max(16, trailersEncodedSizeAccumulator);
        this.closeHandler = closeHandler;
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        if (msg instanceof HttpMetaData) {
            boolean realResponse;
            T metaData = this.castMetaData(msg);
            boolean bl = realResponse = !this.isInterim(metaData);
            if (!realResponse && this.messageSent) {
                return;
            }
            if (this.state != 0) {
                throw new IllegalStateException("unexpected message type: " + StringUtil.simpleClassName(msg));
            }
            this.onMetaData(ctx, metaData);
            if (realResponse) {
                this.messageSent = true;
                this.closeHandler.protocolPayloadBeginOutbound(ctx);
                if (HttpKeepAlive.shouldClose(metaData)) {
                    this.closeHandler.protocolClosingOutbound(ctx);
                }
            }
            ByteBuf byteBuf = ctx.alloc().directBuffer((int)this.headersEncodedSizeAccumulator);
            try {
                Buffer stBuf = BufferUtils.newBufferFrom(byteBuf);
                this.encodeInitialLine(ctx, stBuf, metaData);
                int n = this.isContentAlwaysEmpty(metaData) ? 3 : (this.state = HeaderUtils.isTransferEncodingChunked(metaData.headers()) ? 2 : 1);
                if (!realResponse) {
                    assert (this.state == 3);
                    assert (!this.messageSent);
                    this.state = 0;
                }
                this.sanitizeHeadersBeforeEncode(metaData, this.state);
                HttpObjectEncoder.encodeHeaders(metaData.headers(), byteBuf, stBuf);
                ByteBufUtil.writeShortBE(byteBuf, 3338);
                this.headersEncodedSizeAccumulator = 0.2f * (float)HttpObjectEncoder.padSizeForAccumulation(byteBuf.readableBytes()) + 0.8f * this.headersEncodedSizeAccumulator;
            }
            catch (Throwable e) {
                byteBuf.release();
                throw e;
            }
            if (realResponse) {
                ctx.write(byteBuf, promise);
            } else {
                ctx.writeAndFlush(byteBuf, promise);
            }
        } else if (msg instanceof Buffer) {
            Buffer stBuffer = (Buffer)msg;
            if (stBuffer.readableBytes() == 0) {
                ctx.write(Unpooled.EMPTY_BUFFER, promise);
            } else {
                switch (this.state) {
                    case 0: {
                        throw new IllegalStateException("unexpected message type: " + StringUtil.simpleClassName(msg));
                    }
                    case 1: {
                        long contentLength = stBuffer.readableBytes();
                        if (contentLength > 0L) {
                            ctx.write(HttpObjectEncoder.encodeAndRetain(stBuffer), promise);
                            break;
                        }
                    }
                    case 3: {
                        ctx.write(Unpooled.EMPTY_BUFFER, promise);
                        break;
                    }
                    case 2: {
                        PromiseCombiner promiseCombiner = new PromiseCombiner();
                        HttpObjectEncoder.encodeChunkedContent(ctx, stBuffer, stBuffer.readableBytes(), promiseCombiner);
                        promiseCombiner.finish(promise);
                        break;
                    }
                    default: {
                        throw new Error();
                    }
                }
            }
        } else if (msg instanceof HttpHeaders) {
            int oldState = this.resetState(ctx, promise);
            if (oldState == 2) {
                this.encodeAndWriteTrailers(ctx, (HttpHeaders)msg, promise);
            } else {
                ctx.write(Unpooled.EMPTY_BUFFER, promise);
            }
        }
    }

    protected final int resetState(ChannelHandlerContext ctx, @Nullable ChannelPromise promise) {
        this.messageSent = false;
        this.closeHandler.protocolPayloadEndOutbound(ctx, promise);
        int oldState = this.state;
        this.state = 0;
        return oldState;
    }

    protected boolean isContentAlwaysEmpty(T msg) {
        return false;
    }

    protected boolean isInterim(T msg) {
        return false;
    }

    protected void onMetaData(ChannelHandlerContext ctx, T metaData) {
    }

    private void sanitizeHeadersBeforeEncode(T msg, int state) {
        if (state == 2 && HttpProtocolVersion.HTTP_1_1.equals(msg.version())) {
            msg.headers().remove(HttpHeaderNames.CONTENT_LENGTH);
        }
        this.sanitizeHeadersBeforeEncode(msg, state == 3);
    }

    protected abstract void sanitizeHeadersBeforeEncode(T var1, boolean var2);

    protected abstract T castMetaData(Object var1);

    protected abstract void encodeInitialLine(ChannelHandlerContext var1, Buffer var2, T var3);

    private static void encodeHeaders(HttpHeaders headers, ByteBuf byteBuf) {
        HttpObjectEncoder.encodeHeaders(headers, byteBuf, BufferUtils.newBufferFrom(byteBuf));
    }

    private static void encodeHeaders(HttpHeaders headers, ByteBuf byteBuf, Buffer buffer) {
        for (Map.Entry<CharSequence, CharSequence> header : headers) {
            HttpObjectEncoder.encodeHeader(header.getKey(), header.getValue(), byteBuf, buffer);
        }
    }

    private static void encodeChunkedContent(ChannelHandlerContext ctx, Buffer msg, long contentLength, PromiseCombiner promiseCombiner) {
        if (contentLength > 0L) {
            String lengthHex = Long.toHexString(contentLength);
            ByteBuf buf = ctx.alloc().directBuffer(lengthHex.length() + 2);
            try {
                buf.writeCharSequence(lengthHex, StandardCharsets.US_ASCII);
                ByteBufUtil.writeShortBE(buf, 3338);
            }
            catch (Throwable e) {
                buf.release();
                throw e;
            }
            promiseCombiner.add(ctx.write(buf));
            promiseCombiner.add(ctx.write(HttpObjectEncoder.encodeAndRetain(msg)));
            promiseCombiner.add(ctx.write(CRLF_BUF.duplicate()));
        } else {
            assert (contentLength == 0L);
            promiseCombiner.add(ctx.write(HttpObjectEncoder.encodeAndRetain(msg)));
        }
    }

    private void encodeAndWriteTrailers(ChannelHandlerContext ctx, HttpHeaders headers, ChannelPromise promise) {
        if (headers.isEmpty()) {
            ctx.write(ZERO_CRLF_CRLF_BUF.duplicate(), promise);
        } else {
            ByteBuf buf = ctx.alloc().directBuffer((int)this.trailersEncodedSizeAccumulator);
            try {
                ByteBufUtil.writeMediumBE(buf, 3149066);
                HttpObjectEncoder.encodeHeaders(headers, buf);
                ByteBufUtil.writeShortBE(buf, 3338);
                this.trailersEncodedSizeAccumulator = 0.2f * (float)HttpObjectEncoder.padSizeForAccumulation(buf.readableBytes()) + 0.8f * this.trailersEncodedSizeAccumulator;
            }
            catch (Throwable e) {
                buf.release();
                throw e;
            }
            ctx.write(buf, promise);
        }
    }

    private static int padSizeForAccumulation(int readableBytes) {
        return (readableBytes << 2) / 3;
    }

    private static void encodeHeader(CharSequence name, CharSequence value, ByteBuf byteBuf, Buffer buffer) {
        int nameLen = name.length();
        int valueLen = value.length();
        int entryLen = nameLen + valueLen + 4;
        byteBuf.ensureWritable(entryLen);
        int offset = byteBuf.writerIndex();
        HttpObjectEncoder.writeAscii(name, byteBuf, buffer, offset);
        ByteBufUtil.setShortBE(byteBuf, offset += nameLen, 14880);
        HttpObjectEncoder.writeAscii(value, byteBuf, buffer, offset += 2);
        ByteBufUtil.setShortBE(byteBuf, offset += valueLen, 3338);
        byteBuf.writerIndex(offset += 2);
    }

    private static void writeAscii(CharSequence value, ByteBuf dstByteBuf, Buffer dstBuffer, int dstOffset) {
        Buffer valueBuffer = CharSequences.unwrapBuffer(value);
        if (valueBuffer != null) {
            HttpObjectEncoder.writeBufferToByteBuf(valueBuffer, dstByteBuf, dstBuffer, dstOffset);
        } else {
            dstByteBuf.setCharSequence(dstOffset, value, StandardCharsets.US_ASCII);
        }
    }

    private static void writeBufferToByteBuf(Buffer src, ByteBuf dstByteBuf, Buffer dstBuffer, int dstOffset) {
        ByteBuf byteBuf = BufferUtils.toByteBufNoThrow(src);
        if (byteBuf != null) {
            dstByteBuf.setBytes(dstOffset, byteBuf, byteBuf.readerIndex(), byteBuf.readableBytes());
        } else {
            src.getBytes(src.readerIndex(), dstBuffer, dstOffset, src.readableBytes());
        }
    }

    static ByteBuf encodeAndRetain(Buffer msg) {
        return HttpObjectEncoder.toByteBuf(msg).retain();
    }

    private static ByteBuf toByteBuf(Buffer buffer) {
        ByteBuf byteBuf = BufferUtils.toByteBufNoThrow(buffer);
        return byteBuf != null ? byteBuf : Unpooled.wrappedBuffer(buffer.toNioBuffer());
    }
}

