/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.http.api.DefaultHttpExecutionContext;
import io.servicetalk.http.api.HttpExecutionContext;
import io.servicetalk.http.api.HttpExecutionStrategies;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.transport.api.ExecutionContext;
import io.servicetalk.transport.api.IoExecutor;
import io.servicetalk.transport.netty.internal.ExecutionContextBuilder;

final class HttpExecutionContextBuilder {
    private final ExecutionContextBuilder executionContextBuilder;
    private HttpExecutionStrategy strategy = HttpExecutionStrategies.defaultStrategy();

    HttpExecutionContextBuilder(HttpExecutionContextBuilder from) {
        this.executionContextBuilder = new ExecutionContextBuilder(from.executionContextBuilder);
        this.strategy = from.strategy;
    }

    HttpExecutionContextBuilder() {
        this.executionContextBuilder = new ExecutionContextBuilder();
        this.executionContextBuilder.executionStrategy(HttpExecutionStrategies.defaultStrategy());
    }

    public HttpExecutionContextBuilder ioExecutor(IoExecutor ioExecutor) {
        this.executionContextBuilder.ioExecutor(ioExecutor);
        return this;
    }

    public HttpExecutionContextBuilder executor(Executor executor) {
        this.executionContextBuilder.executor(executor);
        return this;
    }

    public HttpExecutionContextBuilder bufferAllocator(BufferAllocator allocator) {
        this.executionContextBuilder.bufferAllocator(allocator);
        return this;
    }

    public HttpExecutionContextBuilder executionStrategy(HttpExecutionStrategy strategy) {
        this.strategy = strategy;
        this.executionContextBuilder.executionStrategy(strategy);
        return this;
    }

    public HttpExecutionContext build() {
        ExecutionContext ctx = this.executionContextBuilder.build();
        return new DefaultHttpExecutionContext(ctx.bufferAllocator(), ctx.ioExecutor(), ctx.executor(), this.strategy);
    }
}

