/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http2.Http2SettingsFrame;
import io.netty.handler.codec.http2.Http2StreamChannel;
import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.api.internal.SubscribableSingle;
import io.servicetalk.concurrent.internal.DelayedCancellable;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import io.servicetalk.http.api.HttpExecutionContext;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpProtocolVersion;
import io.servicetalk.http.api.StreamingHttpService;
import io.servicetalk.http.netty.H2ParentConnectionContext;
import io.servicetalk.http.netty.H2ProtocolConfig;
import io.servicetalk.http.netty.H2ServerParentChannelInitializer;
import io.servicetalk.http.netty.H2ToStH1ServerDuplexHandler;
import io.servicetalk.http.netty.HeaderUtils;
import io.servicetalk.http.netty.HttpDebugUtils;
import io.servicetalk.http.netty.KeepAliveManager;
import io.servicetalk.http.netty.NettyHttp2ExceptionUtils;
import io.servicetalk.http.netty.NettyHttpServer;
import io.servicetalk.http.netty.ReadOnlyHttpServerConfig;
import io.servicetalk.tcp.netty.internal.ReadOnlyTcpServerConfig;
import io.servicetalk.tcp.netty.internal.TcpServerBinder;
import io.servicetalk.tcp.netty.internal.TcpServerChannelInitializer;
import io.servicetalk.transport.api.ConnectionAcceptor;
import io.servicetalk.transport.api.ConnectionObserver;
import io.servicetalk.transport.api.ServerContext;
import io.servicetalk.transport.netty.internal.ChannelCloseUtils;
import io.servicetalk.transport.netty.internal.ChannelSet;
import io.servicetalk.transport.netty.internal.CloseHandler;
import io.servicetalk.transport.netty.internal.DefaultNettyConnection;
import io.servicetalk.transport.netty.internal.FlushStrategy;
import io.servicetalk.transport.netty.internal.NettyPipelineSslUtils;
import io.servicetalk.transport.netty.internal.NoopTransportObserver;
import java.net.SocketAddress;
import java.util.Objects;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class H2ServerParentConnectionContext
extends H2ParentConnectionContext
implements ServerContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(H2ServerParentConnectionContext.class);
    private final SocketAddress listenAddress;

    private H2ServerParentConnectionContext(Channel channel, BufferAllocator allocator, Executor executor, FlushStrategy flushStrategy, @Nullable Long idleTimeoutMs, HttpExecutionStrategy executionStrategy, SocketAddress listenAddress, KeepAliveManager keepAliveManager) {
        super(channel, allocator, executor, flushStrategy, idleTimeoutMs, executionStrategy, keepAliveManager);
        this.listenAddress = Objects.requireNonNull(listenAddress);
    }

    @Override
    public SocketAddress listenAddress() {
        return this.listenAddress;
    }

    static Single<ServerContext> bind(HttpExecutionContext executionContext, ReadOnlyHttpServerConfig config, SocketAddress listenAddress, @Nullable ConnectionAcceptor connectionAcceptor, StreamingHttpService service, boolean drainRequestPayloadBody) {
        if (config.h2Config() == null) {
            return Single.failed(H2ServerParentConnectionContext.newH2ConfigException());
        }
        ReadOnlyTcpServerConfig tcpServerConfig = config.tcpConfig();
        return TcpServerBinder.bind(listenAddress, tcpServerConfig, true, executionContext, connectionAcceptor, (channel, connectionObserver) -> H2ServerParentConnectionContext.initChannel(listenAddress, channel, executionContext, config, new TcpServerChannelInitializer(tcpServerConfig, (ConnectionObserver)connectionObserver), service, drainRequestPayloadBody, connectionObserver), serverConnection -> {}).map(delegate -> {
            LOGGER.debug("Started HTTP/2 server with prior-knowledge for address {}", (Object)delegate.listenAddress());
            return new NettyHttpServer.NettyHttpServerContext((ServerContext)delegate, service);
        });
    }

    private static Throwable newH2ConfigException() {
        return new IllegalStateException("HTTP/2 channel initialization failure due to missing HTTP/2 configuration");
    }

    static Single<H2ServerParentConnectionContext> initChannel(final SocketAddress listenAddress, final Channel channel, final HttpExecutionContext httpExecutionContext, final ReadOnlyHttpServerConfig config, final io.servicetalk.transport.netty.internal.ChannelInitializer initializer, final StreamingHttpService service, final boolean drainRequestPayloadBody, final ConnectionObserver observer) {
        final H2ProtocolConfig h2ServerConfig = config.h2Config();
        if (h2ServerConfig == null) {
            return Single.failed(H2ServerParentConnectionContext.newH2ConfigException());
        }
        return HttpDebugUtils.showPipeline(new SubscribableSingle<H2ServerParentConnectionContext>(){

            @Override
            protected void handleSubscribe(SingleSource.Subscriber<? super H2ServerParentConnectionContext> subscriber) {
                DefaultH2ServerParentConnection parentChannelInitializer;
                ChannelPipeline pipeline;
                DelayedCancellable delayedCancellable;
                try {
                    delayedCancellable = new DelayedCancellable();
                    KeepAliveManager keepAliveManager = new KeepAliveManager(channel, h2ServerConfig.keepAlivePolicy());
                    FlushStrategy parentFlushStrategy = config.tcpConfig().flushStrategy();
                    BufferAllocator allocator = httpExecutionContext.bufferAllocator();
                    Executor executor = httpExecutionContext.executor();
                    final HttpExecutionStrategy executionStrategy = httpExecutionContext.executionStrategy();
                    final H2ServerParentConnectionContext connection = new H2ServerParentConnectionContext(channel, allocator, executor, parentFlushStrategy, config.tcpConfig().idleTimeoutMs(), executionStrategy, listenAddress, keepAliveManager);
                    channel.attr(ChannelSet.CHANNEL_CLOSEABLE_KEY).set(connection);
                    initializer.init(channel);
                    pipeline = channel.pipeline();
                    parentChannelInitializer = new DefaultH2ServerParentConnection(connection, subscriber, delayedCancellable, NettyPipelineSslUtils.isSslEnabled(pipeline), observer);
                    new H2ServerParentChannelInitializer(h2ServerConfig, new ChannelInitializer<Http2StreamChannel>(){

                        @Override
                        protected void initChannel(Http2StreamChannel streamChannel) {
                            connection.trackActiveStream(streamChannel);
                            ConnectionObserver.StreamObserver streamObserver = parentChannelInitializer.multiplexedObserver.onNewStream();
                            int streamId = streamChannel.stream().id();
                            assert (streamId > 0);
                            streamObserver.streamIdAssigned(streamId);
                            CloseHandler closeHandler = CloseHandler.forNonPipelined(false, streamChannel.config());
                            streamChannel.pipeline().addLast(new H2ToStH1ServerDuplexHandler(connection.executionContext().bufferAllocator(), h2ServerConfig.headersFactory(), closeHandler, streamObserver));
                            DefaultNettyConnection<Object, Object> streamConnection = DefaultNettyConnection.initChildChannel(streamChannel, connection.executionContext().bufferAllocator(), connection.executionContext().executor(), HeaderUtils.LAST_CHUNK_PREDICATE, closeHandler, connection.flushStrategyHolder.currentStrategy(), connection.idleTimeoutMs, connection.executionContext().executionStrategy(), HttpProtocolVersion.HTTP_2_0, connection.sslSession(), channel.config(), streamObserver, false, __ -> false, NettyHttp2ExceptionUtils::wrapIfNecessary);
                            new NettyHttpServer.NettyHttpServerConnection(streamConnection, service, executionStrategy, HttpProtocolVersion.HTTP_2_0, h2ServerConfig.headersFactory(), drainRequestPayloadBody, config.allowDropTrailersReadFromTransport()).process(false);
                        }
                    }).init(channel);
                }
                catch (Throwable cause) {
                    ChannelCloseUtils.close(channel, cause);
                    SubscriberUtils.deliverErrorFromSource(subscriber, cause);
                    return;
                }
                subscriber.onSubscribe(delayedCancellable);
                pipeline.addLast(parentChannelInitializer);
            }
        }, HttpProtocolVersion.HTTP_2_0, channel);
    }

    private static final class DefaultH2ServerParentConnection
    extends H2ParentConnectionContext.AbstractH2ParentConnection {
        @Nullable
        private SingleSource.Subscriber<? super H2ServerParentConnectionContext> subscriber;
        private ConnectionObserver.MultiplexedObserver multiplexedObserver = NoopTransportObserver.NoopMultiplexedObserver.INSTANCE;

        DefaultH2ServerParentConnection(H2ServerParentConnectionContext parentContext, SingleSource.Subscriber<? super H2ServerParentConnectionContext> subscriber, DelayedCancellable delayedCancellable, boolean waitForSslHandshake, ConnectionObserver observer) {
            super(parentContext, delayedCancellable, waitForSslHandshake, observer);
            this.subscriber = Objects.requireNonNull(subscriber);
        }

        @Override
        boolean hasSubscriber() {
            return this.subscriber != null;
        }

        @Override
        void tryCompleteSubscriber() {
            if (this.subscriber != null) {
                SingleSource.Subscriber<? super H2ServerParentConnectionContext> subscriberCopy = this.subscriber;
                this.subscriber = null;
                this.multiplexedObserver = this.observer.multiplexedConnectionEstablished(this.parentContext);
                subscriberCopy.onSuccess((H2ServerParentConnectionContext)this.parentContext);
            }
        }

        @Override
        void tryFailSubscriber(Throwable cause) {
            if (this.subscriber != null) {
                ChannelCloseUtils.close(this.parentContext.nettyChannel(), cause);
                SingleSource.Subscriber<? super H2ServerParentConnectionContext> subscriberCopy = this.subscriber;
                this.subscriber = null;
                subscriberCopy.onError(cause);
            }
        }

        @Override
        boolean ackSettings(ChannelHandlerContext ctx, Http2SettingsFrame settingsFrame) {
            return false;
        }
    }
}

