/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.servicetalk.client.api.ConnectionFactoryFilter;
import io.servicetalk.client.api.internal.ReservableRequestConcurrencyController;
import io.servicetalk.client.api.internal.ReservableRequestConcurrencyControllers;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.http.api.FilterableStreamingHttpConnection;
import io.servicetalk.http.api.FilterableStreamingHttpLoadBalancedConnection;
import io.servicetalk.http.api.HttpEventKey;
import io.servicetalk.http.api.HttpExecutionContext;
import io.servicetalk.http.api.HttpExecutionStrategyInfluencer;
import io.servicetalk.http.api.HttpProtocolVersion;
import io.servicetalk.http.api.StreamingHttpConnectionFilterFactory;
import io.servicetalk.http.api.StreamingHttpRequestResponseFactory;
import io.servicetalk.http.netty.AbstractLBHttpConnectionFactory;
import io.servicetalk.http.netty.H2ClientParentChannelInitializer;
import io.servicetalk.http.netty.H2ClientParentConnectionContext;
import io.servicetalk.http.netty.ReadOnlyHttpClientConfig;
import io.servicetalk.http.netty.StreamingConnectionFactory;
import io.servicetalk.tcp.netty.internal.ReadOnlyTcpClientConfig;
import io.servicetalk.tcp.netty.internal.TcpClientChannelInitializer;
import io.servicetalk.tcp.netty.internal.TcpConnector;
import io.servicetalk.transport.api.ConnectionObserver;
import io.servicetalk.transport.api.TransportObserver;
import java.util.function.Function;
import javax.annotation.Nullable;

final class H2LBHttpConnectionFactory<ResolvedAddress>
extends AbstractLBHttpConnectionFactory<ResolvedAddress> {
    H2LBHttpConnectionFactory(ReadOnlyHttpClientConfig config, HttpExecutionContext executionContext, @Nullable StreamingHttpConnectionFilterFactory connectionFilterFunction, StreamingHttpRequestResponseFactory reqRespFactory, HttpExecutionStrategyInfluencer strategyInfluencer, ConnectionFactoryFilter<ResolvedAddress, FilterableStreamingHttpConnection> connectionFactoryFilter, Function<FilterableStreamingHttpConnection, FilterableStreamingHttpLoadBalancedConnection> protocolBinding) {
        super(config, executionContext, connectionFilterFunction, (HttpProtocolVersion version) -> reqRespFactory, strategyInfluencer, connectionFactoryFilter, protocolBinding);
    }

    @Override
    Single<FilterableStreamingHttpConnection> newFilterableConnection(ResolvedAddress resolvedAddress, TransportObserver observer) {
        assert (this.config.h2Config() != null);
        ReadOnlyTcpClientConfig tcpConfig = StreamingConnectionFactory.withSslConfigPeerHost(resolvedAddress, this.config.tcpConfig());
        return TcpConnector.connect(null, resolvedAddress, tcpConfig, true, this.executionContext, (channel, connectionObserver) -> H2ClientParentConnectionContext.initChannel(channel, this.executionContext.bufferAllocator(), this.executionContext.executor(), this.config.h2Config(), (StreamingHttpRequestResponseFactory)this.reqRespFactoryFunc.apply(HttpProtocolVersion.HTTP_2_0), tcpConfig.flushStrategy(), tcpConfig.idleTimeoutMs(), this.executionContext.executionStrategy(), new TcpClientChannelInitializer(tcpConfig, (ConnectionObserver)connectionObserver).andThen(new H2ClientParentChannelInitializer(this.config.h2Config())), connectionObserver, this.config.allowDropTrailersReadFromTransport()), observer);
    }

    @Override
    ReservableRequestConcurrencyController newConcurrencyController(FilterableStreamingHttpConnection connection, Completable onClosing) {
        return ReservableRequestConcurrencyControllers.newController(connection.transportEventStream(HttpEventKey.MAX_CONCURRENCY), onClosing, 100);
    }
}

