/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.http.api.BlockingHttpClient;
import io.servicetalk.http.api.BlockingStreamingHttpClient;
import io.servicetalk.http.api.FilterableReservedStreamingHttpConnection;
import io.servicetalk.http.api.FilterableStreamingHttpClient;
import io.servicetalk.http.api.HttpApiConversions;
import io.servicetalk.http.api.HttpClient;
import io.servicetalk.http.api.HttpConnectionContext;
import io.servicetalk.http.api.HttpEventKey;
import io.servicetalk.http.api.HttpExecutionContext;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpExecutionStrategyInfluencer;
import io.servicetalk.http.api.HttpRequestMetaData;
import io.servicetalk.http.api.HttpRequestMethod;
import io.servicetalk.http.api.ReservedBlockingHttpConnection;
import io.servicetalk.http.api.ReservedBlockingStreamingHttpConnection;
import io.servicetalk.http.api.ReservedHttpConnection;
import io.servicetalk.http.api.ReservedStreamingHttpConnection;
import io.servicetalk.http.api.StreamingHttpClient;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.api.StreamingHttpResponseFactory;
import io.servicetalk.http.netty.NewToDeprecatedFilter;

final class FilterableClientToClient
implements StreamingHttpClient {
    private final FilterableStreamingHttpClient client;
    private final HttpExecutionStrategyInfluencer strategyInfluencer;
    private final HttpExecutionStrategy strategy;

    FilterableClientToClient(FilterableStreamingHttpClient filteredClient, HttpExecutionStrategy strategyFromBuilder, HttpExecutionStrategyInfluencer strategyInfluencer) {
        this.strategy = strategyFromBuilder;
        this.client = filteredClient;
        this.strategyInfluencer = strategyInfluencer;
    }

    @Override
    public Single<StreamingHttpResponse> request(StreamingHttpRequest request) {
        return Single.defer(() -> this.request(NewToDeprecatedFilter.requestStrategy(request, this.strategy), request).shareContextOnSubscribe());
    }

    @Override
    public Single<ReservedStreamingHttpConnection> reserveConnection(HttpRequestMetaData metaData) {
        return Single.defer(() -> this.reserveConnection(NewToDeprecatedFilter.requestStrategy(metaData, this.strategy), metaData).shareContextOnSubscribe());
    }

    @Override
    public HttpClient asClient() {
        return HttpApiConversions.toClient(this, this.strategyInfluencer);
    }

    @Override
    public BlockingStreamingHttpClient asBlockingStreamingClient() {
        return HttpApiConversions.toBlockingStreamingClient(this, this.strategyInfluencer);
    }

    @Override
    public BlockingHttpClient asBlockingClient() {
        return HttpApiConversions.toBlockingClient(this, this.strategyInfluencer);
    }

    @Override
    public Single<ReservedStreamingHttpConnection> reserveConnection(HttpExecutionStrategy strategy, HttpRequestMetaData metaData) {
        return this.client.reserveConnection(strategy, metaData).map(rc -> new ReservedStreamingHttpConnection((FilterableReservedStreamingHttpConnection)rc){
            final /* synthetic */ FilterableReservedStreamingHttpConnection val$rc;
            {
                this.val$rc = filterableReservedStreamingHttpConnection;
            }

            @Override
            public ReservedHttpConnection asConnection() {
                return HttpApiConversions.toReservedConnection(this, FilterableClientToClient.this.strategyInfluencer);
            }

            @Override
            public ReservedBlockingStreamingHttpConnection asBlockingStreamingConnection() {
                return HttpApiConversions.toReservedBlockingStreamingConnection(this, FilterableClientToClient.this.strategyInfluencer);
            }

            @Override
            public ReservedBlockingHttpConnection asBlockingConnection() {
                return HttpApiConversions.toReservedBlockingConnection(this, FilterableClientToClient.this.strategyInfluencer);
            }

            @Override
            public Completable releaseAsync() {
                return this.val$rc.releaseAsync();
            }

            @Override
            public Single<StreamingHttpResponse> request(StreamingHttpRequest request) {
                return Single.defer(() -> this.val$rc.request(NewToDeprecatedFilter.requestStrategy(request, FilterableClientToClient.this.strategy), request).shareContextOnSubscribe());
            }

            @Override
            public HttpConnectionContext connectionContext() {
                return this.val$rc.connectionContext();
            }

            @Override
            public <T> Publisher<? extends T> transportEventStream(HttpEventKey<T> eventKey) {
                return this.val$rc.transportEventStream(eventKey);
            }

            @Override
            public Single<StreamingHttpResponse> request(HttpExecutionStrategy strategy, StreamingHttpRequest request) {
                return this.val$rc.request(strategy, request);
            }

            @Override
            public HttpExecutionContext executionContext() {
                return this.val$rc.executionContext();
            }

            @Override
            public StreamingHttpResponseFactory httpResponseFactory() {
                return this.val$rc.httpResponseFactory();
            }

            @Override
            public Completable onClose() {
                return this.val$rc.onClose();
            }

            @Override
            public Completable closeAsync() {
                return this.val$rc.closeAsync();
            }

            @Override
            public Completable closeAsyncGracefully() {
                return this.val$rc.closeAsyncGracefully();
            }

            @Override
            public StreamingHttpRequest newRequest(HttpRequestMethod method, String requestTarget) {
                return this.val$rc.newRequest(method, requestTarget);
            }
        });
    }

    @Override
    public Single<StreamingHttpResponse> request(HttpExecutionStrategy strategy, StreamingHttpRequest request) {
        return this.client.request(strategy, request);
    }

    @Override
    public HttpExecutionContext executionContext() {
        return this.client.executionContext();
    }

    @Override
    public StreamingHttpResponseFactory httpResponseFactory() {
        return this.client.httpResponseFactory();
    }

    @Override
    public Completable onClose() {
        return this.client.onClose();
    }

    @Override
    public Completable closeAsync() {
        return this.client.closeAsync();
    }

    @Override
    public Completable closeAsyncGracefully() {
        return this.client.closeAsyncGracefully();
    }

    @Override
    public StreamingHttpRequest newRequest(HttpRequestMethod method, String requestTarget) {
        return this.client.newRequest(method, requestTarget);
    }
}

