/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.client.api.AutoRetryStrategyProvider;
import io.servicetalk.client.api.ClientGroup;
import io.servicetalk.client.api.ConnectionFactoryFilter;
import io.servicetalk.client.api.ServiceDiscoverer;
import io.servicetalk.client.api.internal.DefaultPartitionedClientGroup;
import io.servicetalk.client.api.internal.partition.PowerSetPartitionMapFactory;
import io.servicetalk.client.api.partition.ClosedPartitionException;
import io.servicetalk.client.api.partition.PartitionAttributes;
import io.servicetalk.client.api.partition.PartitionAttributesBuilder;
import io.servicetalk.client.api.partition.PartitionMapFactory;
import io.servicetalk.client.api.partition.PartitionedServiceDiscovererEvent;
import io.servicetalk.client.api.partition.UnknownPartitionException;
import io.servicetalk.concurrent.api.AsyncCloseables;
import io.servicetalk.concurrent.api.BiIntFunction;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.ListenableAsyncCloseable;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.RetryStrategies;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.http.api.FilterableReservedStreamingHttpConnection;
import io.servicetalk.http.api.FilterableStreamingHttpClient;
import io.servicetalk.http.api.FilterableStreamingHttpConnection;
import io.servicetalk.http.api.HttpExecutionContext;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpLoadBalancerFactory;
import io.servicetalk.http.api.HttpProtocolConfig;
import io.servicetalk.http.api.HttpRequestMetaData;
import io.servicetalk.http.api.HttpRequestMethod;
import io.servicetalk.http.api.PartitionHttpClientBuilderConfigurator;
import io.servicetalk.http.api.PartitionedHttpClientBuilder;
import io.servicetalk.http.api.PartitionedHttpClientSecurityConfigurator;
import io.servicetalk.http.api.ReservedStreamingHttpConnection;
import io.servicetalk.http.api.ServiceDiscoveryRetryStrategy;
import io.servicetalk.http.api.StreamingHttpClient;
import io.servicetalk.http.api.StreamingHttpClientFilterFactory;
import io.servicetalk.http.api.StreamingHttpConnectionFilterFactory;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpRequestResponseFactory;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.api.StreamingHttpResponseFactory;
import io.servicetalk.http.netty.DefaultPartitionedHttpClientSecurityConfigurator;
import io.servicetalk.http.netty.DefaultSingleAddressHttpClientBuilder;
import io.servicetalk.http.netty.FilterableClientToClient;
import io.servicetalk.logging.api.LogLevel;
import io.servicetalk.transport.api.IoExecutor;
import java.net.SocketOption;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import javax.annotation.Nullable;

class DefaultPartitionedHttpClientBuilder<U, R>
extends PartitionedHttpClientBuilder<U, R> {
    private ServiceDiscoverer<U, R, PartitionedServiceDiscovererEvent<R>> serviceDiscoverer;
    @Nullable
    private ServiceDiscoveryRetryStrategy<R, PartitionedServiceDiscovererEvent<R>> deprecatedServiceDiscovererRetryStrategy;
    @Nullable
    private BiIntFunction<Throwable, ? extends Completable> serviceDiscovererRetryStrategy;
    private final Function<HttpRequestMetaData, PartitionAttributesBuilder> partitionAttributesBuilderFactory;
    private final DefaultSingleAddressHttpClientBuilder<U, R> builderTemplate;
    @Nullable
    private PartitionedHttpClientBuilder.SingleAddressInitializer<U, R> clientInitializer;
    private PartitionHttpClientBuilderConfigurator<U, R> clientFilterFunction = (__, ___) -> {};
    private PartitionMapFactory partitionMapFactory = PowerSetPartitionMapFactory.INSTANCE;
    private int serviceDiscoveryMaxQueueSize = 32;

    DefaultPartitionedHttpClientBuilder(DefaultSingleAddressHttpClientBuilder<U, R> builderTemplate, ServiceDiscoverer<U, R, PartitionedServiceDiscovererEvent<R>> serviceDiscoverer, Function<HttpRequestMetaData, PartitionAttributesBuilder> partitionAttributesBuilderFactory) {
        this.builderTemplate = Objects.requireNonNull(builderTemplate);
        this.serviceDiscoverer = Objects.requireNonNull(serviceDiscoverer);
        this.partitionAttributesBuilderFactory = Objects.requireNonNull(partitionAttributesBuilderFactory);
    }

    @Override
    public StreamingHttpClient buildStreaming() {
        DefaultSingleAddressHttpClientBuilder.HttpClientBuildContext<U, R> buildContext = this.builderTemplate.copyBuildCtx();
        HttpExecutionContext executionContext = buildContext.builder.build().executionContext();
        BiIntFunction<Throwable, ? extends Completable> sdRetryStrategy = this.serviceDiscovererRetryStrategy;
        if (sdRetryStrategy == null && this.deprecatedServiceDiscovererRetryStrategy == null) {
            sdRetryStrategy = RetryStrategies.retryWithConstantBackoffDeltaJitter(__ -> true, DefaultSingleAddressHttpClientBuilder.SD_RETRY_STRATEGY_INIT_DURATION, DefaultSingleAddressHttpClientBuilder.SD_RETRY_STRATEGY_JITTER, executionContext.executor());
        }
        DefaultSingleAddressHttpClientBuilder.RetryingServiceDiscoverer<U, R, PartitionedServiceDiscovererEvent<R>> psd = new DefaultSingleAddressHttpClientBuilder.RetryingServiceDiscoverer<U, R, PartitionedServiceDiscovererEvent<R>>(this.serviceDiscoverer, sdRetryStrategy, this.deprecatedServiceDiscovererRetryStrategy);
        DefaultPartitionedClientGroup.PartitionedClientFactory clientFactory = (pa, sd) -> {
            DefaultSingleAddressHttpClientBuilder builder = buildContext.builder.copyBuildCtx().builder;
            builder.serviceDiscoverer(sd);
            this.clientFilterFunction.configureForPartition(pa, builder);
            if (this.clientInitializer != null) {
                this.clientInitializer.initialize(pa, builder);
            }
            return builder.buildStreaming();
        };
        Publisher psdEvents = psd.discover(buildContext.address()).flatMapConcatIterable(Function.identity());
        DefaultPartitionedStreamingHttpClientFilter partitionedClient = new DefaultPartitionedStreamingHttpClientFilter(psdEvents, this.serviceDiscoveryMaxQueueSize, clientFactory, this.partitionAttributesBuilderFactory, DefaultSingleAddressHttpClientBuilder.defaultReqRespFactory(buildContext.httpConfig().asReadOnly(), buildContext.executionContext.bufferAllocator()), buildContext.executionContext, this.partitionMapFactory);
        return new FilterableClientToClient(partitionedClient, buildContext.executionContext.executionStrategy(), buildContext.builder.buildStrategyInfluencerForClient(buildContext.executionContext.executionStrategy()));
    }

    @Override
    public PartitionedHttpClientBuilder<U, R> ioExecutor(IoExecutor ioExecutor) {
        this.builderTemplate.ioExecutor(ioExecutor);
        return this;
    }

    @Override
    public PartitionedHttpClientBuilder<U, R> executor(Executor executor) {
        this.builderTemplate.executor(executor);
        return this;
    }

    @Override
    public PartitionedHttpClientBuilder<U, R> bufferAllocator(BufferAllocator allocator) {
        this.builderTemplate.bufferAllocator(allocator);
        return this;
    }

    @Override
    public <T> PartitionedHttpClientBuilder<U, R> socketOption(SocketOption<T> option, T value) {
        this.builderTemplate.socketOption((SocketOption)option, (Object)value);
        return this;
    }

    @Override
    @Deprecated
    public PartitionedHttpClientBuilder<U, R> enableWireLogging(String loggerName) {
        this.builderTemplate.enableWireLogging(loggerName);
        return this;
    }

    @Override
    public PartitionedHttpClientBuilder<U, R> enableWireLogging(String loggerName, LogLevel logLevel, BooleanSupplier logUserData) {
        this.builderTemplate.enableWireLogging(loggerName, logLevel, logUserData);
        return this;
    }

    @Override
    public PartitionedHttpClientBuilder<U, R> protocols(HttpProtocolConfig ... protocols) {
        this.builderTemplate.protocols(protocols);
        return this;
    }

    @Override
    public PartitionedHttpClientBuilder<U, R> appendConnectionFilter(StreamingHttpConnectionFilterFactory factory) {
        this.builderTemplate.appendConnectionFilter(factory);
        return this;
    }

    @Override
    public PartitionedHttpClientBuilder<U, R> appendConnectionFactoryFilter(ConnectionFactoryFilter<R, FilterableStreamingHttpConnection> factory) {
        this.builderTemplate.appendConnectionFactoryFilter((ConnectionFactoryFilter)factory);
        return this;
    }

    @Override
    public PartitionedHttpClientBuilder<U, R> disableHostHeaderFallback() {
        this.builderTemplate.disableHostHeaderFallback();
        return this;
    }

    @Override
    public PartitionedHttpClientBuilder<U, R> allowDropResponseTrailers(boolean allowDrop) {
        this.builderTemplate.allowDropResponseTrailers(allowDrop);
        return this;
    }

    @Override
    public PartitionedHttpClientBuilder<U, R> autoRetryStrategy(AutoRetryStrategyProvider autoRetryStrategyProvider) {
        this.builderTemplate.autoRetryStrategy(autoRetryStrategyProvider);
        return this;
    }

    @Override
    public PartitionedHttpClientBuilder<U, R> serviceDiscoverer(ServiceDiscoverer<U, R, PartitionedServiceDiscovererEvent<R>> serviceDiscoverer) {
        this.serviceDiscoverer = Objects.requireNonNull(serviceDiscoverer);
        return this;
    }

    public PartitionedHttpClientBuilder<U, R> retryServiceDiscoveryErrors(ServiceDiscoveryRetryStrategy<R, PartitionedServiceDiscovererEvent<R>> retryStrategy) {
        this.deprecatedServiceDiscovererRetryStrategy = Objects.requireNonNull(retryStrategy);
        this.serviceDiscovererRetryStrategy = null;
        return this;
    }

    public PartitionedHttpClientBuilder<U, R> retryServiceDiscoveryErrors(BiIntFunction<Throwable, ? extends Completable> retryStrategy) {
        this.serviceDiscovererRetryStrategy = Objects.requireNonNull(retryStrategy);
        this.deprecatedServiceDiscovererRetryStrategy = null;
        return this;
    }

    @Override
    public PartitionedHttpClientBuilder<U, R> loadBalancerFactory(HttpLoadBalancerFactory<R> loadBalancerFactory) {
        this.builderTemplate.loadBalancerFactory((HttpLoadBalancerFactory)loadBalancerFactory);
        return this;
    }

    @Override
    public PartitionedHttpClientBuilder<U, R> unresolvedAddressToHost(Function<U, CharSequence> unresolvedAddressToHostFunction) {
        this.builderTemplate.unresolvedAddressToHost((Function)unresolvedAddressToHostFunction);
        return this;
    }

    @Override
    public PartitionedHttpClientBuilder<U, R> appendClientFilter(StreamingHttpClientFilterFactory function) {
        this.builderTemplate.appendClientFilter(function);
        return this;
    }

    @Override
    @Deprecated
    public PartitionedHttpClientSecurityConfigurator<U, R> secure() {
        return new DefaultPartitionedHttpClientSecurityConfigurator<U, R>(this.builderTemplate.secure(), this);
    }

    @Override
    public PartitionedHttpClientBuilder<U, R> serviceDiscoveryMaxQueueSize(int serviceDiscoveryMaxQueueSize) {
        this.serviceDiscoveryMaxQueueSize = serviceDiscoveryMaxQueueSize;
        return this;
    }

    @Override
    public PartitionedHttpClientBuilder<U, R> partitionMapFactory(PartitionMapFactory partitionMapFactory) {
        this.partitionMapFactory = partitionMapFactory;
        return this;
    }

    @Override
    @Deprecated
    public PartitionedHttpClientBuilder<U, R> appendClientBuilderFilter(PartitionHttpClientBuilderConfigurator<U, R> clientFilterFunction) {
        this.clientFilterFunction = this.clientFilterFunction.append(clientFilterFunction);
        return this;
    }

    @Override
    public PartitionedHttpClientBuilder<U, R> initializer(PartitionedHttpClientBuilder.SingleAddressInitializer<U, R> initializer) {
        this.clientInitializer = Objects.requireNonNull(initializer);
        return this;
    }

    @Override
    public PartitionedHttpClientBuilder<U, R> executionStrategy(HttpExecutionStrategy strategy) {
        this.builderTemplate.executionStrategy(strategy);
        return this;
    }

    private static final class NoopPartitionClient
    implements FilterableStreamingHttpClient {
        private final ListenableAsyncCloseable close = AsyncCloseables.emptyAsyncCloseable();
        private final RuntimeException ex;

        NoopPartitionClient(RuntimeException ex) {
            this.ex = ex;
        }

        @Override
        public Single<StreamingHttpResponse> request(HttpExecutionStrategy strategy, StreamingHttpRequest request) {
            return Single.failed(this.ex);
        }

        @Override
        public HttpExecutionContext executionContext() {
            throw this.ex;
        }

        @Override
        public StreamingHttpResponseFactory httpResponseFactory() {
            throw this.ex;
        }

        @Override
        public Completable onClose() {
            return this.close.onClose();
        }

        @Override
        public Completable closeAsync() {
            return this.close.closeAsync();
        }

        @Override
        public Completable closeAsyncGracefully() {
            return this.close.closeAsyncGracefully();
        }

        public Single<ReservedStreamingHttpConnection> reserveConnection(HttpExecutionStrategy strategy, HttpRequestMetaData metaData) {
            return Single.failed(this.ex);
        }

        @Override
        public StreamingHttpRequest newRequest(HttpRequestMethod method, String requestTarget) {
            throw this.ex;
        }
    }

    private static final class DefaultPartitionedStreamingHttpClientFilter<U, R>
    implements FilterableStreamingHttpClient {
        private static final Function<PartitionAttributes, FilterableStreamingHttpClient> PARTITION_CLOSED = pa -> new NoopPartitionClient(new ClosedPartitionException((PartitionAttributes)pa, "Partition closed"));
        private static final Function<PartitionAttributes, FilterableStreamingHttpClient> PARTITION_UNKNOWN = pa -> new NoopPartitionClient(new UnknownPartitionException((PartitionAttributes)pa, "Partition unknown"));
        private final ClientGroup<PartitionAttributes, FilterableStreamingHttpClient> group;
        private final Function<HttpRequestMetaData, PartitionAttributesBuilder> pabf;
        private final HttpExecutionContext executionContext;
        private final StreamingHttpRequestResponseFactory reqRespFactory;

        DefaultPartitionedStreamingHttpClientFilter(Publisher<PartitionedServiceDiscovererEvent<R>> psdEvents, int psdMaxQueueSize, DefaultPartitionedClientGroup.PartitionedClientFactory<U, R, FilterableStreamingHttpClient> clientFactory, Function<HttpRequestMetaData, PartitionAttributesBuilder> pabf, StreamingHttpRequestResponseFactory reqRespFactory, HttpExecutionContext executionContext, PartitionMapFactory partitionMapFactory) {
            this.pabf = pabf;
            this.executionContext = executionContext;
            this.group = new DefaultPartitionedClientGroup<U, R, FilterableStreamingHttpClient>(PARTITION_CLOSED, PARTITION_UNKNOWN, clientFactory, partitionMapFactory, psdEvents, psdMaxQueueSize);
            this.reqRespFactory = Objects.requireNonNull(reqRespFactory);
        }

        private FilterableStreamingHttpClient selectClient(HttpRequestMetaData metaData) {
            return this.group.get(this.pabf.apply(metaData).build());
        }

        @Override
        public Single<? extends FilterableReservedStreamingHttpConnection> reserveConnection(HttpExecutionStrategy strategy, HttpRequestMetaData metaData) {
            return Single.defer(() -> this.selectClient(metaData).reserveConnection(strategy, metaData).shareContextOnSubscribe());
        }

        @Override
        public Single<StreamingHttpResponse> request(HttpExecutionStrategy strategy, StreamingHttpRequest request) {
            return Single.defer(() -> this.selectClient(request).request(strategy, request).shareContextOnSubscribe());
        }

        @Override
        public HttpExecutionContext executionContext() {
            return this.executionContext;
        }

        @Override
        public StreamingHttpResponseFactory httpResponseFactory() {
            return this.reqRespFactory;
        }

        @Override
        public Completable onClose() {
            return this.group.onClose();
        }

        @Override
        public Completable closeAsync() {
            return this.group.closeAsync();
        }

        @Override
        public Completable closeAsyncGracefully() {
            return this.group.closeAsyncGracefully();
        }

        @Override
        public StreamingHttpRequest newRequest(HttpRequestMethod method, String requestTarget) {
            return this.reqRespFactory.newRequest(method, requestTarget);
        }
    }
}

