/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.netty.handler.codec.http.HttpScheme;
import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.client.api.AutoRetryStrategyProvider;
import io.servicetalk.client.api.ClientGroup;
import io.servicetalk.client.api.ConnectionFactoryFilter;
import io.servicetalk.client.api.ServiceDiscoverer;
import io.servicetalk.client.api.ServiceDiscovererEvent;
import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.api.AsyncCloseable;
import io.servicetalk.concurrent.api.AsyncCloseables;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.CompositeCloseable;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.ListenableAsyncCloseable;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.api.internal.SubscribableCompletable;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import io.servicetalk.http.api.FilterableReservedStreamingHttpConnection;
import io.servicetalk.http.api.FilterableStreamingHttpClient;
import io.servicetalk.http.api.FilterableStreamingHttpConnection;
import io.servicetalk.http.api.HttpExecutionContext;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpLoadBalancerFactory;
import io.servicetalk.http.api.HttpProtocolConfig;
import io.servicetalk.http.api.HttpRequestMetaData;
import io.servicetalk.http.api.HttpRequestMethod;
import io.servicetalk.http.api.MultiAddressHttpClientBuilder;
import io.servicetalk.http.api.MultiAddressHttpClientFilterFactory;
import io.servicetalk.http.api.RedirectConfig;
import io.servicetalk.http.api.RedirectConfigBuilder;
import io.servicetalk.http.api.ServiceDiscoveryRetryStrategy;
import io.servicetalk.http.api.SingleAddressHttpClientSecurityConfigurator;
import io.servicetalk.http.api.StreamingHttpClient;
import io.servicetalk.http.api.StreamingHttpClientFilterFactory;
import io.servicetalk.http.api.StreamingHttpConnectionFilterFactory;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpRequestResponseFactory;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.api.StreamingHttpResponseFactory;
import io.servicetalk.http.netty.DefaultSingleAddressHttpClientBuilder;
import io.servicetalk.http.netty.FilterableClientToClient;
import io.servicetalk.http.netty.NewToDeprecatedFilter;
import io.servicetalk.http.utils.RedirectingHttpRequesterFilter;
import io.servicetalk.logging.api.LogLevel;
import io.servicetalk.transport.api.ClientSecurityConfigurator;
import io.servicetalk.transport.api.ClientSslConfig;
import io.servicetalk.transport.api.ClientSslConfigBuilder;
import io.servicetalk.transport.api.HostAndPort;
import io.servicetalk.transport.api.IoExecutor;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

final class DefaultMultiAddressUrlHttpClientBuilder
extends MultiAddressHttpClientBuilder<HostAndPort, InetSocketAddress> {
    private static final String HTTPS_SCHEME = HttpScheme.HTTPS.toString();
    private static final RedirectConfig DEFAULT_REDIRECT_CONFIG = new RedirectConfigBuilder().allowNonRelativeRedirects(true).allowedMethods(HttpRequestMethod.GET, HttpRequestMethod.HEAD, HttpRequestMethod.POST, HttpRequestMethod.PUT, HttpRequestMethod.DELETE, HttpRequestMethod.PATCH).build();
    private final DefaultSingleAddressHttpClientBuilder<HostAndPort, InetSocketAddress> builderTemplate;
    @Nullable
    private RedirectConfig redirectConfig = DEFAULT_REDIRECT_CONFIG;
    @Nullable
    private MultiAddressHttpClientFilterFactory<HostAndPort> clientFilterFactory;
    @Nullable
    private Function<HostAndPort, CharSequence> unresolvedAddressToHostFunction;
    @Nullable
    private BiConsumer<HostAndPort, ClientSecurityConfigurator> sslConfigFunction;
    @Nullable
    private MultiAddressHttpClientBuilder.SingleAddressInitializer<HostAndPort, InetSocketAddress> singleAddressInitializer;

    DefaultMultiAddressUrlHttpClientBuilder(DefaultSingleAddressHttpClientBuilder<HostAndPort, InetSocketAddress> builderTemplate) {
        this.builderTemplate = Objects.requireNonNull(builderTemplate);
    }

    @Override
    public StreamingHttpClient buildStreaming() {
        CompositeCloseable closeables = AsyncCloseables.newCompositeCloseable();
        try {
            DefaultSingleAddressHttpClientBuilder.HttpClientBuildContext<HostAndPort, InetSocketAddress> buildContext = this.builderTemplate.copyBuildCtx();
            ClientFactory clientFactory = new ClientFactory(buildContext.builder, this.clientFilterFactory, this.unresolvedAddressToHostFunction, this.sslConfigFunction, this.singleAddressInitializer);
            CachingKeyFactory keyFactory = closeables.prepend(new CachingKeyFactory());
            FilterableStreamingHttpClient urlClient = closeables.prepend(new StreamingUrlHttpClient(buildContext.executionContext, clientFactory, keyFactory, DefaultSingleAddressHttpClientBuilder.defaultReqRespFactory(buildContext.httpConfig().asReadOnly(), buildContext.executionContext.bufferAllocator())));
            urlClient = this.redirectConfig == null ? urlClient : new RedirectingHttpRequesterFilter(this.redirectConfig).create(NewToDeprecatedFilter.NEW_TO_DEPRECATED_FILTER.create(urlClient));
            return new FilterableClientToClient(urlClient, buildContext.executionContext.executionStrategy(), buildContext.builder.buildStrategyInfluencerForClient(buildContext.executionContext.executionStrategy()));
        }
        catch (Throwable t) {
            closeables.closeAsync().subscribe();
            throw t;
        }
    }

    @Override
    public MultiAddressHttpClientBuilder<HostAndPort, InetSocketAddress> ioExecutor(IoExecutor ioExecutor) {
        this.builderTemplate.ioExecutor(ioExecutor);
        return this;
    }

    @Override
    public MultiAddressHttpClientBuilder<HostAndPort, InetSocketAddress> executor(Executor executor) {
        this.builderTemplate.executor(executor);
        return this;
    }

    @Override
    public MultiAddressHttpClientBuilder<HostAndPort, InetSocketAddress> bufferAllocator(BufferAllocator allocator) {
        this.builderTemplate.bufferAllocator(allocator);
        return this;
    }

    @Override
    public <T> MultiAddressHttpClientBuilder<HostAndPort, InetSocketAddress> socketOption(SocketOption<T> option, T value) {
        this.builderTemplate.socketOption((SocketOption)option, (Object)value);
        return this;
    }

    @Override
    @Deprecated
    public MultiAddressHttpClientBuilder<HostAndPort, InetSocketAddress> enableWireLogging(String loggerName) {
        this.builderTemplate.enableWireLogging(loggerName);
        return this;
    }

    @Override
    public MultiAddressHttpClientBuilder<HostAndPort, InetSocketAddress> enableWireLogging(String loggerName, LogLevel logLevel, BooleanSupplier logUserData) {
        this.builderTemplate.enableWireLogging(loggerName, logLevel, logUserData);
        return this;
    }

    @Override
    public MultiAddressHttpClientBuilder<HostAndPort, InetSocketAddress> protocols(HttpProtocolConfig ... protocols) {
        this.builderTemplate.protocols(protocols);
        return this;
    }

    @Override
    @Deprecated
    public MultiAddressHttpClientBuilder<HostAndPort, InetSocketAddress> secure(BiConsumer<HostAndPort, ClientSecurityConfigurator> sslConfigFunction) {
        this.sslConfigFunction = Objects.requireNonNull(sslConfigFunction);
        return this;
    }

    @Override
    public MultiAddressHttpClientBuilder<HostAndPort, InetSocketAddress> initializer(MultiAddressHttpClientBuilder.SingleAddressInitializer<HostAndPort, InetSocketAddress> initializer) {
        this.singleAddressInitializer = Objects.requireNonNull(initializer);
        return this;
    }

    @Override
    public MultiAddressHttpClientBuilder<HostAndPort, InetSocketAddress> appendConnectionFilter(StreamingHttpConnectionFilterFactory factory) {
        this.builderTemplate.appendConnectionFilter(factory);
        return this;
    }

    @Override
    public MultiAddressHttpClientBuilder<HostAndPort, InetSocketAddress> appendConnectionFactoryFilter(ConnectionFactoryFilter<InetSocketAddress, FilterableStreamingHttpConnection> factory) {
        this.builderTemplate.appendConnectionFactoryFilter((ConnectionFactoryFilter)factory);
        return this;
    }

    @Override
    public MultiAddressHttpClientBuilder<HostAndPort, InetSocketAddress> appendClientFilter(StreamingHttpClientFilterFactory function) {
        this.clientFilterFactory = this.appendClientFilter(this.clientFilterFactory, function.asMultiAddressClientFilter());
        return this;
    }

    @Override
    public MultiAddressHttpClientBuilder<HostAndPort, InetSocketAddress> disableHostHeaderFallback() {
        this.builderTemplate.disableHostHeaderFallback();
        return this;
    }

    @Override
    public MultiAddressHttpClientBuilder<HostAndPort, InetSocketAddress> allowDropResponseTrailers(boolean allowDrop) {
        this.builderTemplate.allowDropResponseTrailers(allowDrop);
        return this;
    }

    @Override
    public MultiAddressHttpClientBuilder<HostAndPort, InetSocketAddress> autoRetryStrategy(AutoRetryStrategyProvider autoRetryStrategyProvider) {
        this.builderTemplate.autoRetryStrategy(autoRetryStrategyProvider);
        return this;
    }

    @Override
    public MultiAddressHttpClientBuilder<HostAndPort, InetSocketAddress> followRedirects(RedirectConfig config) {
        this.redirectConfig = Objects.requireNonNull(config);
        return this;
    }

    @Override
    public MultiAddressHttpClientBuilder<HostAndPort, InetSocketAddress> unresolvedAddressToHost(Function<HostAndPort, CharSequence> unresolvedAddressToHostFunction) {
        this.unresolvedAddressToHostFunction = Objects.requireNonNull(unresolvedAddressToHostFunction);
        return this;
    }

    @Override
    public MultiAddressHttpClientBuilder<HostAndPort, InetSocketAddress> appendClientFilter(MultiAddressHttpClientFilterFactory<HostAndPort> function) {
        this.clientFilterFactory = this.appendClientFilter(this.clientFilterFactory, function);
        return this;
    }

    private MultiAddressHttpClientFilterFactory<HostAndPort> appendClientFilter(@Nullable MultiAddressHttpClientFilterFactory<HostAndPort> current, MultiAddressHttpClientFilterFactory<HostAndPort> next) {
        Objects.requireNonNull(next);
        this.builderTemplate.appendToStrategyInfluencer(next);
        return DefaultMultiAddressUrlHttpClientBuilder.appendClientFilter0(DefaultMultiAddressUrlHttpClientBuilder.appendClientFilter0(current, next), NewToDeprecatedFilter.NEW_TO_DEPRECATED_FILTER.asMultiAddressClientFilter());
    }

    @Nonnull
    private static MultiAddressHttpClientFilterFactory<HostAndPort> appendClientFilter0(@Nullable MultiAddressHttpClientFilterFactory<HostAndPort> current, MultiAddressHttpClientFilterFactory<HostAndPort> next) {
        return current == null ? next : (group, client) -> current.create((HostAndPort)group, next.create((HostAndPort)group, client));
    }

    @Override
    public MultiAddressHttpClientBuilder<HostAndPort, InetSocketAddress> serviceDiscoverer(ServiceDiscoverer<HostAndPort, InetSocketAddress, ServiceDiscovererEvent<InetSocketAddress>> sd) {
        this.builderTemplate.serviceDiscoverer((ServiceDiscoverer)sd);
        return this;
    }

    @Override
    public MultiAddressHttpClientBuilder<HostAndPort, InetSocketAddress> retryServiceDiscoveryErrors(ServiceDiscoveryRetryStrategy<InetSocketAddress, ServiceDiscovererEvent<InetSocketAddress>> retryStrategy) {
        this.builderTemplate.retryServiceDiscoveryErrors((ServiceDiscoveryRetryStrategy)retryStrategy);
        return this;
    }

    @Override
    public MultiAddressHttpClientBuilder<HostAndPort, InetSocketAddress> loadBalancerFactory(HttpLoadBalancerFactory<InetSocketAddress> loadBalancerFactory) {
        this.builderTemplate.loadBalancerFactory((HttpLoadBalancerFactory)loadBalancerFactory);
        return this;
    }

    @Override
    public MultiAddressHttpClientBuilder<HostAndPort, InetSocketAddress> executionStrategy(HttpExecutionStrategy strategy) {
        this.builderTemplate.executionStrategy(strategy);
        return this;
    }

    private static final class StreamingUrlHttpClient
    implements FilterableStreamingHttpClient {
        private final HttpExecutionContext executionContext;
        private final StreamingHttpRequestResponseFactory reqRespFactory;
        private final ClientGroup<UrlKey, FilterableStreamingHttpClient> group;
        private final CachingKeyFactory keyFactory;
        private final ListenableAsyncCloseable closeable;

        StreamingUrlHttpClient(HttpExecutionContext executionContext, Function<UrlKey, FilterableStreamingHttpClient> clientFactory, CachingKeyFactory keyFactory, StreamingHttpRequestResponseFactory reqRespFactory) {
            this.reqRespFactory = Objects.requireNonNull(reqRespFactory);
            this.group = ClientGroup.from(clientFactory);
            this.keyFactory = keyFactory;
            CompositeCloseable compositeCloseable = AsyncCloseables.newCompositeCloseable();
            compositeCloseable.append(this.group);
            compositeCloseable.append(keyFactory);
            this.closeable = AsyncCloseables.toListenableAsyncCloseable(compositeCloseable);
            this.executionContext = Objects.requireNonNull(executionContext);
        }

        private FilterableStreamingHttpClient selectClient(HttpRequestMetaData metaData) {
            return this.group.get(this.keyFactory.apply(metaData));
        }

        @Override
        public Single<? extends FilterableReservedStreamingHttpConnection> reserveConnection(HttpExecutionStrategy strategy, HttpRequestMetaData metaData) {
            return Single.defer(() -> this.selectClient(metaData).reserveConnection(strategy, metaData).shareContextOnSubscribe());
        }

        @Override
        public Single<StreamingHttpResponse> request(HttpExecutionStrategy strategy, StreamingHttpRequest request) {
            return Single.defer(() -> this.selectClient(request).request(strategy, request).shareContextOnSubscribe());
        }

        @Override
        public HttpExecutionContext executionContext() {
            return this.executionContext;
        }

        @Override
        public StreamingHttpResponseFactory httpResponseFactory() {
            return this.reqRespFactory;
        }

        @Override
        public Completable onClose() {
            return this.closeable.onClose();
        }

        @Override
        public Completable closeAsync() {
            return this.closeable.closeAsync();
        }

        @Override
        public Completable closeAsyncGracefully() {
            return this.closeable.closeAsyncGracefully();
        }

        @Override
        public StreamingHttpRequest newRequest(HttpRequestMethod method, String requestTarget) {
            return this.reqRespFactory.newRequest(method, requestTarget);
        }
    }

    private static final class ClientFactory
    implements Function<UrlKey, FilterableStreamingHttpClient> {
        private static final ClientSslConfig DEFAULT_CLIENT_SSL_CONFIG = new ClientSslConfigBuilder().build();
        private final DefaultSingleAddressHttpClientBuilder<HostAndPort, InetSocketAddress> builderTemplate;
        @Nullable
        private final MultiAddressHttpClientFilterFactory<HostAndPort> clientFilterFactory;
        @Nullable
        private final Function<HostAndPort, CharSequence> hostHeaderTransformer;
        @Nullable
        private final BiConsumer<HostAndPort, ClientSecurityConfigurator> sslConfigFunction;
        @Nullable
        private final MultiAddressHttpClientBuilder.SingleAddressInitializer<HostAndPort, InetSocketAddress> singleAddressInitializer;

        ClientFactory(DefaultSingleAddressHttpClientBuilder<HostAndPort, InetSocketAddress> builderTemplate, @Nullable MultiAddressHttpClientFilterFactory<HostAndPort> clientFilterFactory, @Nullable Function<HostAndPort, CharSequence> hostHeaderTransformer, @Nullable BiConsumer<HostAndPort, ClientSecurityConfigurator> sslConfigFunction, @Nullable MultiAddressHttpClientBuilder.SingleAddressInitializer<HostAndPort, InetSocketAddress> singleAddressInitializer) {
            this.builderTemplate = builderTemplate;
            this.clientFilterFactory = clientFilterFactory;
            this.hostHeaderTransformer = hostHeaderTransformer;
            this.sslConfigFunction = sslConfigFunction;
            this.singleAddressInitializer = singleAddressInitializer;
        }

        @Override
        public StreamingHttpClient apply(UrlKey urlKey) {
            DefaultSingleAddressHttpClientBuilder.HttpClientBuildContext<HostAndPort, InetSocketAddress> buildContext = this.builderTemplate.copyBuildCtx(urlKey.hostAndPort);
            if (this.hostHeaderTransformer != null) {
                buildContext.builder.unresolvedAddressToHost(this.hostHeaderTransformer);
            }
            if (this.clientFilterFactory != null) {
                buildContext.builder.appendClientFilter(this.clientFilterFactory.asClientFilter(urlKey.hostAndPort));
            }
            if (HTTPS_SCHEME.equalsIgnoreCase(urlKey.scheme)) {
                if (this.sslConfigFunction != null) {
                    SingleAddressHttpClientSecurityConfigurator securityConfigurator = buildContext.builder.secure();
                    this.sslConfigFunction.accept(urlKey.hostAndPort, securityConfigurator);
                    securityConfigurator.commit();
                } else {
                    buildContext.builder.sslConfig(DEFAULT_CLIENT_SSL_CONFIG);
                }
            }
            if (this.singleAddressInitializer != null) {
                this.singleAddressInitializer.initialize(urlKey.scheme, urlKey.hostAndPort, buildContext.builder);
            }
            return buildContext.build();
        }
    }

    private static final class UrlKey {
        final String scheme;
        final HostAndPort hostAndPort;

        UrlKey(String scheme, HostAndPort hostAndPort) {
            this.scheme = scheme;
            this.hostAndPort = hostAndPort;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UrlKey urlKey = (UrlKey)o;
            return this.scheme.equals(urlKey.scheme) && this.hostAndPort.equals(urlKey.hostAndPort);
        }

        public int hashCode() {
            return 31 * this.hostAndPort.hashCode() + this.scheme.hashCode();
        }
    }

    private static final class CachingKeyFactory
    implements Function<HttpRequestMetaData, UrlKey>,
    AsyncCloseable {
        private final ConcurrentMap<String, UrlKey> urlKeyCache = new ConcurrentHashMap<String, UrlKey>();

        private CachingKeyFactory() {
        }

        @Override
        public UrlKey apply(HttpRequestMetaData metaData) {
            String host = metaData.host();
            if (host == null) {
                throw new IllegalArgumentException("Request-target does not contain target host address: " + metaData.requestTarget() + ", expected absolute-form URL");
            }
            String scheme = metaData.scheme();
            if (scheme == null) {
                throw new IllegalArgumentException("Request-target does not contains scheme: " + metaData.requestTarget() + ", expected absolute-form URL");
            }
            int parsedPort = metaData.port();
            int port = parsedPort >= 0 ? parsedPort : (HTTPS_SCHEME.equalsIgnoreCase(scheme) ? HttpScheme.HTTPS : HttpScheme.HTTP).port();
            metaData.requestTarget(CachingKeyFactory.absoluteToRelativeFormRequestTarget(metaData.requestTarget(), scheme, host));
            String key = scheme + ':' + host + ':' + port;
            UrlKey urlKey = (UrlKey)this.urlKeyCache.get(key);
            return urlKey != null ? urlKey : this.urlKeyCache.computeIfAbsent(key, ignore -> new UrlKey(scheme, HostAndPort.of(host, port)));
        }

        private static String absoluteToRelativeFormRequestTarget(String requestTarget, String scheme, String host) {
            int fromIndex = scheme.length() + 3 + host.length();
            int relativeReferenceIdx = requestTarget.indexOf(47, fromIndex);
            return relativeReferenceIdx < 0 ? "/" : requestTarget.substring(relativeReferenceIdx);
        }

        @Override
        public Completable closeAsync() {
            return new SubscribableCompletable(){

                @Override
                protected void handleSubscribe(CompletableSource.Subscriber subscriber) {
                    urlKeyCache.clear();
                    SubscriberUtils.deliverCompleteFromSource(subscriber);
                }
            };
        }
    }
}

