/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.http.api.HttpExceptionMapperServiceFilter;
import io.servicetalk.http.api.HttpExecutionContext;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpExecutionStrategyInfluencer;
import io.servicetalk.http.api.HttpLifecycleObserver;
import io.servicetalk.http.api.HttpProtocolConfig;
import io.servicetalk.http.api.HttpServerBuilder;
import io.servicetalk.http.api.HttpServerSecurityConfigurator;
import io.servicetalk.http.api.HttpServiceContext;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.api.StreamingHttpResponseFactory;
import io.servicetalk.http.api.StreamingHttpService;
import io.servicetalk.http.api.StreamingHttpServiceFilter;
import io.servicetalk.http.api.StreamingHttpServiceFilterFactory;
import io.servicetalk.http.netty.DefaultHttpServerSecurityConfigurator;
import io.servicetalk.http.netty.DeferredServerChannelBinder;
import io.servicetalk.http.netty.H2ServerParentConnectionContext;
import io.servicetalk.http.netty.HttpExecutionContextBuilder;
import io.servicetalk.http.netty.HttpKeepAlive;
import io.servicetalk.http.netty.HttpLifecycleObserverServiceFilter;
import io.servicetalk.http.netty.HttpServerConfig;
import io.servicetalk.http.netty.NettyHttpServer;
import io.servicetalk.http.netty.ReadOnlyHttpServerConfig;
import io.servicetalk.logging.api.LogLevel;
import io.servicetalk.transport.api.ConnectionAcceptor;
import io.servicetalk.transport.api.IoExecutor;
import io.servicetalk.transport.api.ServerContext;
import io.servicetalk.transport.api.ServerSslConfig;
import io.servicetalk.transport.api.ServiceTalkSocketOptions;
import io.servicetalk.transport.api.TransportObserver;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.util.Map;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;

final class DefaultHttpServerBuilder
extends HttpServerBuilder {
    private final HttpServerConfig config = new HttpServerConfig();
    private final HttpExecutionContextBuilder executionContextBuilder = new HttpExecutionContextBuilder();
    private final SocketAddress address;

    DefaultHttpServerBuilder(SocketAddress address) {
        this.address = address;
    }

    @Override
    public HttpServerBuilder protocols(HttpProtocolConfig ... protocols) {
        this.config.httpConfig().protocols(protocols);
        return this;
    }

    @Override
    @Deprecated
    public HttpServerBuilder backlog(int backlog) {
        this.listenSocketOption(ServiceTalkSocketOptions.SO_BACKLOG, backlog);
        return this;
    }

    @Override
    @Deprecated
    public HttpServerSecurityConfigurator secure() {
        return new DefaultHttpServerSecurityConfigurator(config -> {
            this.config.tcpConfig().sslConfig(config);
            return this;
        });
    }

    @Override
    public HttpServerBuilder sslConfig(ServerSslConfig config) {
        this.config.tcpConfig().sslConfig(config);
        return this;
    }

    @Override
    public HttpServerBuilder sslConfig(ServerSslConfig defaultConfig, Map<String, ServerSslConfig> sniMap) {
        this.config.tcpConfig().sslConfig(defaultConfig, sniMap);
        return this;
    }

    @Override
    public <T> HttpServerBuilder socketOption(SocketOption<T> option, T value) {
        this.config.tcpConfig().socketOption(option, value);
        return this;
    }

    @Override
    public <T> HttpServerBuilder listenSocketOption(SocketOption<T> option, T value) {
        this.config.tcpConfig().listenSocketOption(option, value);
        return this;
    }

    @Override
    public HttpServerBuilder enableWireLogging(String loggerName) {
        this.config.tcpConfig().enableWireLogging(loggerName);
        return this;
    }

    @Override
    public HttpServerBuilder enableWireLogging(String loggerName, LogLevel logLevel, BooleanSupplier logUserData) {
        this.config.tcpConfig().enableWireLogging(loggerName, logLevel, logUserData);
        return this;
    }

    @Override
    public HttpServerBuilder transportObserver(TransportObserver transportObserver) {
        this.config.tcpConfig().transportObserver(transportObserver);
        return this;
    }

    @Override
    public HttpServerBuilder lifecycleObserver(HttpLifecycleObserver lifecycleObserver) {
        this.config.lifecycleObserver(lifecycleObserver);
        return this;
    }

    @Override
    public HttpServerBuilder allowDropRequestTrailers(boolean allowDrop) {
        this.config.httpConfig().allowDropTrailersReadFromTransport(allowDrop);
        return this;
    }

    @Override
    public HttpServerBuilder ioExecutor(IoExecutor ioExecutor) {
        this.executionContextBuilder.ioExecutor(ioExecutor);
        return this;
    }

    @Override
    public HttpServerBuilder executor(Executor executor) {
        this.executionContextBuilder.executor(executor);
        return this;
    }

    @Override
    public HttpServerBuilder bufferAllocator(BufferAllocator allocator) {
        this.executionContextBuilder.bufferAllocator(allocator);
        return this;
    }

    @Override
    protected Single<ServerContext> doListen(@Nullable ConnectionAcceptor connectionAcceptor, StreamingHttpService service, HttpExecutionStrategy strategy, boolean drainRequestPayloadBody) {
        ReadOnlyHttpServerConfig roConfig = this.config.asReadOnly();
        service = DefaultHttpServerBuilder.applyInternalFilters(service, roConfig.lifecycleObserver());
        this.executionContextBuilder.executionStrategy(strategy);
        HttpExecutionContext httpExecutionContext = this.executionContextBuilder.build();
        if (roConfig.tcpConfig().isAlpnConfigured()) {
            return DeferredServerChannelBinder.bind(httpExecutionContext, roConfig, this.address, connectionAcceptor, service, drainRequestPayloadBody, false);
        }
        if (roConfig.tcpConfig().sniMapping() != null) {
            return DeferredServerChannelBinder.bind(httpExecutionContext, roConfig, this.address, connectionAcceptor, service, drainRequestPayloadBody, true);
        }
        if (roConfig.isH2PriorKnowledge()) {
            return H2ServerParentConnectionContext.bind(httpExecutionContext, roConfig, this.address, connectionAcceptor, service, drainRequestPayloadBody);
        }
        return NettyHttpServer.bind(httpExecutionContext, roConfig, this.address, connectionAcceptor, service, drainRequestPayloadBody);
    }

    private static StreamingHttpService applyInternalFilters(StreamingHttpService service, @Nullable HttpLifecycleObserver lifecycleObserver) {
        service = HttpExceptionMapperServiceFilter.INSTANCE.create(service);
        service = KeepAliveServiceFilter.INSTANCE.create(service);
        if (lifecycleObserver != null) {
            service = new HttpLifecycleObserverServiceFilter(lifecycleObserver).create(service);
        }
        return service;
    }

    private static final class KeepAliveServiceFilter
    implements StreamingHttpServiceFilterFactory,
    HttpExecutionStrategyInfluencer {
        static final StreamingHttpServiceFilterFactory INSTANCE = new KeepAliveServiceFilter();

        private KeepAliveServiceFilter() {
        }

        @Override
        public StreamingHttpServiceFilter create(StreamingHttpService service) {
            return new StreamingHttpServiceFilter(service){

                @Override
                public Single<StreamingHttpResponse> handle(HttpServiceContext ctx, StreamingHttpRequest request, StreamingHttpResponseFactory responseFactory) {
                    HttpKeepAlive keepAlive = HttpKeepAlive.responseKeepAlive(request);
                    return this.delegate().handle(ctx, request, responseFactory).map(response -> {
                        keepAlive.addConnectionHeaderIfNecessary((StreamingHttpResponse)response);
                        return response;
                    });
                }
            };
        }

        @Override
        public HttpExecutionStrategy influenceStrategy(HttpExecutionStrategy strategy) {
            return strategy;
        }
    }
}

