/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.concurrent.BlockingIterable;
import io.servicetalk.http.api.BlockingHttpClient;
import io.servicetalk.http.api.BlockingUtils;
import io.servicetalk.http.api.DelegatingHttpConnectionContext;
import io.servicetalk.http.api.DelegatingHttpExecutionContext;
import io.servicetalk.http.api.HttpApiConversions;
import io.servicetalk.http.api.HttpConnectionContext;
import io.servicetalk.http.api.HttpEventKey;
import io.servicetalk.http.api.HttpExecutionContext;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpExecutionStrategyInfluencer;
import io.servicetalk.http.api.HttpRequest;
import io.servicetalk.http.api.HttpRequestMetaData;
import io.servicetalk.http.api.HttpRequestMethod;
import io.servicetalk.http.api.HttpRequestResponseFactory;
import io.servicetalk.http.api.HttpResponse;
import io.servicetalk.http.api.HttpResponseFactory;
import io.servicetalk.http.api.RequestResponseFactories;
import io.servicetalk.http.api.ReservedBlockingHttpConnection;
import io.servicetalk.http.api.ReservedStreamingHttpConnection;
import io.servicetalk.http.api.StreamingHttpClient;
import io.servicetalk.http.api.StreamingHttpConnectionToBlockingHttpConnection;
import java.util.Objects;

final class StreamingHttpClientToBlockingHttpClient
implements BlockingHttpClient {
    private final StreamingHttpClient client;
    private final HttpExecutionStrategy strategy;
    private final HttpExecutionContext context;
    private final HttpRequestResponseFactory reqRespFactory;

    StreamingHttpClientToBlockingHttpClient(StreamingHttpClient client, HttpExecutionStrategyInfluencer influencer) {
        this.strategy = influencer.influenceStrategy(StreamingHttpConnectionToBlockingHttpConnection.DEFAULT_BLOCKING_CONNECTION_STRATEGY);
        this.client = client;
        this.context = new DelegatingHttpExecutionContext(client.executionContext()){

            @Override
            public HttpExecutionStrategy executionStrategy() {
                return StreamingHttpClientToBlockingHttpClient.this.strategy;
            }
        };
        this.reqRespFactory = RequestResponseFactories.toAggregated(client);
    }

    @Override
    public HttpResponse request(HttpRequest request) throws Exception {
        return this.request(HttpApiConversions.requestStrategy(request, this.strategy), request);
    }

    @Override
    public ReservedBlockingHttpConnection reserveConnection(HttpRequestMetaData metaData) throws Exception {
        return this.reserveConnection(HttpApiConversions.requestStrategy(metaData, this.strategy), metaData);
    }

    @Override
    public ReservedBlockingHttpConnection reserveConnection(HttpExecutionStrategy strategy, HttpRequestMetaData metaData) throws Exception {
        return BlockingUtils.blockingInvocation(this.client.reserveConnection(strategy, metaData).map(c -> new ReservedStreamingHttpConnectionToReservedBlockingHttpConnection((ReservedStreamingHttpConnection)c, this.strategy, this.reqRespFactory)));
    }

    @Override
    public StreamingHttpClient asStreamingClient() {
        return this.client;
    }

    @Override
    public HttpResponse request(HttpExecutionStrategy strategy, HttpRequest request) throws Exception {
        return BlockingUtils.request(this.client, strategy, request);
    }

    @Override
    public HttpExecutionContext executionContext() {
        return this.context;
    }

    @Override
    public HttpResponseFactory httpResponseFactory() {
        return this.reqRespFactory;
    }

    @Override
    public void close() throws Exception {
        this.client.close();
    }

    @Override
    public void closeGracefully() throws Exception {
        this.client.closeGracefully();
    }

    @Override
    public HttpRequest newRequest(HttpRequestMethod method, String requestTarget) {
        return this.reqRespFactory.newRequest(method, requestTarget);
    }

    static final class ReservedStreamingHttpConnectionToReservedBlockingHttpConnection
    implements ReservedBlockingHttpConnection {
        private final ReservedStreamingHttpConnection connection;
        private final HttpExecutionStrategy strategy;
        private final HttpConnectionContext context;
        private final HttpExecutionContext executionContext;
        private final HttpRequestResponseFactory reqRespFactory;

        ReservedStreamingHttpConnectionToReservedBlockingHttpConnection(ReservedStreamingHttpConnection connection, HttpExecutionStrategyInfluencer influencer) {
            this(connection, influencer.influenceStrategy(StreamingHttpConnectionToBlockingHttpConnection.DEFAULT_BLOCKING_CONNECTION_STRATEGY), RequestResponseFactories.toAggregated(connection));
        }

        ReservedStreamingHttpConnectionToReservedBlockingHttpConnection(ReservedStreamingHttpConnection connection, final HttpExecutionStrategy strategy, HttpRequestResponseFactory reqRespFactory) {
            this.strategy = strategy;
            this.connection = Objects.requireNonNull(connection);
            HttpConnectionContext originalCtx = connection.connectionContext();
            this.executionContext = new DelegatingHttpExecutionContext(connection.executionContext()){

                @Override
                public HttpExecutionStrategy executionStrategy() {
                    return strategy;
                }
            };
            this.context = new DelegatingHttpConnectionContext(originalCtx){

                @Override
                public HttpExecutionContext executionContext() {
                    return executionContext;
                }
            };
            this.reqRespFactory = Objects.requireNonNull(reqRespFactory);
        }

        @Override
        public void release() throws Exception {
            BlockingUtils.blockingInvocation(this.connection.releaseAsync());
        }

        @Override
        public ReservedStreamingHttpConnection asStreamingConnection() {
            return this.connection;
        }

        @Override
        public HttpResponse request(HttpRequest request) throws Exception {
            return this.request(HttpApiConversions.requestStrategy(request, this.strategy), request);
        }

        @Override
        public HttpConnectionContext connectionContext() {
            return this.context;
        }

        @Override
        public <T> BlockingIterable<? extends T> transportEventIterable(HttpEventKey<T> eventKey) {
            return this.connection.transportEventStream(eventKey).toIterable();
        }

        @Override
        public HttpResponse request(HttpExecutionStrategy strategy, HttpRequest request) throws Exception {
            return BlockingUtils.request(this.connection, strategy, request);
        }

        @Override
        public HttpExecutionContext executionContext() {
            return this.executionContext;
        }

        @Override
        public HttpResponseFactory httpResponseFactory() {
            return this.reqRespFactory;
        }

        @Override
        public void close() throws Exception {
            this.connection.close();
        }

        @Override
        public void closeGracefully() throws Exception {
            this.connection.closeGracefully();
        }

        @Override
        public HttpRequest newRequest(HttpRequestMethod method, String requestTarget) {
            return this.reqRespFactory.newRequest(method, requestTarget);
        }
    }
}

