/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.http.api.ConditionalHttpClientFilter;
import io.servicetalk.http.api.ConditionalHttpConnectionFilter;
import io.servicetalk.http.api.ConditionalHttpServiceFilter;
import io.servicetalk.http.api.ContextAwareStreamingHttpClientFilterFactory;
import io.servicetalk.http.api.FilterableStreamingHttpClient;
import io.servicetalk.http.api.FilterableStreamingHttpConnection;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpExecutionStrategyInfluencer;
import io.servicetalk.http.api.MultiAddressHttpClientFilterFactory;
import io.servicetalk.http.api.NewToDeprecatedFilter;
import io.servicetalk.http.api.StreamingHttpClientFilter;
import io.servicetalk.http.api.StreamingHttpClientFilterFactory;
import io.servicetalk.http.api.StreamingHttpConnectionFilter;
import io.servicetalk.http.api.StreamingHttpConnectionFilterFactory;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpService;
import io.servicetalk.http.api.StreamingHttpServiceFilter;
import io.servicetalk.http.api.StreamingHttpServiceFilterFactory;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;

final class StrategyInfluencerAwareConversions {
    private StrategyInfluencerAwareConversions() {
    }

    static <U> StreamingHttpClientFilterFactory toClientFactory(final U address, final MultiAddressHttpClientFilterFactory<U> original) {
        Objects.requireNonNull(address);
        if (original instanceof HttpExecutionStrategyInfluencer) {
            final HttpExecutionStrategyInfluencer influencer = (HttpExecutionStrategyInfluencer)((Object)original);
            return new StrategyInfluencingStreamingClientFilterFactory(){

                @Override
                public HttpExecutionStrategy influenceStrategy(HttpExecutionStrategy strategy) {
                    return influencer.influenceStrategy(strategy);
                }

                @Override
                public StreamingHttpClientFilter create(FilterableStreamingHttpClient client, @Nullable Publisher<Object> lbEventStream, @Nullable Completable sdStatus) {
                    return original.create(address, client);
                }
            };
        }
        return client -> new StreamingHttpClientFilter(original.create(address, client));
    }

    static <U> MultiAddressHttpClientFilterFactory<U> toMultiAddressClientFactory(final StreamingHttpClientFilterFactory original) {
        if (original instanceof HttpExecutionStrategyInfluencer) {
            final HttpExecutionStrategyInfluencer influencer = (HttpExecutionStrategyInfluencer)((Object)original);
            return new StrategyInfluencingMultiAddressHttpClientFilterFactory<U>(){

                @Override
                public HttpExecutionStrategy influenceStrategy(HttpExecutionStrategy strategy) {
                    return influencer.influenceStrategy(strategy);
                }

                @Override
                public StreamingHttpClientFilter create(U address, FilterableStreamingHttpClient client) {
                    return new StreamingHttpClientFilter(original.create(client));
                }
            };
        }
        return (address, client) -> new StreamingHttpClientFilter(NewToDeprecatedFilter.NEW_TO_DEPRECATED_FILTER.create(original.create(client)));
    }

    static StreamingHttpServiceFilterFactory toConditionalServiceFilterFactory(final Predicate<StreamingHttpRequest> predicate, final StreamingHttpServiceFilterFactory original) {
        Objects.requireNonNull(predicate);
        Objects.requireNonNull(original);
        if (original instanceof HttpExecutionStrategyInfluencer) {
            final HttpExecutionStrategyInfluencer influencer = (HttpExecutionStrategyInfluencer)((Object)original);
            return new StrategyInfluencingStreamingServiceFilterFactory(){

                @Override
                public StreamingHttpServiceFilter create(StreamingHttpService service) {
                    return new ConditionalHttpServiceFilter(predicate, original.create(service), service);
                }

                @Override
                public HttpExecutionStrategy influenceStrategy(HttpExecutionStrategy strategy) {
                    return influencer.influenceStrategy(strategy);
                }
            };
        }
        return service -> new ConditionalHttpServiceFilter(predicate, original.create(service), service);
    }

    static StreamingHttpConnectionFilterFactory toConditionalConnectionFilterFactory(final Predicate<StreamingHttpRequest> predicate, final StreamingHttpConnectionFilterFactory original) {
        Objects.requireNonNull(predicate);
        Objects.requireNonNull(original);
        if (original instanceof HttpExecutionStrategyInfluencer) {
            final HttpExecutionStrategyInfluencer influencer = (HttpExecutionStrategyInfluencer)((Object)original);
            return new StrategyInfluencingStreamingConnectionFilterFactory(){

                @Override
                public HttpExecutionStrategy influenceStrategy(HttpExecutionStrategy strategy) {
                    return influencer.influenceStrategy(strategy);
                }

                @Override
                public StreamingHttpConnectionFilter create(FilterableStreamingHttpConnection connection) {
                    return new ConditionalHttpConnectionFilter(predicate, original.create(connection), connection);
                }
            };
        }
        return connection -> new ConditionalHttpConnectionFilter(predicate, original.create(connection), connection);
    }

    static ContextAwareStreamingHttpClientFilterFactory toConditionalClientFilterFactory(final Predicate<StreamingHttpRequest> predicate, final StreamingHttpClientFilterFactory original) {
        Objects.requireNonNull(predicate);
        Objects.requireNonNull(original);
        if (original instanceof HttpExecutionStrategyInfluencer) {
            final HttpExecutionStrategyInfluencer influencer = (HttpExecutionStrategyInfluencer)((Object)original);
            return new StrategyInfluencingStreamingClientFilterFactory(){

                @Override
                public HttpExecutionStrategy influenceStrategy(HttpExecutionStrategy strategy) {
                    return influencer.influenceStrategy(strategy);
                }

                @Override
                public StreamingHttpClientFilter create(FilterableStreamingHttpClient client, @Nullable Publisher<Object> lbEventStream, @Nullable Completable sdStatus) {
                    if (original instanceof ContextAwareStreamingHttpClientFilterFactory) {
                        return new ConditionalHttpClientFilter(predicate, ((ContextAwareStreamingHttpClientFilterFactory)original).create(client, lbEventStream, sdStatus), client);
                    }
                    return new ConditionalHttpClientFilter(predicate, original.create(client), client);
                }
            };
        }
        if (original instanceof ContextAwareStreamingHttpClientFilterFactory) {
            return (client, lbEventStream, sdStatus) -> new ConditionalHttpClientFilter(predicate, ((ContextAwareStreamingHttpClientFilterFactory)original).create(client, lbEventStream, sdStatus), client);
        }
        return (client, __, ___) -> new ConditionalHttpClientFilter(predicate, original.create(client), client);
    }

    static <U> MultiAddressHttpClientFilterFactory<U> toMultiAddressConditionalFilterFactory(final Predicate<StreamingHttpRequest> predicate, final MultiAddressHttpClientFilterFactory<U> original) {
        Objects.requireNonNull(predicate);
        Objects.requireNonNull(original);
        if (original instanceof HttpExecutionStrategyInfluencer) {
            final HttpExecutionStrategyInfluencer influencer = (HttpExecutionStrategyInfluencer)((Object)original);
            return new StrategyInfluencingMultiAddressHttpClientFilterFactory<U>(){

                @Override
                public HttpExecutionStrategy influenceStrategy(HttpExecutionStrategy strategy) {
                    return influencer.influenceStrategy(strategy);
                }

                @Override
                public StreamingHttpClientFilter create(U address, FilterableStreamingHttpClient client) {
                    return new ConditionalHttpClientFilter(predicate, original.create(address, client), client);
                }
            };
        }
        return (address, client) -> new ConditionalHttpClientFilter(predicate, original.create(address, client), client);
    }

    static interface StrategyInfluencingMultiAddressHttpClientFilterFactory<U>
    extends MultiAddressHttpClientFilterFactory<U>,
    HttpExecutionStrategyInfluencer {
    }

    static interface StrategyInfluencingStreamingClientFilterFactory
    extends ContextAwareStreamingHttpClientFilterFactory,
    HttpExecutionStrategyInfluencer {
    }

    static interface StrategyInfluencingStreamingConnectionFilterFactory
    extends StreamingHttpConnectionFilterFactory,
    HttpExecutionStrategyInfluencer {
    }

    static interface StrategyInfluencingStreamingServiceFilterFactory
    extends StreamingHttpServiceFilterFactory,
    HttpExecutionStrategyInfluencer {
    }
}

