/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.utils.internal.MathUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;

abstract class MultiMap<K, V> {
    final BucketHead<K, V>[] entries;
    @Nullable
    BucketHead<K, V> lastBucketHead;
    private final byte hashMask;
    private int size;

    MultiMap(int arraySizeHint) {
        this.entries = new BucketHead[MathUtils.findNextPositivePowerOfTwo(Math.max(2, Math.min(arraySizeHint, 128)))];
        this.hashMask = (byte)(this.entries.length - 1);
    }

    protected abstract int hashCode(K var1);

    protected abstract boolean equals(K var1, K var2);

    protected abstract boolean isKeyEqualityCompatible(MultiMap<? extends K, ? extends V> var1);

    protected abstract K validateKey(K var1);

    protected abstract V validateValue(V var1);

    protected abstract int hashCodeForValue(V var1);

    protected abstract boolean equalsForValue(V var1, V var2);

    private MultiMapEntry<K, V> newEntry(K key, V value, int keyHash) {
        return new MultiMapEntry<K, V>(key, value, keyHash);
    }

    final Set<? extends K> getKeys() {
        if (this.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet names = new HashSet((int)((double)this.size() / 0.75), 0.75f);
        BucketHead<K, V> bucketHead = this.lastBucketHead;
        while (bucketHead != null) {
            MultiMapEntry e = bucketHead.entry;
            assert (e != null);
            do {
                names.add(e.getKey());
            } while ((e = e.bucketNext) != null);
            bucketHead = bucketHead.prevBucketHead;
        }
        return names;
    }

    public final int size() {
        return this.size;
    }

    public final boolean isEmpty() {
        return this.lastBucketHead == null;
    }

    @Nullable
    final V getValue(K key) {
        int nameHash = this.hashCode(key);
        int i = this.index(nameHash);
        BucketHead<K, V> bucketHead = this.entries[i];
        if (bucketHead != null) {
            MultiMapEntry e = bucketHead.entry;
            assert (e != null);
            do {
                if (e.keyHash != nameHash || !this.equals(key, e.getKey())) continue;
                return e.value;
            } while ((e = e.bucketNext) != null);
        }
        return null;
    }

    final Iterator<? extends V> getValues(K key) {
        int keyHash = this.hashCode(key);
        BucketHead<K, V> bucketHead = this.entries[this.index(keyHash)];
        if (bucketHead == null) {
            return Collections.emptyIterator();
        }
        MultiMapEntry e = bucketHead.entry;
        assert (e != null);
        do {
            if (e.keyHash != keyHash || !this.equals(key, e.getKey())) continue;
            return new ValuesByNameIterator(keyHash, key, e);
        } while ((e = e.bucketNext) != null);
        return Collections.emptyIterator();
    }

    public final boolean contains(K key, V value) {
        return this.contains(key, value, this::equalsForValue);
    }

    final boolean contains(K key, V value, BiPredicate<V, V> valueCompare) {
        int keyHash = this.hashCode(key);
        int bucketIndex = this.index(keyHash);
        BucketHead<K, V> bucketHead = this.entries[bucketIndex];
        if (bucketHead != null) {
            MultiMapEntry e = bucketHead.entry;
            assert (e != null);
            do {
                if (e.keyHash != keyHash || !this.equals(key, e.getKey()) || !valueCompare.test(value, e.value)) continue;
                return true;
            } while ((e = e.bucketNext) != null);
        }
        return false;
    }

    final void put(K key, V value) {
        int keyHash = this.hashCode(this.validateKey(key));
        int bucketIndex = this.index(keyHash);
        this.putEntry(keyHash, bucketIndex, key, this.validateValue(value));
    }

    final void putAll(K key, Iterable<? extends V> values) {
        block3: {
            BucketHead<K, V> bucketHead;
            int bucketIndex;
            int keyHash;
            block2: {
                keyHash = this.hashCode(this.validateKey(key));
                bucketIndex = this.index(keyHash);
                bucketHead = this.entries[bucketIndex];
                if (bucketHead == null) break block2;
                for (V v : values) {
                    this.putEntry(bucketHead, keyHash, bucketIndex, key, this.validateValue(v));
                }
                break block3;
            }
            Iterator<V> valueItr = values.iterator();
            if (!valueItr.hasNext()) break block3;
            bucketHead = this.putEntry(keyHash, bucketIndex, key, this.validateValue(valueItr.next()));
            while (valueItr.hasNext()) {
                this.putEntry(bucketHead, keyHash, bucketIndex, key, this.validateValue(valueItr.next()));
            }
        }
    }

    @SafeVarargs
    final void putAll(K key, V ... values) {
        block3: {
            BucketHead<K, V> bucketHead;
            int bucketIndex;
            int keyHash;
            block2: {
                keyHash = this.hashCode(this.validateKey(key));
                bucketIndex = this.index(keyHash);
                bucketHead = this.entries[bucketIndex];
                if (bucketHead == null) break block2;
                for (V v : values) {
                    this.putEntry(bucketHead, keyHash, bucketIndex, key, this.validateValue(v));
                }
                break block3;
            }
            if (values.length == 0) break block3;
            bucketHead = this.putEntry(keyHash, bucketIndex, key, this.validateValue(values[0]));
            for (int i = 1; i < values.length; ++i) {
                this.putEntry(bucketHead, keyHash, bucketIndex, key, this.validateValue(values[i]));
            }
        }
    }

    final void putAll(MultiMap<? extends K, ? extends V> multiMap) {
        this.putAll0(multiMap);
    }

    final void putExclusive(K key, V value) {
        int keyHash = this.hashCode(this.validateKey(key));
        int bucketIndex = this.index(keyHash);
        this.removeAll(key, keyHash, bucketIndex);
        this.putEntry(keyHash, bucketIndex, key, this.validateValue(value));
    }

    final void putExclusive(K key, Iterable<? extends V> values) {
        int keyHash = this.hashCode(this.validateKey(key));
        int bucketIndex = this.index(keyHash);
        this.removeAll(key, keyHash, bucketIndex);
        Iterator<V> valueItr = values.iterator();
        if (valueItr.hasNext()) {
            BucketHead<K, V> bucketHead = this.entries[bucketIndex];
            if (bucketHead == null) {
                bucketHead = this.putEntry(keyHash, bucketIndex, key, this.validateValue(valueItr.next()));
                if (!valueItr.hasNext()) {
                    return;
                }
            }
            do {
                this.putEntry(bucketHead, keyHash, bucketIndex, key, this.validateValue(valueItr.next()));
            } while (valueItr.hasNext());
        }
    }

    @SafeVarargs
    final void putExclusive(K key, V ... values) {
        int keyHash = this.hashCode(this.validateKey(key));
        int bucketIndex = this.index(keyHash);
        this.removeAll(key, keyHash, bucketIndex);
        if (values.length != 0) {
            BucketHead<K, V> bucketHead = this.entries[bucketIndex];
            int i = 0;
            if (bucketHead == null) {
                bucketHead = this.putEntry(keyHash, bucketIndex, key, this.validateValue(values[0]));
                i = 1;
            }
            while (i < values.length) {
                this.putEntry(bucketHead, keyHash, bucketIndex, key, this.validateValue(values[i]));
                ++i;
            }
        }
    }

    final void clearAll() {
        Arrays.fill(this.entries, null);
        this.lastBucketHead = null;
        this.size = 0;
    }

    final boolean removeAll(K key) {
        int keyHash = this.hashCode(key);
        int sizeBefore = this.size;
        this.removeAll(key, keyHash, this.index(keyHash));
        return sizeBefore != this.size;
    }

    private void removeAll(K key, int keyHash, int bucketIndex) {
        BucketHead<K, V> bucketHead = this.entries[bucketIndex];
        if (bucketHead == null) {
            return;
        }
        MultiMapEntry e = bucketHead.entry;
        assert (e != null);
        do {
            if (e.keyHash == keyHash && this.equals(key, e.getKey())) {
                MultiMapEntry tmpEntry = e;
                e = e.bucketNext;
                this.removeEntry(bucketHead, tmpEntry, bucketIndex);
                continue;
            }
            e = e.bucketNext;
        } while (e != null);
    }

    @Nullable
    final V removeAllAndGetFirst(K key) {
        int keyHash = this.hashCode(key);
        int bucketIndex = this.index(keyHash);
        BucketHead<K, V> bucketHead = this.entries[bucketIndex];
        if (bucketHead == null) {
            return null;
        }
        V value = null;
        MultiMapEntry e = bucketHead.entry;
        assert (e != null);
        do {
            if (e.keyHash == keyHash && this.equals(key, e.getKey())) {
                if (value == null) {
                    value = e.getValue();
                }
                MultiMapEntry tmpEntry = e;
                e = e.bucketNext;
                this.removeEntry(bucketHead, tmpEntry, bucketIndex);
                continue;
            }
            e = e.bucketNext;
        } while (e != null);
        return value;
    }

    final Iterator<Map.Entry<K, V>> entryIterator() {
        return this.lastBucketHead == null ? Collections.emptyIterator() : new FullEntryIterator(this.lastBucketHead);
    }

    final Iterator<V> valueIterator() {
        return this.lastBucketHead == null ? Collections.emptyIterator() : new ValueEntryIterator(this.lastBucketHead);
    }

    final int index(int hash) {
        return hash & this.hashMask;
    }

    final void removeEntry(BucketHead<K, V> bucketHead, MultiMapEntry<K, V> entryToRemove, int bucketIndex) {
        if (bucketHead.entry == entryToRemove) {
            if (bucketHead.entry.bucketNext == null) {
                this.entries[bucketIndex] = null;
                if (this.lastBucketHead == bucketHead) {
                    if (this.lastBucketHead.prevBucketHead != null) {
                        this.lastBucketHead.prevBucketHead.nextBucketHead = null;
                    }
                    this.lastBucketHead = this.lastBucketHead.prevBucketHead;
                } else {
                    assert (this.lastBucketHead != null);
                    if (bucketHead.prevBucketHead != null) {
                        bucketHead.prevBucketHead.nextBucketHead = bucketHead.nextBucketHead;
                    }
                    assert (bucketHead.nextBucketHead != null);
                    bucketHead.nextBucketHead.prevBucketHead = bucketHead.prevBucketHead;
                }
            } else {
                bucketHead.entry.bucketNext.bucketLastOrPrevious = bucketHead.entry.bucketLastOrPrevious;
                bucketHead.entry = bucketHead.entry.bucketNext;
            }
        } else {
            if (bucketHead.entry == null || entryToRemove.bucketLastOrPrevious == null) {
                throw new ConcurrentModificationException();
            }
            if (bucketHead.entry.bucketLastOrPrevious == entryToRemove) {
                bucketHead.entry.bucketLastOrPrevious = entryToRemove.bucketLastOrPrevious;
            }
            entryToRemove.bucketLastOrPrevious.bucketNext = entryToRemove.bucketNext;
            if (entryToRemove.bucketNext != null) {
                entryToRemove.bucketNext.bucketLastOrPrevious = entryToRemove.bucketLastOrPrevious;
            }
        }
        entryToRemove.bucketNext = null;
        entryToRemove.bucketLastOrPrevious = null;
        --this.size;
    }

    public int hashCode() {
        if (this.isEmpty()) {
            return 0;
        }
        int result = -1028477387;
        for (K key : this.getKeys()) {
            result = 31 * result + this.hashCode(key);
            Iterator<V> valueItr = this.getValues(key);
            while (valueItr.hasNext()) {
                result = 31 * result + this.hashCodeForValue(valueItr.next());
            }
        }
        return result;
    }

    public boolean equals(Object o) {
        if (!(o instanceof MultiMap)) {
            return false;
        }
        MultiMap h2 = (MultiMap)o;
        if (h2.size() != this.size()) {
            return false;
        }
        if (this == h2) {
            return true;
        }
        for (K key : this.getKeys()) {
            Iterator<V> valueItr = this.getValues(key);
            Iterator<V> h2ValueItr = h2.getValues(key);
            while (valueItr.hasNext() && h2ValueItr.hasNext()) {
                if (this.equalsForValue(valueItr.next(), h2ValueItr.next())) continue;
                return false;
            }
            if (valueItr.hasNext() == h2ValueItr.hasNext()) continue;
            return false;
        }
        return true;
    }

    private BucketHead<K, V> putEntry(@Nullable BucketHead<K, V> bucketHead, int keyHash, int bucketIndex, K key, V value) {
        MultiMapEntry<K, V> newEntry = this.newEntry(key, value, keyHash);
        if (bucketHead == null) {
            bucketHead = new BucketHead<K, V>(this.lastBucketHead, newEntry);
            this.entries[bucketIndex] = bucketHead;
            this.lastBucketHead = bucketHead;
            newEntry.addAsBucketHead();
        } else {
            newEntry.addToBucketTail(bucketHead);
        }
        ++this.size;
        return bucketHead;
    }

    private BucketHead<K, V> putEntry(int keyHash, int bucketIndex, K key, V value) {
        return this.putEntry(this.entries[bucketIndex], keyHash, bucketIndex, key, value);
    }

    private void putAll0(MultiMap<? extends K, ? extends V> rhs) {
        if (this.isKeyEqualityCompatible(rhs)) {
            BucketHead<K, V> rhsBucketHead = rhs.lastBucketHead;
            while (rhsBucketHead != null) {
                MultiMapEntry rhsEntry = rhsBucketHead.entry;
                assert (rhsEntry != null);
                int bucketIndex = this.index(rhsEntry.keyHash);
                BucketHead<K, V> bucketHead = this.entries[bucketIndex];
                if (bucketHead == null) {
                    bucketHead = this.putEntry(null, rhsEntry.keyHash, bucketIndex, rhsEntry.getKey(), rhsEntry.getValue());
                    rhsEntry = rhsEntry.bucketNext;
                    if (rhsEntry == null) {
                        rhsBucketHead = rhsBucketHead.prevBucketHead;
                        continue;
                    }
                }
                do {
                    this.putEntry(bucketHead, rhsEntry.keyHash, bucketIndex, rhsEntry.getKey(), rhsEntry.getValue());
                } while ((rhsEntry = rhsEntry.bucketNext) != null);
                rhsBucketHead = rhsBucketHead.prevBucketHead;
            }
        } else {
            BucketHead<K, V> rhsBucketHead = rhs.lastBucketHead;
            while (rhsBucketHead != null) {
                MultiMapEntry rhsEntry = rhsBucketHead.entry;
                assert (rhsEntry != null);
                do {
                    this.putEntry(rhsEntry.keyHash, this.index(rhsEntry.keyHash), rhsEntry.getKey(), rhsEntry.getValue());
                } while ((rhsEntry = rhsEntry.bucketNext) != null);
                rhsBucketHead = rhsBucketHead.prevBucketHead;
            }
        }
    }

    static final class MultiMapEntry<K, V>
    implements Map.Entry<K, V> {
        final int keyHash;
        private final K key;
        V value;
        @Nullable
        MultiMapEntry<K, V> bucketNext;
        @Nullable
        MultiMapEntry<K, V> bucketLastOrPrevious;

        MultiMapEntry(K key, V value, int keyHash) {
            this.key = Objects.requireNonNull(key);
            if (value == null) {
                throw new IllegalArgumentException("Null value for key: " + key);
            }
            this.value = value;
            this.keyHash = keyHash;
        }

        void addToBucketTail(BucketHead<K, V> bucketHead) {
            assert (bucketHead.entry != null);
            assert (bucketHead.entry.bucketLastOrPrevious != null);
            this.bucketLastOrPrevious = bucketHead.entry.bucketLastOrPrevious;
            bucketHead.entry.bucketLastOrPrevious.bucketNext = this;
            bucketHead.entry.bucketLastOrPrevious = this;
        }

        void addAsBucketHead() {
            this.bucketLastOrPrevious = this;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            Objects.requireNonNull(value);
            V oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public String toString() {
            return this.getKey() + "=" + this.value;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry other = (Map.Entry)o;
            return this.getKey().equals(other.getKey()) && this.value.equals(other.getValue());
        }

        @Override
        public int hashCode() {
            return this.getKey().hashCode() ^ this.value.hashCode();
        }
    }

    static final class BucketHead<K, V> {
        @Nullable
        BucketHead<K, V> prevBucketHead;
        @Nullable
        BucketHead<K, V> nextBucketHead;
        @Nullable
        MultiMapEntry<K, V> entry;

        BucketHead(@Nullable BucketHead<K, V> prevBucketHead, MultiMapEntry<K, V> entry) {
            this.prevBucketHead = prevBucketHead;
            if (prevBucketHead != null) {
                prevBucketHead.nextBucketHead = this;
            }
            this.entry = entry;
        }
    }

    private final class ValuesByNameIterator
    implements Iterator<V> {
        final int keyHashCode;
        final K key;
        @Nullable
        private MultiMapEntry<K, V> current;
        @Nullable
        private MultiMapEntry<K, V> previous;

        ValuesByNameIterator(int keyHashCode, K key, MultiMapEntry<K, V> first) {
            this.keyHashCode = keyHashCode;
            this.key = key;
            this.current = first;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public V next() {
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            this.previous = this.current;
            this.current = this.findNext(this.current.bucketNext);
            return this.previous.value;
        }

        @Override
        public void remove() {
            if (this.previous == null) {
                throw new IllegalStateException();
            }
            int i = MultiMap.this.index(this.keyHashCode);
            MultiMap.this.removeEntry(MultiMap.this.entries[i], this.previous, i);
            this.previous = null;
        }

        @Nullable
        private MultiMapEntry<K, V> findNext(@Nullable MultiMapEntry<K, V> entry) {
            while (entry != null) {
                if (entry.keyHash == this.keyHashCode && MultiMap.this.equals(this.key, entry.getKey())) {
                    return entry;
                }
                entry = entry.bucketNext;
            }
            return null;
        }
    }

    private final class ValueEntryIterator
    extends EntryIterator<V> {
        ValueEntryIterator(BucketHead<K, V> lastBucketHead) {
            super(lastBucketHead);
        }

        @Override
        V extractNextFromEntry(MultiMapEntry<K, V> entry) {
            return entry.value;
        }
    }

    private final class FullEntryIterator
    extends EntryIterator<Map.Entry<K, V>> {
        FullEntryIterator(BucketHead<K, V> lastBucketHead) {
            super(lastBucketHead);
        }

        @Override
        Map.Entry<K, V> extractNextFromEntry(MultiMapEntry<K, V> entry) {
            return entry;
        }
    }

    private abstract class EntryIterator<T>
    implements Iterator<T> {
        @Nullable
        private MultiMapEntry<K, V> previous;
        @Nullable
        private BucketHead<K, V> currentBucketHead;
        @Nullable
        private MultiMapEntry<K, V> current;

        EntryIterator(BucketHead<K, V> lastBucketHead) {
            this.currentBucketHead = lastBucketHead;
            this.current = lastBucketHead.entry;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public T next() {
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            this.previous = this.current;
            if (this.current.bucketNext == null) {
                assert (this.currentBucketHead != null);
                this.currentBucketHead = this.currentBucketHead.prevBucketHead;
                this.current = this.currentBucketHead == null ? null : this.currentBucketHead.entry;
            } else {
                this.current = this.current.bucketNext;
            }
            return this.extractNextFromEntry(this.previous);
        }

        @Override
        public void remove() {
            if (this.previous == null) {
                throw new IllegalStateException();
            }
            int i = MultiMap.this.index(this.previous.keyHash);
            MultiMap.this.removeEntry(MultiMap.this.entries[i], this.previous, i);
            this.previous = null;
        }

        abstract T extractNextFromEntry(MultiMapEntry<K, V> var1);
    }
}

