/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.buffer.api.CompositeBuffer;
import io.servicetalk.buffer.api.EmptyBuffer;
import io.servicetalk.concurrent.BlockingIterable;
import io.servicetalk.concurrent.BlockingIterator;
import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.PublisherOperator;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.api.SourceAdapters;
import io.servicetalk.concurrent.internal.ConcurrentSubscription;
import io.servicetalk.concurrent.internal.DelayedSubscription;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import io.servicetalk.http.api.DefaultPayloadInfo;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.api.UnsupportedHttpChunkException;
import java.nio.BufferOverflowException;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import javax.annotation.Nullable;

final class HttpDataSourceTransformations {
    private static final PayloadAndTrailers EMPTY_PAYLOAD_AND_TRAILERS = new PayloadAndTrailers();

    private HttpDataSourceTransformations() {
    }

    static Single<PayloadAndTrailers> aggregatePayloadAndTrailers(DefaultPayloadInfo payloadInfo, Publisher<?> payloadAndTrailers, BufferAllocator allocator) {
        if (payloadAndTrailers == Publisher.empty()) {
            payloadInfo.setEmpty(true).setMayHaveTrailersAndGenericTypeBuffer(false);
            return Single.succeeded(EMPTY_PAYLOAD_AND_TRAILERS);
        }
        return payloadAndTrailers.collect(PayloadAndTrailers::new, (pair, nextItem) -> {
            if (nextItem instanceof Buffer) {
                try {
                    Buffer buffer = (Buffer)nextItem;
                    if (HttpDataSourceTransformations.isAlwaysEmpty(pair.payload)) {
                        pair.payload = buffer;
                    }
                    if (pair.payload instanceof CompositeBuffer) {
                        ((CompositeBuffer)pair.payload).addBuffer(buffer);
                    }
                    Buffer oldBuffer = pair.payload;
                    pair.payload = allocator.newCompositeBuffer(Integer.MAX_VALUE).addBuffer(oldBuffer).addBuffer(buffer);
                }
                catch (IllegalArgumentException cause) {
                    BufferOverflowException ex = new BufferOverflowException();
                    ex.initCause(cause);
                    throw ex;
                }
            } else if (nextItem instanceof HttpHeaders) {
                pair.trailers = (HttpHeaders)nextItem;
            } else {
                throw new UnsupportedHttpChunkException(nextItem);
            }
            return pair;
        }).map(pair -> {
            if (HttpDataSourceTransformations.isAlwaysEmpty(pair.payload)) {
                payloadInfo.setEmpty(true);
            }
            if (pair.trailers == null) {
                payloadInfo.setMayHaveTrailersAndGenericTypeBuffer(false);
            }
            return pair;
        });
    }

    static boolean isAlwaysEmpty(Buffer buffer) {
        return buffer == EmptyBuffer.EMPTY_BUFFER || buffer.isReadOnly() && buffer.readableBytes() == 0;
    }

    static final class PayloadAndTrailers {
        Buffer payload = EmptyBuffer.EMPTY_BUFFER;
        @Nullable
        HttpHeaders trailers;

        PayloadAndTrailers() {
        }
    }

    static final class HttpTransportBufferFilterOperator
    implements PublisherOperator<Object, Buffer> {
        static final PublisherOperator<Object, Buffer> INSTANCE = new HttpTransportBufferFilterOperator();

        private HttpTransportBufferFilterOperator() {
        }

        @Override
        public PublisherSource.Subscriber<? super Object> apply(PublisherSource.Subscriber<? super Buffer> subscriber) {
            return new JustBufferSubscriber(subscriber);
        }

        private static final class JustBufferSubscriber
        implements PublisherSource.Subscriber<Object> {
            private final PublisherSource.Subscriber<? super Buffer> subscriber;

            JustBufferSubscriber(PublisherSource.Subscriber<? super Buffer> target) {
                this.subscriber = target;
            }

            @Override
            public void onSubscribe(PublisherSource.Subscription s) {
                this.subscriber.onSubscribe(s);
            }

            @Override
            public void onNext(Object o) {
                if (o instanceof Buffer) {
                    this.subscriber.onNext((Buffer)o);
                } else if (!(o instanceof HttpHeaders)) {
                    throw new UnsupportedHttpChunkException(o);
                }
            }

            @Override
            public void onError(Throwable t) {
                this.subscriber.onError(t);
            }

            @Override
            public void onComplete() {
                this.subscriber.onComplete();
            }
        }
    }

    static final class HttpBufferFilterIterable
    implements BlockingIterable<Buffer> {
        private final BlockingIterable<?> original;

        HttpBufferFilterIterable(BlockingIterable<?> original) {
            this.original = original;
        }

        @Override
        public BlockingIterator<Buffer> iterator() {
            return new JustBufferBlockingIterator((BlockingIterator<?>)this.original.iterator());
        }

        private static final class JustBufferBlockingIterator
        implements BlockingIterator<Buffer> {
            private final BlockingIterator<?> iterator;
            @Nullable
            private Buffer nextBuffer;

            JustBufferBlockingIterator(BlockingIterator<?> iterator) {
                this.iterator = Objects.requireNonNull(iterator);
            }

            @Override
            public boolean hasNext(long timeout, TimeUnit unit) throws TimeoutException {
                if (this.nextBuffer != null) {
                    return true;
                }
                long timeoutNanos = unit.toNanos(timeout);
                long timeStampA = System.nanoTime();
                if (!this.iterator.hasNext(timeoutNanos, TimeUnit.NANOSECONDS)) {
                    return false;
                }
                return this.validateNext(this.iterator.next(timeoutNanos -= System.nanoTime() - timeStampA, TimeUnit.NANOSECONDS));
            }

            @Override
            public Buffer next(long timeout, TimeUnit unit) throws TimeoutException {
                if (!this.hasNext(timeout, unit)) {
                    throw new NoSuchElementException();
                }
                return this.getAndResetNextBuffer();
            }

            @Override
            public void close() throws Exception {
                this.nextBuffer = null;
                this.iterator.close();
            }

            @Override
            public boolean hasNext() {
                return this.nextBuffer != null || this.iterator.hasNext() && this.validateNext(this.iterator.next());
            }

            @Override
            public Buffer next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.getAndResetNextBuffer();
            }

            private boolean validateNext(@Nullable Object next) {
                if (next instanceof Buffer) {
                    this.nextBuffer = (Buffer)next;
                    return true;
                }
                UnsupportedHttpChunkException e = new UnsupportedHttpChunkException(next);
                try {
                    this.iterator.close();
                }
                catch (Throwable cause) {
                    e.addSuppressed(cause);
                }
                throw e;
            }

            private Buffer getAndResetNextBuffer() {
                assert (this.nextBuffer != null);
                Buffer next = this.nextBuffer;
                this.nextBuffer = null;
                return next;
            }
        }
    }

    private static final class BridgeFlowControlAndDiscardSubscriber<T>
    implements PublisherSource.Subscriber<T> {
        private final PublisherSource.Subscriber<? super T> target;
        private final DelayedSubscription bridgedSubscription;
        @Nullable
        private PublisherSource.Subscription outerSubscription;

        BridgeFlowControlAndDiscardSubscriber(PublisherSource.Subscriber<? super T> target, Publisher<?> discardedPublisher) {
            this.target = target;
            this.bridgedSubscription = new DelayedSubscription();
            SourceAdapters.toSource(discardedPublisher).subscribe(new PublisherSource.Subscriber<Object>(){

                @Override
                public void onSubscribe(PublisherSource.Subscription s) {
                    bridgedSubscription.delayedSubscription(ConcurrentSubscription.wrap(s));
                }

                @Override
                public void onNext(Object buffer) {
                }

                @Override
                public void onError(Throwable t) {
                }

                @Override
                public void onComplete() {
                }
            });
        }

        @Override
        public void onSubscribe(final PublisherSource.Subscription s) {
            if (SubscriberUtils.checkDuplicateSubscription(this.outerSubscription, s)) {
                this.outerSubscription = new PublisherSource.Subscription(){

                    @Override
                    public void request(long n) {
                        try {
                            s.request(n);
                        }
                        finally {
                            bridgedSubscription.request(n);
                        }
                    }

                    @Override
                    public void cancel() {
                        try {
                            s.cancel();
                        }
                        finally {
                            bridgedSubscription.cancel();
                        }
                    }
                };
                this.target.onSubscribe(this.outerSubscription);
            }
        }

        @Override
        public void onNext(T t) {
            this.target.onNext(t);
        }

        @Override
        public void onError(Throwable t) {
            try {
                this.target.onError(t);
            }
            finally {
                this.bridgedSubscription.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onComplete() {
            try {
                this.target.onComplete();
            }
            finally {
                this.bridgedSubscription.request(Long.MAX_VALUE);
            }
        }
    }

    static final class BridgeFlowControlAndDiscardOperator
    implements PublisherOperator<Buffer, Buffer> {
        private static final AtomicIntegerFieldUpdater<BridgeFlowControlAndDiscardOperator> appliedUpdater = AtomicIntegerFieldUpdater.newUpdater(BridgeFlowControlAndDiscardOperator.class, "applied");
        private volatile int applied;
        private final Publisher<?> discardedPublisher;

        BridgeFlowControlAndDiscardOperator(Publisher<?> discardedPublisher) {
            this.discardedPublisher = Objects.requireNonNull(discardedPublisher);
        }

        @Override
        public PublisherSource.Subscriber<? super Buffer> apply(PublisherSource.Subscriber<? super Buffer> subscriber) {
            return appliedUpdater.compareAndSet(this, 0, 1) ? new BridgeFlowControlAndDiscardSubscriber(subscriber, this.discardedPublisher) : subscriber;
        }
    }
}

