/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.client.api.DefaultServiceDiscovererEvent;
import io.servicetalk.client.api.ServiceDiscovererEvent;
import io.servicetalk.client.api.partition.PartitionAttributes;
import io.servicetalk.client.api.partition.PartitionedServiceDiscovererEvent;
import io.servicetalk.concurrent.api.BiIntFunction;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.RetryStrategies;
import io.servicetalk.http.api.ServiceDiscoveryRetryStrategy;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@Deprecated
public final class DefaultServiceDiscoveryRetryStrategy<ResolvedAddress, E extends ServiceDiscovererEvent<ResolvedAddress>>
implements ServiceDiscoveryRetryStrategy<ResolvedAddress, E> {
    private final UnaryOperator<E> flipAvailability;
    private final boolean retainAddressesTillSuccess;
    private final BiIntFunction<Throwable, ? extends Completable> retryStrategy;

    private DefaultServiceDiscoveryRetryStrategy(UnaryOperator<E> flipAvailability, boolean retainAddressesTillSuccess, BiIntFunction<Throwable, ? extends Completable> retryStrategy) {
        this.flipAvailability = Objects.requireNonNull(flipAvailability);
        this.retainAddressesTillSuccess = retainAddressesTillSuccess;
        this.retryStrategy = Objects.requireNonNull(retryStrategy);
    }

    @Override
    public Publisher<Collection<E>> apply(Publisher<Collection<E>> sdEvents) {
        return Publisher.defer(() -> {
            EventsCache eventsCache = new EventsCache(this.flipAvailability);
            if (this.retainAddressesTillSuccess) {
                return sdEvents.map(eventsCache::consumeAndFilter).beforeOnError(__ -> eventsCache.errorSeen()).retryWhen(this.retryStrategy);
            }
            return sdEvents.map(eventsCache::consumeAndFilter).onErrorResume(cause -> {
                Collection events = eventsCache.errorSeen();
                return events == null ? Publisher.failed(cause) : Publisher.from(events.stream().map(this.flipAvailability).collect(Collectors.toList())).concat(Publisher.failed(cause));
            }).retryWhen(this.retryStrategy);
        });
    }

    private static BiIntFunction<Throwable, ? extends Completable> defaultRetryStrategy(Executor executor, Duration initialDelay, Duration jitter) {
        return RetryStrategies.retryWithConstantBackoffDeltaJitter(__ -> true, initialDelay, jitter, executor);
    }

    private static final class EventsCache<R, E extends ServiceDiscovererEvent<R>> {
        private static final Map NONE_RETAINED = Collections.emptyMap();
        private Map<R, E> retainedAddresses = EventsCache.noneRetained();
        private final Map<R, E> activeAddresses = new HashMap<R, E>();
        private final UnaryOperator<E> flipAvailability;

        EventsCache(UnaryOperator<E> flipAvailability) {
            this.flipAvailability = flipAvailability;
        }

        @Nullable
        Collection<E> errorSeen() {
            if (this.retainedAddresses == NONE_RETAINED) {
                this.retainedAddresses = new HashMap<R, E>(this.activeAddresses);
                this.activeAddresses.clear();
                return this.retainedAddresses.isEmpty() ? null : this.retainedAddresses.values();
            }
            return null;
        }

        Collection<E> consumeAndFilter(Collection<E> events) {
            if (this.retainedAddresses == NONE_RETAINED) {
                for (ServiceDiscovererEvent e : events) {
                    if (ServiceDiscovererEvent.Status.AVAILABLE.equals(e.status())) {
                        this.activeAddresses.put(e.address(), e);
                        continue;
                    }
                    this.activeAddresses.remove(e.address());
                }
                return events;
            }
            ArrayList<ServiceDiscovererEvent<Object>> toReturn = new ArrayList<ServiceDiscovererEvent<Object>>(this.activeAddresses.size() + this.retainedAddresses.size());
            for (ServiceDiscovererEvent event : events) {
                Object address = event.address();
                if (ServiceDiscovererEvent.Status.AVAILABLE.equals(event.status())) {
                    this.activeAddresses.put(address, event);
                    if (this.retainedAddresses.remove(address) != null) continue;
                    toReturn.add(event);
                    continue;
                }
                if (this.activeAddresses.remove(address) == null && this.retainedAddresses.remove(address) == null) continue;
                toReturn.add(event);
            }
            for (ServiceDiscovererEvent event : this.retainedAddresses.values()) {
                toReturn.add((ServiceDiscovererEvent<Object>)this.flipAvailability.apply(event));
            }
            this.retainedAddresses = EventsCache.noneRetained();
            return toReturn;
        }

        private static <R, E extends ServiceDiscovererEvent<R>> Map<R, E> noneRetained() {
            return NONE_RETAINED;
        }
    }

    @Deprecated
    public static final class Builder<ResolvedAddress, E extends ServiceDiscovererEvent<ResolvedAddress>> {
        private BiIntFunction<Throwable, ? extends Completable> retryStrategy;
        private final UnaryOperator<E> flipAvailability;
        private boolean retainAddressesTillSuccess = true;

        private Builder(BiIntFunction<Throwable, ? extends Completable> retryStrategy, UnaryOperator<E> flipAvailability) {
            this.retryStrategy = retryStrategy;
            this.flipAvailability = Objects.requireNonNull(flipAvailability);
        }

        public Builder<ResolvedAddress, E> retainAddressesTillSuccess(boolean retainAddressesTillSuccess) {
            this.retainAddressesTillSuccess = retainAddressesTillSuccess;
            return this;
        }

        public Builder<ResolvedAddress, E> retryStrategy(BiIntFunction<Throwable, ? extends Completable> retryStrategy) {
            this.retryStrategy = Objects.requireNonNull(retryStrategy);
            return this;
        }

        public ServiceDiscoveryRetryStrategy<ResolvedAddress, E> build() {
            return new DefaultServiceDiscoveryRetryStrategy(this.flipAvailability, this.retainAddressesTillSuccess, this.retryStrategy);
        }

        public static <ResolvedAddress> Builder<ResolvedAddress, ServiceDiscovererEvent<ResolvedAddress>> withDefaults(Executor executor, Duration initialDelay, Duration jitter) {
            return new Builder(DefaultServiceDiscoveryRetryStrategy.defaultRetryStrategy(executor, initialDelay, jitter), evt -> {
                ServiceDiscovererEvent.Status flipped = ServiceDiscovererEvent.Status.AVAILABLE.equals(evt.status()) ? ServiceDiscovererEvent.Status.UNAVAILABLE : ServiceDiscovererEvent.Status.AVAILABLE;
                return new DefaultServiceDiscovererEvent(evt.address(), flipped);
            });
        }

        public static <ResolvedAddress> Builder<ResolvedAddress, PartitionedServiceDiscovererEvent<ResolvedAddress>> withDefaultsForPartitions(Executor executor, Duration initialDelay, Duration jitter) {
            return new Builder(DefaultServiceDiscoveryRetryStrategy.defaultRetryStrategy(executor, initialDelay, jitter), evt -> new PartitionedServiceDiscovererEvent<ResolvedAddress>((PartitionedServiceDiscovererEvent)evt){
                final /* synthetic */ PartitionedServiceDiscovererEvent val$evt;
                {
                    this.val$evt = partitionedServiceDiscovererEvent;
                }

                @Override
                public PartitionAttributes partitionAddress() {
                    return this.val$evt.partitionAddress();
                }

                @Override
                public ResolvedAddress address() {
                    return this.val$evt.address();
                }

                @Override
                public ServiceDiscovererEvent.Status status() {
                    return ServiceDiscovererEvent.Status.AVAILABLE.equals(this.val$evt.status()) ? ServiceDiscovererEvent.Status.UNAVAILABLE : ServiceDiscovererEvent.Status.AVAILABLE;
                }
            });
        }

        public static <ResolvedAddress, E extends ServiceDiscovererEvent<ResolvedAddress>> Builder<ResolvedAddress, E> withDefaults(Executor executor, Duration initialDelay, Duration jitter, UnaryOperator<E> flipAvailability) {
            return new Builder<ResolvedAddress, E>(DefaultServiceDiscoveryRetryStrategy.defaultRetryStrategy(executor, initialDelay, jitter), flipAvailability);
        }
    }
}

