/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.internal;

import io.servicetalk.concurrent.Executor;
import io.servicetalk.concurrent.internal.SignalOffloader;
import io.servicetalk.concurrent.internal.SignalOffloaderFactory;
import io.servicetalk.concurrent.internal.TaskBasedSignalOffloader;
import io.servicetalk.concurrent.internal.ThreadBasedSignalOffloader;

public final class SignalOffloaders {
    private static final SignalOffloaderFactory TASK_BASED_OFFLOADER_FACTORY = new SignalOffloaderFactory(){

        @Override
        public SignalOffloader newSignalOffloader(Executor executor) {
            return SignalOffloaders.newTaskBasedOffloader(executor);
        }

        @Override
        public boolean hasThreadAffinity() {
            return false;
        }
    };
    private static final SignalOffloaderFactory THREAD_BASED_OFFLOADER_FACTORY = new SignalOffloaderFactory(){

        @Override
        public SignalOffloader newSignalOffloader(Executor executor) {
            return SignalOffloaders.newThreadBasedOffloader(executor);
        }

        @Override
        public boolean hasThreadAffinity() {
            return true;
        }
    };
    private static final SignalOffloaderFactory DEFAULT_OFFLOADER_FACTORY = TASK_BASED_OFFLOADER_FACTORY;

    private SignalOffloaders() {
    }

    public static SignalOffloaderFactory defaultOffloaderFactory() {
        return DEFAULT_OFFLOADER_FACTORY;
    }

    public static SignalOffloaderFactory threadBasedOffloaderFactory() {
        return THREAD_BASED_OFFLOADER_FACTORY;
    }

    public static SignalOffloaderFactory taskBasedOffloaderFactory() {
        return TASK_BASED_OFFLOADER_FACTORY;
    }

    public static SignalOffloader newOffloaderFor(Executor executor) {
        return executor instanceof SignalOffloaderFactory ? ((SignalOffloaderFactory)((Object)executor)).newSignalOffloader(executor) : SignalOffloaders.defaultOffloaderFactory().newSignalOffloader(executor);
    }

    public static SignalOffloader newTaskBasedOffloader(Executor executor) {
        return new TaskBasedSignalOffloader(executor);
    }

    public static SignalOffloader newThreadBasedOffloader(Executor executor) {
        return new ThreadBasedSignalOffloader(executor);
    }

    public static boolean hasThreadAffinity(Executor executor) {
        return executor instanceof SignalOffloaderFactory && ((SignalOffloaderFactory)((Object)executor)).hasThreadAffinity();
    }
}

