/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.internal;

import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.internal.SubscriberUtils;

public final class EmptySubscriptions {
    public static final PublisherSource.Subscription EMPTY_SUBSCRIPTION = EmptySubscriptions.newEmptySubscription();
    public static final PublisherSource.Subscription EMPTY_SUBSCRIPTION_NO_THROW = EmptySubscriptions.newEmptySubscriptionNoThrow();

    private EmptySubscriptions() {
    }

    public static <T> PublisherSource.Subscription newEmptySubscription(final PublisherSource.Subscriber<T> subscriber) {
        return new PublisherSource.Subscription(){
            private boolean terminated;

            @Override
            public void request(long n) {
                if (!this.terminated && !SubscriberUtils.isRequestNValid(n)) {
                    this.terminated = true;
                    subscriber.onError(SubscriberUtils.newExceptionForInvalidRequestN(n));
                }
            }

            @Override
            public void cancel() {
            }
        };
    }

    public static PublisherSource.Subscription newEmptySubscription() {
        return new PublisherSource.Subscription(){

            @Override
            public void request(long n) {
                if (!SubscriberUtils.isRequestNValid(n)) {
                    throw SubscriberUtils.newExceptionForInvalidRequestN(n);
                }
            }

            @Override
            public void cancel() {
            }
        };
    }

    private static PublisherSource.Subscription newEmptySubscriptionNoThrow() {
        return new PublisherSource.Subscription(){

            @Override
            public void request(long n) {
            }

            @Override
            public void cancel() {
            }
        };
    }
}

