/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.internal;

import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.internal.FlowControlUtils;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import javax.annotation.Nullable;

public final class DelayedSubscription
implements PublisherSource.Subscription {
    private static final long SUBSCRIPTION_SETTING = Long.MIN_VALUE;
    private static final long SUBSCRIPTION_SET = -9223372036854775807L;
    private static final long SUBSCRIPTION_CANCEL_PENDING = -9223372036854775806L;
    private static final long GREATEST_CONTROL_VALUE = -9223372036854775806L;
    private static final AtomicLongFieldUpdater<DelayedSubscription> requestedUpdater = AtomicLongFieldUpdater.newUpdater(DelayedSubscription.class, "requested");
    @Nullable
    private PublisherSource.Subscription subscription;
    private volatile long requested;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void delayedSubscription(PublisherSource.Subscription delayedSubscription) {
        Objects.requireNonNull(delayedSubscription);
        while (true) {
            long prevRequested;
            if ((prevRequested = this.requested) <= -9223372036854775806L) {
                delayedSubscription.cancel();
                return;
            }
            if (!requestedUpdater.compareAndSet(this, prevRequested, Long.MIN_VALUE)) continue;
            if (prevRequested != 0L) {
                delayedSubscription.request(prevRequested);
            }
            this.subscription = delayedSubscription;
            if (requestedUpdater.compareAndSet(this, Long.MIN_VALUE, -9223372036854775807L)) return;
        }
    }

    @Override
    public void request(long n) {
        long prevRequested;
        do {
            if ((prevRequested = this.requested) != -9223372036854775807L) continue;
            assert (this.subscription != null);
            this.subscription.request(n);
            break;
        } while (!(prevRequested == Long.MIN_VALUE ? requestedUpdater.compareAndSet(this, Long.MIN_VALUE, DelayedSubscription.addRequestN(0L, n)) : prevRequested < 0L || requestedUpdater.compareAndSet(this, prevRequested, DelayedSubscription.addRequestN(prevRequested, n))));
    }

    @Override
    public void cancel() {
        long prevRequested;
        do {
            if ((prevRequested = this.requested) != -9223372036854775807L) continue;
            assert (this.subscription != null);
            this.subscription.cancel();
            break;
        } while (!(prevRequested == Long.MIN_VALUE ? requestedUpdater.compareAndSet(this, Long.MIN_VALUE, -9223372036854775806L) : prevRequested < 0L || requestedUpdater.compareAndSet(this, prevRequested, -9223372036854775806L)));
    }

    private static long addRequestN(long prevRequested, long n) {
        return n <= -9223372036854775806L || n == 0L ? -1L : (n < 0L ? n : FlowControlUtils.addWithOverflowProtection(prevRequested, n));
    }
}

