/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.Executor;
import io.servicetalk.concurrent.api.AbstractNoHandleSubscribeCompletable;
import io.servicetalk.concurrent.api.AsyncContextProvider;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.PublishAndSubscribeOnCompletables;
import io.servicetalk.concurrent.internal.SignalOffloader;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import io.servicetalk.context.api.ContextMap;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import javax.annotation.Nullable;

final class TimeoutCompletable
extends AbstractNoHandleSubscribeCompletable {
    private final Completable original;
    private final Executor timeoutExecutor;
    private final long durationNs;

    TimeoutCompletable(Completable original, Duration duration, Executor timeoutExecutor) {
        super(original.executor());
        this.original = original;
        this.durationNs = duration.toNanos();
        this.timeoutExecutor = Objects.requireNonNull(timeoutExecutor);
    }

    TimeoutCompletable(Completable original, long duration, TimeUnit unit, Executor timeoutExecutor) {
        super(original.executor());
        this.original = original;
        this.durationNs = unit.toNanos(duration);
        this.timeoutExecutor = Objects.requireNonNull(timeoutExecutor);
    }

    @Override
    protected void handleSubscribe(CompletableSource.Subscriber subscriber, SignalOffloader offloader, ContextMap contextMap, AsyncContextProvider contextProvider) {
        this.original.delegateSubscribe(TimeoutSubscriber.newInstance(this, subscriber, offloader, contextMap, contextProvider), offloader, contextMap, contextProvider);
    }

    private static final class TimeoutSubscriber
    implements CompletableSource.Subscriber,
    Cancellable {
        private static final Cancellable LOCAL_IGNORE_CANCEL = () -> {};
        private static final int STATE_ON_WAITING_FOR_SUBSCRIBE = 0;
        private static final int STATE_ON_SUBSCRIBE_DONE = 1;
        private static final int STATE_TIMED_OUT_ERROR = 2;
        private static final AtomicReferenceFieldUpdater<TimeoutSubscriber, Cancellable> cancellableUpdater = AtomicReferenceFieldUpdater.newUpdater(TimeoutSubscriber.class, Cancellable.class, "cancellable");
        private static final AtomicIntegerFieldUpdater<TimeoutSubscriber> subscriberStateUpdater = AtomicIntegerFieldUpdater.newUpdater(TimeoutSubscriber.class, "subscriberState");
        @Nullable
        private volatile Cancellable cancellable;
        private volatile int subscriberState;
        private final TimeoutCompletable parent;
        private final CompletableSource.Subscriber target;
        private final SignalOffloader offloader;
        private final AsyncContextProvider contextProvider;
        @Nullable
        private Cancellable timerCancellable;

        private TimeoutSubscriber(TimeoutCompletable parent, CompletableSource.Subscriber target, SignalOffloader offloader, AsyncContextProvider contextProvider) {
            this.parent = parent;
            this.target = target;
            this.offloader = offloader;
            this.contextProvider = contextProvider;
        }

        static TimeoutSubscriber newInstance(TimeoutCompletable parent, CompletableSource.Subscriber target, SignalOffloader offloader, ContextMap contextMap, AsyncContextProvider contextProvider) {
            Cancellable localTimerCancellable;
            TimeoutSubscriber s = new TimeoutSubscriber(parent, target, offloader, contextProvider);
            try {
                localTimerCancellable = Objects.requireNonNull(parent.timeoutExecutor.schedule(s::timerFires, parent.durationNs, TimeUnit.NANOSECONDS));
            }
            catch (Throwable cause) {
                localTimerCancellable = IGNORE_CANCEL;
                s.cancellable = LOCAL_IGNORE_CANCEL;
                PublishAndSubscribeOnCompletables.deliverOnSubscribeAndOnError(target, offloader, contextMap, contextProvider, cause);
            }
            s.timerCancellable = localTimerCancellable;
            return s;
        }

        @Override
        public void onSubscribe(Cancellable cancellable) {
            if (cancellableUpdater.compareAndSet(this, null, cancellable)) {
                this.target.onSubscribe(this);
                if (!subscriberStateUpdater.compareAndSet(this, 0, 1)) {
                    this.target.onError(this.newTimeoutException());
                }
            } else {
                cancellable.cancel();
            }
        }

        @Override
        public void onComplete() {
            if (cancellableUpdater.getAndSet(this, LOCAL_IGNORE_CANCEL) != LOCAL_IGNORE_CANCEL) {
                try {
                    this.stopTimer();
                }
                finally {
                    this.target.onComplete();
                }
            }
        }

        @Override
        public void onError(Throwable t) {
            if (cancellableUpdater.getAndSet(this, LOCAL_IGNORE_CANCEL) != LOCAL_IGNORE_CANCEL) {
                try {
                    this.stopTimer();
                }
                finally {
                    this.target.onError(t);
                }
            }
        }

        @Override
        public void cancel() {
            Cancellable oldCancellable = cancellableUpdater.getAndSet(this, LOCAL_IGNORE_CANCEL);
            if (oldCancellable != LOCAL_IGNORE_CANCEL) {
                try {
                    this.stopTimer();
                }
                finally {
                    oldCancellable.cancel();
                }
            }
        }

        private void timerFires() {
            Cancellable oldCancellable = cancellableUpdater.getAndSet(this, LOCAL_IGNORE_CANCEL);
            if (oldCancellable != LOCAL_IGNORE_CANCEL) {
                CompletableSource.Subscriber offloadedTarget;
                CompletableSource.Subscriber subscriber = offloadedTarget = this.parent.timeoutExecutor == this.parent.executor() ? this.target : this.offloader.offloadSubscriber(this.contextProvider.wrapCompletableSubscriber(this.target, this.contextProvider.context()));
                if (oldCancellable != null) {
                    oldCancellable.cancel();
                    if (subscriberStateUpdater.getAndSet(this, 2) == 1) {
                        offloadedTarget.onError(this.newTimeoutException());
                    }
                } else {
                    SubscriberUtils.deliverErrorFromSource(offloadedTarget, (Throwable)this.newTimeoutException());
                }
            }
        }

        private TimeoutException newTimeoutException() {
            return new TimeoutException("timeout after " + TimeUnit.NANOSECONDS.toMillis(this.parent.durationNs) + "ms");
        }

        private void stopTimer() {
            assert (this.timerCancellable != null);
            this.timerCancellable.cancel();
        }
    }
}

