/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.AbstractNoHandleSubscribePublisher;
import io.servicetalk.concurrent.api.AsyncContextProvider;
import io.servicetalk.concurrent.api.DelayedCancellableThenSubscription;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.internal.SignalOffloader;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import io.servicetalk.context.api.ContextMap;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import javax.annotation.Nullable;

final class SingleConcatWithPublisher<T>
extends AbstractNoHandleSubscribePublisher<T> {
    private final Single<? extends T> original;
    private final Publisher<? extends T> next;
    private final boolean deferSubscribe;

    SingleConcatWithPublisher(Single<? extends T> original, Publisher<? extends T> next, boolean deferSubscribe, Executor executor) {
        super(executor);
        this.original = original;
        this.next = Objects.requireNonNull(next, "next");
        this.deferSubscribe = deferSubscribe;
    }

    @Override
    void handleSubscribe(PublisherSource.Subscriber<? super T> subscriber, SignalOffloader signalOffloader, ContextMap contextMap, AsyncContextProvider contextProvider) {
        this.original.delegateSubscribe(this.deferSubscribe ? new ConcatDeferNextSubscriber<T>(subscriber, this.next) : new ConcatSubscriber<T>(subscriber, this.next), signalOffloader, contextMap, contextProvider);
    }

    private static final class ConcatDeferNextSubscriber<T>
    extends AbstractConcatSubscriber<T> {
        private static final Object REQUESTED_ONE = new Object();
        private static final Object REQUESTED_MORE = new Object();
        private static final Object SINGLE_DELIVERING = new Object();
        private static final Object SINGLE_DELIVERED = new Object();
        private static final Object PUBLISHER_SUBSCRIBED = new Object();

        ConcatDeferNextSubscriber(PublisherSource.Subscriber<? super T> target, Publisher<? extends T> next) {
            super(target, next);
        }

        @Override
        public void onSuccess(@Nullable T result) {
            block6: {
                while (true) {
                    Object oldValue = this.mayBeResult;
                    assert (oldValue != SINGLE_DELIVERING);
                    assert (oldValue != SINGLE_DELIVERED);
                    assert (oldValue != PUBLISHER_SUBSCRIBED);
                    if (oldValue == CANCELLED) break block6;
                    if (oldValue == INITIAL) {
                        if (!mayBeResultUpdater.compareAndSet(this, oldValue, result)) continue;
                        break block6;
                    }
                    if (oldValue == REQUESTED_ONE) {
                        if (!mayBeResultUpdater.compareAndSet(this, oldValue, SINGLE_DELIVERING)) continue;
                        this.emitSingleSuccessToTarget(result);
                        break block6;
                    }
                    if (oldValue == REQUESTED_MORE && mayBeResultUpdater.compareAndSet(this, oldValue, PUBLISHER_SUBSCRIBED)) break;
                }
                if (!this.tryEmitSingleSuccessToTarget(result)) break block6;
                this.next.subscribeInternal(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void request(long n) {
            Object oldVal;
            while ((oldVal = this.mayBeResult) != CANCELLED) {
                if (oldVal == PUBLISHER_SUBSCRIBED || oldVal == REQUESTED_MORE) {
                    super.request(n);
                    break;
                }
                if (!SubscriberUtils.isRequestNValid(n)) {
                    this.mayBeResult = CANCELLED;
                    try {
                        this.target.onError(SubscriberUtils.newExceptionForInvalidRequestN(n));
                        break;
                    }
                    finally {
                        this.superCancel();
                    }
                }
                if (oldVal == INITIAL) {
                    if (n > 1L) {
                        if (!mayBeResultUpdater.compareAndSet(this, oldVal, REQUESTED_MORE)) continue;
                        super.request(n - 1L);
                        break;
                    }
                    assert (n == 1L);
                    if (!mayBeResultUpdater.compareAndSet(this, oldVal, REQUESTED_ONE)) continue;
                    break;
                }
                if (oldVal == REQUESTED_ONE || oldVal == SINGLE_DELIVERING) {
                    if (!mayBeResultUpdater.compareAndSet(this, oldVal, REQUESTED_MORE)) continue;
                    super.request(n);
                    break;
                }
                if (oldVal == SINGLE_DELIVERED) {
                    if (!mayBeResultUpdater.compareAndSet(this, oldVal, PUBLISHER_SUBSCRIBED)) continue;
                    super.request(n);
                    this.next.subscribeInternal(this);
                    break;
                }
                if (n > 1L) {
                    if (!mayBeResultUpdater.compareAndSet(this, oldVal, PUBLISHER_SUBSCRIBED)) continue;
                    Object tVal = oldVal;
                    if (!this.tryEmitSingleSuccessToTarget(tVal)) break;
                    super.request(n - 1L);
                    this.next.subscribeInternal(this);
                    break;
                }
                if (!mayBeResultUpdater.compareAndSet(this, oldVal, SINGLE_DELIVERING)) continue;
                Object tVal = oldVal;
                this.emitSingleSuccessToTarget(tVal);
                break;
            }
        }

        private void emitSingleSuccessToTarget(@Nullable T result) {
            if (this.tryEmitSingleSuccessToTarget(result) && !mayBeResultUpdater.compareAndSet(this, SINGLE_DELIVERING, SINGLE_DELIVERED)) {
                if (mayBeResultUpdater.compareAndSet(this, REQUESTED_MORE, PUBLISHER_SUBSCRIBED)) {
                    this.next.subscribeInternal(this);
                } else assert (this.mayBeResult == CANCELLED);
            }
        }
    }

    private static final class ConcatSubscriber<T>
    extends AbstractConcatSubscriber<T> {
        private static final Object REQUESTED = new Object();

        ConcatSubscriber(PublisherSource.Subscriber<? super T> target, Publisher<? extends T> next) {
            super(target, next);
        }

        @Override
        public void onSuccess(@Nullable T result) {
            Object oldValue;
            do {
                if ((oldValue = this.mayBeResult) != REQUESTED) continue;
                if (!this.tryEmitSingleSuccessToTarget(result)) break;
                this.next.subscribeInternal(this);
                break;
            } while (oldValue != CANCELLED && !mayBeResultUpdater.compareAndSet(this, INITIAL, result));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void request(long n) {
            Object oldVal;
            while ((oldVal = this.mayBeResult) != CANCELLED) {
                Object tVal;
                if (oldVal == REQUESTED) {
                    super.request(n);
                    break;
                }
                if (!SubscriberUtils.isRequestNValid(n)) {
                    this.mayBeResult = CANCELLED;
                    try {
                        this.target.onError(SubscriberUtils.newExceptionForInvalidRequestN(n));
                        break;
                    }
                    finally {
                        this.superCancel();
                    }
                }
                if (!mayBeResultUpdater.compareAndSet(this, oldVal, REQUESTED)) continue;
                if (n != 1L) {
                    super.request(n - 1L);
                }
                if (oldVal == INITIAL || !this.tryEmitSingleSuccessToTarget(tVal = oldVal)) break;
                this.next.subscribeInternal(this);
                break;
            }
        }
    }

    private static abstract class AbstractConcatSubscriber<T>
    extends DelayedCancellableThenSubscription
    implements SingleSource.Subscriber<T>,
    PublisherSource.Subscriber<T> {
        static final Object INITIAL = new Object();
        static final Object CANCELLED = new Object();
        static final AtomicReferenceFieldUpdater<AbstractConcatSubscriber, Object> mayBeResultUpdater = AtomicReferenceFieldUpdater.newUpdater(AbstractConcatSubscriber.class, Object.class, "mayBeResult");
        final PublisherSource.Subscriber<? super T> target;
        final Publisher<? extends T> next;
        @Nullable
        volatile Object mayBeResult = INITIAL;

        AbstractConcatSubscriber(PublisherSource.Subscriber<? super T> target, Publisher<? extends T> next) {
            this.target = target;
            this.next = next;
        }

        @Override
        public final void onSubscribe(Cancellable cancellable) {
            this.delayedCancellable(cancellable);
            this.target.onSubscribe(this);
        }

        @Override
        public final void onSubscribe(PublisherSource.Subscription subscription) {
            this.delayedSubscription(subscription);
        }

        @Override
        public final void onNext(@Nullable T t) {
            this.target.onNext(t);
        }

        @Override
        public final void onError(Throwable t) {
            this.target.onError(t);
        }

        @Override
        public final void onComplete() {
            this.target.onComplete();
        }

        @Override
        public final void cancel() {
            this.mayBeResult = CANCELLED;
            super.cancel();
        }

        final void superCancel() {
            super.cancel();
        }

        final boolean tryEmitSingleSuccessToTarget(@Nullable T result) {
            try {
                this.target.onNext(result);
                return true;
            }
            catch (Throwable cause) {
                this.mayBeResult = CANCELLED;
                this.target.onError(cause);
                return false;
            }
        }
    }
}

