/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.RetryStrategies;
import io.servicetalk.concurrent.internal.FlowControlUtils;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.IntFunction;

public final class RepeatStrategies {
    private RepeatStrategies() {
    }

    public static IntFunction<Completable> repeatWithConstantBackoffFullJitter(Duration delay, Executor timerExecutor) {
        Objects.requireNonNull(timerExecutor);
        long delayNanos = delay.toNanos();
        RetryStrategies.checkFullJitter(delayNanos);
        return repeatCount -> timerExecutor.timer(ThreadLocalRandom.current().nextLong(0L, delayNanos), TimeUnit.NANOSECONDS);
    }

    public static IntFunction<Completable> repeatWithConstantBackoffFullJitter(int maxRepeats, Duration delay, Executor timerExecutor) {
        RetryStrategies.checkMaxRetries(maxRepeats);
        Objects.requireNonNull(timerExecutor);
        long delayNanos = delay.toNanos();
        RetryStrategies.checkFullJitter(delayNanos);
        return repeatCount -> repeatCount <= maxRepeats ? timerExecutor.timer(ThreadLocalRandom.current().nextLong(0L, delayNanos), TimeUnit.NANOSECONDS) : RepeatStrategies.terminateRepeat();
    }

    public static IntFunction<Completable> repeatWithConstantBackoffDeltaJitter(Duration delay, Duration jitter, Executor timerExecutor) {
        Objects.requireNonNull(timerExecutor);
        long delayNanos = delay.toNanos();
        long jitterNanos = jitter.toNanos();
        RetryStrategies.checkJitterDelta(jitterNanos, delayNanos);
        long lowerBound = delayNanos - jitterNanos;
        long upperBound = delayNanos + jitterNanos;
        return repeatCount -> timerExecutor.timer(ThreadLocalRandom.current().nextLong(lowerBound, upperBound), TimeUnit.NANOSECONDS);
    }

    public static IntFunction<Completable> repeatWithConstantBackoffDeltaJitter(int maxRepeats, Duration delay, Duration jitter, Executor timerExecutor) {
        RetryStrategies.checkMaxRetries(maxRepeats);
        Objects.requireNonNull(timerExecutor);
        long delayNanos = delay.toNanos();
        long jitterNanos = jitter.toNanos();
        RetryStrategies.checkJitterDelta(jitterNanos, delayNanos);
        long lowerBound = delayNanos - jitterNanos;
        long upperBound = delayNanos + jitterNanos;
        return repeatCount -> repeatCount <= maxRepeats ? timerExecutor.timer(ThreadLocalRandom.current().nextLong(lowerBound, upperBound), TimeUnit.NANOSECONDS) : RepeatStrategies.terminateRepeat();
    }

    public static IntFunction<Completable> repeatWithExponentialBackoffFullJitter(Duration initialDelay, Duration maxDelay, Executor timerExecutor) {
        Objects.requireNonNull(timerExecutor);
        long initialDelayNanos = initialDelay.toNanos();
        long maxDelayNanos = maxDelay.toNanos();
        long maxInitialShift = RetryStrategies.maxShift(initialDelayNanos);
        return repeatCount -> timerExecutor.timer(ThreadLocalRandom.current().nextLong(0L, RetryStrategies.baseDelayNanos(initialDelayNanos, maxDelayNanos, maxInitialShift, repeatCount)), TimeUnit.NANOSECONDS);
    }

    public static IntFunction<Completable> repeatWithExponentialBackoffFullJitter(int maxRepeats, Duration initialDelay, Duration maxDelay, Executor timerExecutor) {
        RetryStrategies.checkMaxRetries(maxRepeats);
        Objects.requireNonNull(timerExecutor);
        long initialDelayNanos = initialDelay.toNanos();
        long maxDelayNanos = maxDelay.toNanos();
        long maxInitialShift = RetryStrategies.maxShift(initialDelayNanos);
        return repeatCount -> repeatCount <= maxRepeats ? timerExecutor.timer(ThreadLocalRandom.current().nextLong(0L, RetryStrategies.baseDelayNanos(initialDelayNanos, maxDelayNanos, maxInitialShift, repeatCount)), TimeUnit.NANOSECONDS) : RepeatStrategies.terminateRepeat();
    }

    public static IntFunction<Completable> repeatWithExponentialBackoffDeltaJitter(Duration initialDelay, Duration jitter, Duration maxDelay, Executor timerExecutor) {
        Objects.requireNonNull(timerExecutor);
        long initialDelayNanos = initialDelay.toNanos();
        long jitterNanos = jitter.toNanos();
        long maxDelayNanos = maxDelay.toNanos();
        long maxInitialShift = RetryStrategies.maxShift(initialDelayNanos);
        return repeatCount -> {
            long baseDelayNanos = RetryStrategies.baseDelayNanos(initialDelayNanos, maxDelayNanos, maxInitialShift, repeatCount);
            return timerExecutor.timer(ThreadLocalRandom.current().nextLong(Math.max(0L, baseDelayNanos - jitterNanos), Math.min(maxDelayNanos, FlowControlUtils.addWithOverflowProtection(baseDelayNanos, jitterNanos))), TimeUnit.NANOSECONDS);
        };
    }

    public static IntFunction<Completable> repeatWithExponentialBackoffDeltaJitter(int maxRepeats, Duration initialDelay, Duration jitter, Duration maxDelay, Executor timerExecutor) {
        RetryStrategies.checkMaxRetries(maxRepeats);
        Objects.requireNonNull(timerExecutor);
        long initialDelayNanos = initialDelay.toNanos();
        long jitterNanos = jitter.toNanos();
        long maxDelayNanos = maxDelay.toNanos();
        long maxInitialShift = RetryStrategies.maxShift(initialDelayNanos);
        return repeatCount -> {
            if (repeatCount > maxRepeats) {
                return RepeatStrategies.terminateRepeat();
            }
            long baseDelayNanos = RetryStrategies.baseDelayNanos(initialDelayNanos, maxDelayNanos, maxInitialShift, repeatCount);
            return timerExecutor.timer(ThreadLocalRandom.current().nextLong(Math.max(0L, baseDelayNanos - jitterNanos), Math.min(maxDelayNanos, FlowControlUtils.addWithOverflowProtection(baseDelayNanos, jitterNanos))), TimeUnit.NANOSECONDS);
        };
    }

    private static Completable terminateRepeat() {
        return Completable.failed(TerminateRepeatException.INSTANCE);
    }

    public static final class TerminateRepeatException
    extends Exception {
        private static final long serialVersionUID = -1725458427890873886L;
        static final TerminateRepeatException INSTANCE = new TerminateRepeatException();

        private TerminateRepeatException() {
            super(null, null, false, false);
        }
    }
}

