/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.api.AbstractNoHandleSubscribeCompletable;
import io.servicetalk.concurrent.api.AbstractSynchronousCompletableOperator;
import io.servicetalk.concurrent.api.AsyncContextProvider;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.MergedExecutors;
import io.servicetalk.concurrent.internal.SignalOffloader;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import io.servicetalk.context.api.ContextMap;

final class PublishAndSubscribeOnCompletables {
    private PublishAndSubscribeOnCompletables() {
    }

    static void deliverOnSubscribeAndOnError(CompletableSource.Subscriber subscriber, SignalOffloader signalOffloader, ContextMap contextMap, AsyncContextProvider contextProvider, Throwable cause) {
        SubscriberUtils.deliverErrorFromSource(signalOffloader.offloadSubscriber(contextProvider.wrapCompletableSubscriber(subscriber, contextMap)), cause);
    }

    static Completable publishAndSubscribeOn(Completable original, Executor executor) {
        return original.executor() == executor ? original : new PublishAndSubscribeOn(executor, original);
    }

    @Deprecated
    static Completable publishAndSubscribeOnOverride(Completable original, Executor executor) {
        return original.executor() == executor ? original : new PublishAndSubscribeOnOverride(original, executor);
    }

    static Completable publishOn(Completable original, Executor executor) {
        return original.executor() == executor ? original : new PublishOn(executor, original);
    }

    @Deprecated
    static Completable publishOnOverride(Completable original, Executor executor) {
        return original.executor() == executor ? original : new PublishOnOverride(original, executor);
    }

    static Completable subscribeOn(Completable original, Executor executor) {
        return original.executor() == executor ? original : new SubscribeOn(executor, original);
    }

    @Deprecated
    static Completable subscribeOnOverride(Completable original, Executor executor) {
        return original.executor() == executor ? original : new SubscribeOnOverride(original, executor);
    }

    private static final class SubscribeOnOverride
    extends AbstractSynchronousCompletableOperator {
        SubscribeOnOverride(Completable original, Executor executor) {
            super(original, MergedExecutors.mergeAndOffloadSubscribe(original.executor(), executor));
        }

        @Override
        public CompletableSource.Subscriber apply(CompletableSource.Subscriber subscriber) {
            return subscriber;
        }
    }

    private static final class SubscribeOn
    extends AbstractNoHandleSubscribeCompletable {
        private final Completable original;

        SubscribeOn(Executor executor, Completable original) {
            super(MergedExecutors.mergeAndOffloadSubscribe(original.executor(), executor));
            this.original = original;
        }

        @Override
        void handleSubscribe(CompletableSource.Subscriber subscriber, SignalOffloader signalOffloader, ContextMap contextMap, AsyncContextProvider contextProvider) {
            this.original.subscribeWithSharedContext(subscriber, contextProvider);
        }
    }

    private static final class PublishOnOverride
    extends AbstractSynchronousCompletableOperator {
        PublishOnOverride(Completable original, Executor executor) {
            super(original, MergedExecutors.mergeAndOffloadPublish(original.executor(), executor));
        }

        @Override
        public CompletableSource.Subscriber apply(CompletableSource.Subscriber subscriber) {
            return subscriber;
        }
    }

    private static final class PublishOn
    extends AbstractNoHandleSubscribeCompletable {
        private final Completable original;

        PublishOn(Executor executor, Completable original) {
            super(MergedExecutors.mergeAndOffloadPublish(original.executor(), executor));
            this.original = original;
        }

        @Override
        void handleSubscribe(CompletableSource.Subscriber subscriber, SignalOffloader signalOffloader, ContextMap contextMap, AsyncContextProvider contextProvider) {
            this.original.subscribeWithSharedContext(signalOffloader.offloadSubscriber(contextProvider.wrapCompletableSubscriber(subscriber, contextMap)), contextProvider);
        }
    }

    private static final class PublishAndSubscribeOnOverride
    extends AbstractSynchronousCompletableOperator {
        PublishAndSubscribeOnOverride(Completable original, Executor executor) {
            super(original, executor);
        }

        @Override
        public CompletableSource.Subscriber apply(CompletableSource.Subscriber subscriber) {
            return subscriber;
        }
    }

    private static final class PublishAndSubscribeOn
    extends AbstractNoHandleSubscribeCompletable {
        private final Completable original;

        PublishAndSubscribeOn(Executor executor, Completable original) {
            super(executor);
            this.original = original;
        }

        @Override
        void handleSubscribe(CompletableSource.Subscriber subscriber, SignalOffloader signalOffloader, ContextMap contextMap, AsyncContextProvider contextProvider) {
            this.original.subscribeWithSharedContext(signalOffloader.offloadSubscriber(contextProvider.wrapCompletableSubscriber(subscriber, contextMap)), contextProvider);
        }
    }
}

