/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.AbstractSynchronousSingleOperator;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.Single;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;

final class OnErrorMapSingle<T>
extends AbstractSynchronousSingleOperator<T, T> {
    private final Predicate<? super Throwable> predicate;
    private final Function<? super Throwable, ? extends Throwable> mapper;

    OnErrorMapSingle(Single<T> original, Predicate<? super Throwable> predicate, Function<? super Throwable, ? extends Throwable> mapper, Executor executor) {
        super(original, executor);
        this.predicate = Objects.requireNonNull(predicate);
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public SingleSource.Subscriber<? super T> apply(SingleSource.Subscriber<? super T> subscriber) {
        return new ErrorMapSubscriber(subscriber);
    }

    private final class ErrorMapSubscriber
    implements SingleSource.Subscriber<T> {
        private final SingleSource.Subscriber<? super T> subscriber;

        private ErrorMapSubscriber(SingleSource.Subscriber<? super T> subscriber) {
            this.subscriber = subscriber;
        }

        @Override
        public void onSubscribe(Cancellable cancellable) {
            this.subscriber.onSubscribe(cancellable);
        }

        @Override
        public void onSuccess(@Nullable T result) {
            this.subscriber.onSuccess(result);
        }

        @Override
        public void onError(Throwable t) {
            boolean predicateResult;
            try {
                predicateResult = OnErrorMapSingle.this.predicate.test(t);
            }
            catch (Throwable cause) {
                this.subscriber.onError(cause);
                return;
            }
            if (predicateResult) {
                Throwable mappedCause;
                try {
                    mappedCause = (Throwable)Objects.requireNonNull(OnErrorMapSingle.this.mapper.apply(t));
                }
                catch (Throwable cause) {
                    this.subscriber.onError(cause);
                    return;
                }
                this.subscriber.onError(mappedCause);
            } else {
                this.subscriber.onError(t);
            }
        }
    }
}

