/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.api.AbstractMergeCompletableOperator;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.CompletableFixedCountMergeSubscriber;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.MergeOneCompletable;
import java.util.Objects;

final class MergeCompletable
extends AbstractMergeCompletableOperator<CompletableFixedCountMergeSubscriber> {
    private final Completable[] others;
    private final boolean delayError;

    private MergeCompletable(boolean delayError, Completable original, Executor executor, Completable ... others) {
        super(original, executor);
        this.delayError = delayError;
        this.others = Objects.requireNonNull(others);
    }

    static Completable newInstance(boolean delayError, Completable original, Executor executor, Completable ... others) {
        return others.length == 0 ? original : (others.length == 1 ? new MergeOneCompletable(delayError, original, executor, others[0]) : new MergeCompletable(delayError, original, executor, others));
    }

    @Override
    public CompletableFixedCountMergeSubscriber apply(CompletableSource.Subscriber subscriber) {
        return new CompletableFixedCountMergeSubscriber(subscriber, 1 + this.others.length, this.delayError);
    }

    @Override
    void doMerge(CompletableFixedCountMergeSubscriber subscriber) {
        for (Completable itr : this.others) {
            itr.subscribeInternal(subscriber);
        }
    }
}

