/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.ContextPreservingRunnable;
import io.servicetalk.concurrent.api.Executor;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

final class ContextPreservingStExecutor
implements Executor {
    private final Executor delegate;

    private ContextPreservingStExecutor(Executor delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public Cancellable execute(Runnable task) {
        return this.delegate.execute(new ContextPreservingRunnable(task));
    }

    @Override
    public Cancellable schedule(Runnable task, long delay, TimeUnit unit) {
        return this.delegate.schedule(new ContextPreservingRunnable(task), delay, unit);
    }

    @Override
    public Completable onClose() {
        return this.delegate.onClose();
    }

    @Override
    public Completable closeAsync() {
        return this.delegate.closeAsync();
    }

    static Executor of(Executor delegate) {
        return delegate instanceof ContextPreservingStExecutor ? delegate : new ContextPreservingStExecutor(delegate);
    }
}

