/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.AbstractAsynchronousPublisherOperator;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.SequentialSubscription;
import java.util.Objects;

final class ConcatPublisher<T>
extends AbstractAsynchronousPublisherOperator<T, T> {
    private final Publisher<? extends T> next;

    ConcatPublisher(Publisher<T> original, Publisher<? extends T> next, Executor executor) {
        super(original, executor);
        this.next = Objects.requireNonNull(next);
    }

    @Override
    public PublisherSource.Subscriber<? super T> apply(PublisherSource.Subscriber<? super T> subscriber) {
        return new ConcatSubscriber<T>(subscriber, this.next);
    }

    private static final class ConcatSubscriber<T>
    implements PublisherSource.Subscriber<T> {
        private final PublisherSource.Subscriber<? super T> target;
        private final Publisher<? extends T> next;
        private final SequentialSubscription subscription = new SequentialSubscription();
        private boolean nextSubscribed;

        ConcatSubscriber(PublisherSource.Subscriber<? super T> target, Publisher<? extends T> next) {
            this.target = target;
            this.next = Objects.requireNonNull(next);
        }

        @Override
        public void onSubscribe(PublisherSource.Subscription s) {
            this.subscription.switchTo(s);
            if (!this.nextSubscribed) {
                this.target.onSubscribe(this.subscription);
            }
        }

        @Override
        public void onNext(T t) {
            this.subscription.itemReceived();
            this.target.onNext(t);
        }

        @Override
        public void onError(Throwable t) {
            this.target.onError(t);
        }

        @Override
        public void onComplete() {
            if (this.nextSubscribed) {
                this.target.onComplete();
            } else {
                this.nextSubscribed = true;
                this.next.subscribeInternal(this);
            }
        }
    }
}

