/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.AbstractCompletableAndSingleConcatenated;
import io.servicetalk.concurrent.api.AsyncContextProvider;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.internal.SignalOffloader;
import io.servicetalk.context.api.ContextMap;
import java.util.Objects;
import javax.annotation.Nullable;

final class CompletableConcatWithSingle<T>
extends AbstractCompletableAndSingleConcatenated<T> {
    private final Completable original;
    private final Single<? extends T> next;

    CompletableConcatWithSingle(Completable original, Single<? extends T> next, Executor executor) {
        super(executor);
        this.original = Objects.requireNonNull(original);
        this.next = Objects.requireNonNull(next);
    }

    @Override
    void delegateSubscribeToOriginal(SingleSource.Subscriber<? super T> offloadSubscriber, SignalOffloader offloader, ContextMap contextMap, AsyncContextProvider contextProvider) {
        this.original.delegateSubscribe(new ConcatWithSubscriber<T>(offloadSubscriber, this.next), offloader, contextMap, contextProvider);
    }

    private static final class ConcatWithSubscriber<T>
    extends AbstractCompletableAndSingleConcatenated.AbstractConcatWithSubscriber<T> {
        private final Single<T> next;

        ConcatWithSubscriber(SingleSource.Subscriber<? super T> target, Single<T> next) {
            super(target);
            this.next = next;
        }

        @Override
        public void onComplete() {
            this.subscribeToNext(this.next);
        }

        @Override
        public void onSuccess(@Nullable T result) {
            this.sendSuccessToTarget(result);
        }
    }
}

