/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.AbstractNoHandleSubscribePublisher;
import io.servicetalk.concurrent.api.AsyncContextProvider;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.DelayedCancellableThenSubscription;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.internal.SignalOffloader;
import io.servicetalk.context.api.ContextMap;
import javax.annotation.Nullable;

final class CompletableConcatWithPublisher<T>
extends AbstractNoHandleSubscribePublisher<T> {
    private final Completable original;
    private final Publisher<? extends T> next;

    CompletableConcatWithPublisher(Completable original, Publisher<? extends T> next, Executor executor) {
        super(executor);
        this.original = original;
        this.next = next;
    }

    @Override
    void handleSubscribe(PublisherSource.Subscriber<? super T> subscriber, SignalOffloader signalOffloader, ContextMap contextMap, AsyncContextProvider contextProvider) {
        this.original.delegateSubscribe(new ConcatSubscriber<T>(subscriber, this.next), signalOffloader, contextMap, contextProvider);
    }

    private static final class ConcatSubscriber<T>
    extends DelayedCancellableThenSubscription
    implements CompletableSource.Subscriber,
    PublisherSource.Subscriber<T> {
        private final PublisherSource.Subscriber<? super T> target;
        private final Publisher<? extends T> next;
        private boolean subscribedToPublisher;

        ConcatSubscriber(PublisherSource.Subscriber<? super T> subscriber, Publisher<? extends T> next) {
            this.target = subscriber;
            this.next = next;
        }

        @Override
        public void onSubscribe(Cancellable cancellable) {
            this.delayedCancellable(cancellable);
            this.target.onSubscribe(this);
        }

        @Override
        public void onComplete() {
            if (this.subscribedToPublisher) {
                this.target.onComplete();
            } else {
                this.subscribedToPublisher = true;
                this.next.subscribeInternal(this);
            }
        }

        @Override
        public void onSubscribe(PublisherSource.Subscription subscription) {
            this.delayedSubscription(subscription);
        }

        @Override
        public void onNext(@Nullable T t) {
            this.target.onNext(t);
        }

        @Override
        public void onError(Throwable t) {
            this.target.onError(t);
        }
    }
}

