/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.api.AbstractNoHandleSubscribeCompletable;
import io.servicetalk.concurrent.api.AsyncContextProvider;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.internal.SequentialCancellable;
import io.servicetalk.concurrent.internal.SignalOffloader;
import io.servicetalk.context.api.ContextMap;
import java.util.Objects;
import javax.annotation.Nullable;

final class CompletableConcatWithCompletables
extends AbstractNoHandleSubscribeCompletable {
    private static final int MAX_STACK_DEPTH = 8;
    private final Completable original;
    private final Completable[] nexts;

    CompletableConcatWithCompletables(Executor executor, Completable original, Completable ... nexts) {
        super(executor);
        this.original = original;
        this.nexts = Objects.requireNonNull(nexts);
    }

    @Override
    protected void handleSubscribe(CompletableSource.Subscriber subscriber, SignalOffloader offloader, ContextMap contextMap, AsyncContextProvider contextProvider) {
        CompletableSource.Subscriber offloadSubscriber = offloader.offloadSubscriber(contextProvider.wrapCompletableSubscriber(subscriber, contextMap));
        this.original.delegateSubscribe(new ConcatWithSubscriber(offloadSubscriber, this.nexts), offloader, contextMap, contextProvider);
    }

    private static final class ConcatWithSubscriber
    implements CompletableSource.Subscriber {
        private final CompletableSource.Subscriber target;
        private final Completable[] nexts;
        @Nullable
        private SequentialCancellable sequentialCancellable;
        private int nextIndex;
        private int onCompleteDepth;

        ConcatWithSubscriber(CompletableSource.Subscriber target, Completable ... nexts) {
            this.target = target;
            this.nexts = nexts;
        }

        @Override
        public void onSubscribe(Cancellable cancellable) {
            if (this.sequentialCancellable == null) {
                this.sequentialCancellable = new SequentialCancellable(cancellable);
                this.target.onSubscribe(this.sequentialCancellable);
            } else {
                this.sequentialCancellable.nextCancellable(cancellable);
            }
        }

        @Override
        public void onComplete() {
            if (++this.onCompleteDepth < 8) {
                do {
                    if (this.nextIndex == this.nexts.length) {
                        this.target.onComplete();
                        continue;
                    }
                    this.nexts[this.nextIndex++].subscribeInternal(this);
                } while (this.onCompleteDepth-- >= 8);
            }
        }

        @Override
        public void onError(Throwable t) {
            this.target.onError(t);
        }
    }
}

