/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.Executor;
import io.servicetalk.concurrent.api.AfterFinallyCompletable;
import io.servicetalk.concurrent.api.AfterSubscriberCompletable;
import io.servicetalk.concurrent.api.AsyncContext;
import io.servicetalk.concurrent.api.AsyncContextProvider;
import io.servicetalk.concurrent.api.BeforeFinallyCompletable;
import io.servicetalk.concurrent.api.BeforeSubscriberCompletable;
import io.servicetalk.concurrent.api.BiIntFunction;
import io.servicetalk.concurrent.api.BiIntPredicate;
import io.servicetalk.concurrent.api.CompletableConcatWithCompletable;
import io.servicetalk.concurrent.api.CompletableConcatWithCompletables;
import io.servicetalk.concurrent.api.CompletableConcatWithPublisher;
import io.servicetalk.concurrent.api.CompletableConcatWithSingle;
import io.servicetalk.concurrent.api.CompletableDefer;
import io.servicetalk.concurrent.api.CompletableDoOnUtils;
import io.servicetalk.concurrent.api.CompletableMergeWithPublisher;
import io.servicetalk.concurrent.api.CompletableOperator;
import io.servicetalk.concurrent.api.CompletableShareContextOnSubscribe;
import io.servicetalk.concurrent.api.CompletableToPublisher;
import io.servicetalk.concurrent.api.CompletableToSingle;
import io.servicetalk.concurrent.api.CompletedCompletable;
import io.servicetalk.concurrent.api.DoCancellableCompletable;
import io.servicetalk.concurrent.api.Executors;
import io.servicetalk.concurrent.api.FailedCompletable;
import io.servicetalk.concurrent.api.IterableMergeCompletable;
import io.servicetalk.concurrent.api.LiftAsynchronousCompletableOperator;
import io.servicetalk.concurrent.api.LiftSynchronousCompletableOperator;
import io.servicetalk.concurrent.api.MergeCompletable;
import io.servicetalk.concurrent.api.MergeOneCompletable;
import io.servicetalk.concurrent.api.NeverCompletable;
import io.servicetalk.concurrent.api.OnErrorCompleteCompletable;
import io.servicetalk.concurrent.api.OnErrorMapCompletable;
import io.servicetalk.concurrent.api.OnErrorResumeCompletable;
import io.servicetalk.concurrent.api.PublishAndSubscribeOnCompletables;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.RunnableCompletable;
import io.servicetalk.concurrent.api.RunnableTerminalSignalConsumer;
import io.servicetalk.concurrent.api.SimpleCompletableSubscriber;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.api.SourceToFuture;
import io.servicetalk.concurrent.api.TerminalSignalConsumer;
import io.servicetalk.concurrent.api.TimeoutCompletable;
import io.servicetalk.concurrent.internal.SignalOffloader;
import io.servicetalk.concurrent.internal.SignalOffloaders;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import io.servicetalk.context.api.ContextMap;
import java.time.Duration;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Completable {
    private static final Logger LOGGER = LoggerFactory.getLogger(Completable.class);
    private final io.servicetalk.concurrent.api.Executor executor;
    private final boolean shareContextOnSubscribe;

    protected Completable() {
        this(Executors.immediate());
    }

    Completable(io.servicetalk.concurrent.api.Executor executor) {
        this(executor, false);
    }

    Completable(io.servicetalk.concurrent.api.Executor executor, boolean shareContextOnSubscribe) {
        this.executor = Objects.requireNonNull(executor);
        this.shareContextOnSubscribe = shareContextOnSubscribe;
    }

    public final Completable onErrorComplete() {
        return this.onErrorComplete((? super Throwable t) -> true);
    }

    public final <E extends Throwable> Completable onErrorComplete(Class<E> type) {
        return this.onErrorComplete(type::isInstance);
    }

    public final Completable onErrorComplete(Predicate<? super Throwable> predicate) {
        return new OnErrorCompleteCompletable(this, predicate, this.executor);
    }

    public final Completable onErrorMap(Function<? super Throwable, ? extends Throwable> mapper) {
        return this.onErrorMap((? super Throwable t) -> true, mapper);
    }

    public final <E extends Throwable> Completable onErrorMap(Class<E> type, Function<? super E, ? extends Throwable> mapper) {
        Function<? super E, ? extends Throwable> rawMapper = mapper;
        return this.onErrorMap(type::isInstance, rawMapper);
    }

    public final Completable onErrorMap(Predicate<? super Throwable> predicate, Function<? super Throwable, ? extends Throwable> mapper) {
        return new OnErrorMapCompletable(this, predicate, mapper, this.executor);
    }

    public final Completable onErrorResume(Function<? super Throwable, ? extends Completable> nextFactory) {
        return this.onErrorResume((? super Throwable t) -> true, nextFactory);
    }

    public final <E extends Throwable> Completable onErrorResume(Class<E> type, Function<? super E, ? extends Completable> nextFactory) {
        Function<? super E, ? extends Completable> rawNextFactory = nextFactory;
        return this.onErrorResume(type::isInstance, rawNextFactory);
    }

    public final Completable onErrorResume(Predicate<? super Throwable> predicate, Function<? super Throwable, ? extends Completable> nextFactory) {
        return new OnErrorResumeCompletable(this, predicate, nextFactory, this.executor);
    }

    public final Completable whenOnComplete(Runnable onComplete) {
        return this.beforeOnComplete(onComplete);
    }

    public final Completable whenOnError(Consumer<Throwable> onError) {
        return this.beforeOnError(onError);
    }

    public final Completable whenFinally(Runnable doFinally) {
        return this.beforeFinally(doFinally);
    }

    public final Completable whenFinally(TerminalSignalConsumer doFinally) {
        return this.beforeFinally(doFinally);
    }

    public final Completable whenCancel(Runnable onCancel) {
        return this.beforeCancel(onCancel);
    }

    @Deprecated
    public final Completable idleTimeout(long duration, TimeUnit unit) {
        return this.timeout(duration, unit, this.executor);
    }

    @Deprecated
    public final Completable idleTimeout(long duration, TimeUnit unit, Executor timeoutExecutor) {
        return new TimeoutCompletable(this, duration, unit, timeoutExecutor);
    }

    @Deprecated
    public final Completable idleTimeout(Duration duration) {
        return this.timeout(duration, this.executor);
    }

    @Deprecated
    public final Completable idleTimeout(Duration duration, Executor timeoutExecutor) {
        return new TimeoutCompletable(this, duration, timeoutExecutor);
    }

    public final Completable timeout(long duration, TimeUnit unit) {
        return this.timeout(duration, unit, this.executor);
    }

    public final Completable timeout(long duration, TimeUnit unit, Executor timeoutExecutor) {
        return new TimeoutCompletable(this, duration, unit, timeoutExecutor);
    }

    public final Completable timeout(Duration duration) {
        return this.timeout(duration, this.executor);
    }

    public final Completable timeout(Duration duration, Executor timeoutExecutor) {
        return new TimeoutCompletable(this, duration, timeoutExecutor);
    }

    public final Completable concat(Completable next) {
        return new CompletableConcatWithCompletable(this, next, this.executor);
    }

    public final Completable concat(Completable ... nexts) {
        return nexts.length == 0 ? this : new CompletableConcatWithCompletables(this.executor, this, nexts);
    }

    public final <T> Single<T> concat(Single<? extends T> next) {
        return new CompletableConcatWithSingle<T>(this, next, this.executor);
    }

    public final <T> Publisher<T> concat(Publisher<? extends T> next) {
        return new CompletableConcatWithPublisher<T>(this, next, this.executor);
    }

    public final Completable merge(Completable other) {
        return new MergeOneCompletable(false, this, this.executor, other);
    }

    public final Completable merge(Completable ... other) {
        return MergeCompletable.newInstance(false, this, this.executor, other);
    }

    public final Completable merge(Iterable<? extends Completable> other) {
        return new IterableMergeCompletable(false, this, other, this.executor);
    }

    public final <T> Publisher<T> merge(Publisher<? extends T> mergeWith) {
        return new CompletableMergeWithPublisher<T>(this, mergeWith, false, this.executor);
    }

    public final <T> Publisher<T> mergeDelayError(Publisher<? extends T> mergeWith) {
        return new CompletableMergeWithPublisher<T>(this, mergeWith, true, this.executor);
    }

    public final Completable mergeDelayError(Completable other) {
        return new MergeOneCompletable(true, this, this.executor, other);
    }

    public final Completable mergeDelayError(Completable ... other) {
        return MergeCompletable.newInstance(true, this, this.executor, other);
    }

    public final Completable mergeDelayError(Iterable<? extends Completable> other) {
        return new IterableMergeCompletable(true, this, other, this.executor);
    }

    public final Completable retry(BiIntPredicate<Throwable> shouldRetry) {
        return this.toSingle().retry(shouldRetry).ignoreElement();
    }

    public final Completable retryWhen(BiIntFunction<Throwable, ? extends Completable> retryWhen) {
        return this.toSingle().retryWhen(retryWhen).ignoreElement();
    }

    public final Publisher<Void> repeat(IntPredicate shouldRepeat) {
        return this.toSingle().repeat(shouldRepeat);
    }

    public final Publisher<Void> repeatWhen(IntFunction<? extends Completable> repeatWhen) {
        return this.toSingle().repeatWhen(repeatWhen);
    }

    public final Completable beforeOnSubscribe(Consumer<Cancellable> onSubscribe) {
        return this.beforeSubscriber(CompletableDoOnUtils.doOnSubscribeSupplier(onSubscribe));
    }

    public final Completable beforeOnComplete(Runnable onComplete) {
        return this.beforeSubscriber(CompletableDoOnUtils.doOnCompleteSupplier(onComplete));
    }

    public final Completable beforeOnError(Consumer<Throwable> onError) {
        return this.beforeSubscriber(CompletableDoOnUtils.doOnErrorSupplier(onError));
    }

    public final Completable beforeCancel(Runnable onCancel) {
        return new DoCancellableCompletable(this, onCancel::run, true, this.executor);
    }

    public final Completable beforeFinally(Runnable doFinally) {
        return this.beforeFinally(new RunnableTerminalSignalConsumer(doFinally));
    }

    public final Completable beforeFinally(TerminalSignalConsumer doFinally) {
        return new BeforeFinallyCompletable(this, doFinally, this.executor);
    }

    public final Completable beforeSubscriber(Supplier<? extends CompletableSource.Subscriber> subscriberSupplier) {
        return new BeforeSubscriberCompletable(this, subscriberSupplier, this.executor);
    }

    public final Completable afterOnSubscribe(Consumer<Cancellable> onSubscribe) {
        return this.afterSubscriber(CompletableDoOnUtils.doOnSubscribeSupplier(onSubscribe));
    }

    public final Completable whenOnSubscribe(Consumer<Cancellable> onSubscribe) {
        return this.beforeOnSubscribe(onSubscribe);
    }

    public final Completable afterOnComplete(Runnable onComplete) {
        return this.afterSubscriber(CompletableDoOnUtils.doOnCompleteSupplier(onComplete));
    }

    public final Completable afterOnError(Consumer<Throwable> onError) {
        return this.afterSubscriber(CompletableDoOnUtils.doOnErrorSupplier(onError));
    }

    public final Completable afterCancel(Runnable onCancel) {
        return new DoCancellableCompletable(this, onCancel::run, false, this.executor);
    }

    public final Completable afterFinally(Runnable doFinally) {
        return this.afterFinally(new RunnableTerminalSignalConsumer(doFinally));
    }

    public final Completable afterFinally(TerminalSignalConsumer doFinally) {
        return new AfterFinallyCompletable(this, doFinally, this.executor);
    }

    public final Completable afterSubscriber(Supplier<? extends CompletableSource.Subscriber> subscriberSupplier) {
        return new AfterSubscriberCompletable(this, subscriberSupplier, this.executor);
    }

    public final Completable whenSubscriber(Supplier<? extends CompletableSource.Subscriber> subscriberSupplier) {
        return this.beforeSubscriber(subscriberSupplier);
    }

    public final Completable liftSync(CompletableOperator operator) {
        return new LiftSynchronousCompletableOperator(this, operator, this.executor);
    }

    public final Completable liftAsync(CompletableOperator operator) {
        return new LiftAsynchronousCompletableOperator(this, operator, this.executor);
    }

    public final Completable publishOn(Executor executor) {
        return this.publishOn((io.servicetalk.concurrent.api.Executor)executor);
    }

    @Deprecated
    public final Completable publishOn(io.servicetalk.concurrent.api.Executor executor) {
        return PublishAndSubscribeOnCompletables.publishOn(this, executor);
    }

    @Deprecated
    public final Completable publishOnOverride(io.servicetalk.concurrent.api.Executor executor) {
        return PublishAndSubscribeOnCompletables.publishOnOverride(this, executor);
    }

    public final Completable subscribeOn(Executor executor) {
        return this.subscribeOn((io.servicetalk.concurrent.api.Executor)executor);
    }

    @Deprecated
    public final Completable subscribeOn(io.servicetalk.concurrent.api.Executor executor) {
        return PublishAndSubscribeOnCompletables.subscribeOn(this, executor);
    }

    @Deprecated
    public final Completable subscribeOnOverride(io.servicetalk.concurrent.api.Executor executor) {
        return PublishAndSubscribeOnCompletables.subscribeOnOverride(this, executor);
    }

    @Deprecated
    public final Completable publishAndSubscribeOn(io.servicetalk.concurrent.api.Executor executor) {
        return PublishAndSubscribeOnCompletables.publishAndSubscribeOn(this, executor);
    }

    @Deprecated
    public final Completable publishAndSubscribeOnOverride(io.servicetalk.concurrent.api.Executor executor) {
        return PublishAndSubscribeOnCompletables.publishAndSubscribeOnOverride(this, executor);
    }

    public final Completable shareContextOnSubscribe() {
        return new CompletableShareContextOnSubscribe(this);
    }

    @Deprecated
    public final Completable subscribeShareContext() {
        return this.shareContextOnSubscribe();
    }

    public final Completable ambWith(Completable other) {
        return this.toSingle().ambWith(other.toSingle()).ignoreElement();
    }

    public final <T> Publisher<T> toPublisher() {
        return new CompletableToPublisher(this, this.executor);
    }

    public final Single<Void> toSingle() {
        return new CompletableToSingle<Void>(this, this.executor);
    }

    public final CompletionStage<Void> toCompletionStage() {
        return this.toSingle().toCompletionStage();
    }

    public final Future<Void> toFuture() {
        return SourceToFuture.CompletableToFuture.createAndSubscribe(this);
    }

    protected final void subscribeInternal(CompletableSource.Subscriber subscriber) {
        AsyncContextProvider provider = AsyncContext.provider();
        this.subscribeWithContext(subscriber, provider, this.shareContextOnSubscribe ? provider.context() : provider.context().copy());
    }

    public final Cancellable subscribe() {
        SimpleCompletableSubscriber subscriber = new SimpleCompletableSubscriber();
        this.subscribeInternal(subscriber);
        return subscriber;
    }

    public final Cancellable subscribe(Runnable onComplete) {
        SimpleCompletableSubscriber subscriber = new SimpleCompletableSubscriber(onComplete);
        this.subscribeInternal(subscriber);
        return subscriber;
    }

    protected abstract void handleSubscribe(CompletableSource.Subscriber var1);

    public static Completable completed() {
        return CompletedCompletable.INSTANCE;
    }

    public static Completable fromRunnable(Runnable runnable) {
        return new RunnableCompletable(runnable);
    }

    public static Completable failed(Throwable cause) {
        return new FailedCompletable(Objects.requireNonNull(cause));
    }

    public static Completable never() {
        return NeverCompletable.INSTANCE;
    }

    public static Completable defer(Supplier<? extends Completable> completableSupplier) {
        return new CompletableDefer(completableSupplier);
    }

    public static Completable fromFuture(Future<?> future) {
        return Single.fromFuture(future).toCompletable();
    }

    public static Completable fromStage(CompletionStage<?> stage) {
        return Single.fromStage(stage).toCompletable();
    }

    public static Completable mergeAll(Iterable<? extends Completable> completables) {
        return Publisher.fromIterable(completables).flatMapCompletable(Function.identity());
    }

    public static Completable mergeAll(Completable ... completables) {
        return Publisher.from(completables).flatMapCompletable(Function.identity());
    }

    public static Completable mergeAll(Iterable<? extends Completable> completables, int maxConcurrency) {
        return Publisher.fromIterable(completables).flatMapCompletable(Function.identity(), maxConcurrency);
    }

    public static Completable mergeAll(int maxConcurrency, Completable ... completables) {
        return Publisher.from(completables).flatMapCompletable(Function.identity(), maxConcurrency);
    }

    public static Completable mergeAllDelayError(Iterable<? extends Completable> completables) {
        return Publisher.fromIterable(completables).flatMapCompletableDelayError(Function.identity());
    }

    public static Completable mergeAllDelayError(Completable ... completables) {
        return Publisher.from(completables).flatMapCompletableDelayError(Function.identity());
    }

    public static Completable mergeAllDelayError(Iterable<? extends Completable> completables, int maxConcurrency) {
        return Publisher.fromIterable(completables).flatMapCompletableDelayError(Function.identity(), maxConcurrency);
    }

    public static Completable mergeAllDelayError(int maxConcurrency, Completable ... completables) {
        return Publisher.from(completables).flatMapCompletableDelayError(Function.identity(), maxConcurrency);
    }

    public static Completable amb(Completable ... completables) {
        return Single.amb(StreamSupport.stream(Arrays.spliterator(completables), false).map(Completable::toSingle).collect(Collectors.toList())).ignoreElement();
    }

    public static Completable amb(Iterable<Completable> completables) {
        return Single.amb(StreamSupport.stream(completables.spliterator(), false).map(Completable::toSingle).collect(Collectors.toList())).ignoreElement();
    }

    public static Completable anyOf(Completable ... completables) {
        return Completable.amb(completables);
    }

    public static Completable anyOf(Iterable<Completable> completables) {
        return Completable.amb(completables);
    }

    final void subscribeWithSharedContext(CompletableSource.Subscriber subscriber, AsyncContextProvider provider) {
        this.subscribeWithContext(subscriber, provider, provider.context());
    }

    final void delegateSubscribe(CompletableSource.Subscriber subscriber, SignalOffloader signalOffloader, ContextMap contextMap, AsyncContextProvider contextProvider) {
        this.handleSubscribe(subscriber, signalOffloader, contextMap, contextProvider);
    }

    private void subscribeWithContext(CompletableSource.Subscriber subscriber, AsyncContextProvider provider, ContextMap contextMap) {
        CompletableSource.Subscriber offloadedSubscriber;
        SignalOffloader signalOffloader;
        Objects.requireNonNull(subscriber);
        try {
            signalOffloader = SignalOffloaders.newOffloaderFor(this.executor);
            offloadedSubscriber = signalOffloader.offloadCancellable(provider.wrapCancellable(subscriber, contextMap));
        }
        catch (Throwable t) {
            SubscriberUtils.deliverErrorFromSource(subscriber, t);
            return;
        }
        signalOffloader.offloadSubscribe(offloadedSubscriber, provider.wrapConsumer(s -> this.handleSubscribe((CompletableSource.Subscriber)s, signalOffloader, contextMap, provider), contextMap));
    }

    void handleSubscribe(CompletableSource.Subscriber subscriber, SignalOffloader signalOffloader, ContextMap contextMap, AsyncContextProvider contextProvider) {
        try {
            CompletableSource.Subscriber offloaded = signalOffloader.offloadSubscriber(contextProvider.wrapCompletableSubscriber(subscriber, contextMap));
            this.handleSubscribe(offloaded);
        }
        catch (Throwable t) {
            LOGGER.warn("Unexpected exception from subscribe(), assuming no interaction with the Subscriber.", t);
            SubscriberUtils.deliverErrorFromSource(subscriber, t);
        }
    }

    final io.servicetalk.concurrent.api.Executor executor() {
        return this.executor;
    }

    static {
        AsyncContext.autoEnable();
    }
}

