/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.api.AsyncContextMap;
import io.servicetalk.concurrent.internal.ContextMapUtils;
import io.servicetalk.context.api.ContextMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
final class AsyncContextMapToContextMapAdapter
implements AsyncContextMap {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncContextMapToContextMapAdapter.class);
    private static final ConcurrentMap<AsyncContextMap.Key<?>, ContextMap.Key<?>> acmToCm = new ConcurrentHashMap();
    private static final ConcurrentMap<ContextMap.Key<?>, AsyncContextMap.Key<?>> cmToAcm = new ConcurrentHashMap();
    private final ContextMap contextMap;

    AsyncContextMapToContextMapAdapter(ContextMap contextMap) {
        this.contextMap = Objects.requireNonNull(contextMap);
    }

    static <T> void newKeyMapping(AsyncContextMap.Key<T> acmKey, ContextMap.Key<T> cmKey) {
        ContextMap.Key<T> oldCmKey = acmToCm.putIfAbsent(acmKey, cmKey);
        AsyncContextMap.Key<T> oldAcmKey = cmToAcm.putIfAbsent(cmKey, acmKey);
        if (oldCmKey != null || oldAcmKey != null) {
            LOGGER.warn("Tried to register a new mapping of AsyncContextMap.Key={} to {}, but other mappings already exist: AsyncContextMap.Key={} to {} and/or {} to AsyncContextMap.Key={}. Discarding request.", acmKey, cmKey, acmKey, oldCmKey, cmKey, oldAcmKey);
        }
    }

    private static <T> ContextMap.Key<?> toCmKey(AsyncContextMap.Key<T> acmKey) {
        Objects.requireNonNull(acmKey);
        ContextMap.Key cmKey = acmToCm.computeIfAbsent(acmKey, k -> {
            ContextMap.Key<Object> newCmKey = ContextMap.Key.newKey(k.toString(), Object.class);
            LOGGER.info("Created a {} mapping for unknown AsyncContextMap.Key={}. Migrate your keys to {} API. If migration is complicated, consider temporarily using AsyncContext.newKeyMapping(AsyncContextMap.Key, ContextMap.Key) to register AsyncContextMap.Key(s).", newCmKey, k, ContextMap.Key.class.getCanonicalName());
            return newCmKey;
        });
        LOGGER.trace("Using {} to lookup AsyncContextMap.Key={}", (Object)cmKey, (Object)acmKey);
        return cmKey;
    }

    @Nullable
    private static AsyncContextMap.Key<?> toAcmKey(@Nullable ContextMap.Key<?> cmKey) {
        if (cmKey == null) {
            return null;
        }
        AsyncContextMap.Key acmKey = cmToAcm.computeIfAbsent(cmKey, k -> {
            AsyncContextMap.Key newAcmKey = AsyncContextMap.Key.newKey(k.toString());
            LOGGER.info("Created an AsyncContextMap.Key={} mapping for unknown {}. Migrate your keys to {} API. If migration is complicated, consider temporarily using AsyncContext.newKeyMapping(AsyncContextMap.Key, ContextMap.Key) to register AsyncContextMap.Key(s).", newAcmKey, k, ContextMap.Key.class.getCanonicalName());
            return newAcmKey;
        });
        LOGGER.trace("Using AsyncContextMap.Key={} to lookup {}", (Object)acmKey, (Object)cmKey);
        return acmKey;
    }

    @Override
    @Nullable
    public <T> T get(AsyncContextMap.Key<T> key) {
        return (T)this.contextMap.get(AsyncContextMapToContextMapAdapter.toCmKey(key));
    }

    @Override
    public boolean containsKey(AsyncContextMap.Key<?> key) {
        return this.contextMap.containsKey(AsyncContextMapToContextMapAdapter.toCmKey(key));
    }

    @Override
    public boolean isEmpty() {
        return this.contextMap.isEmpty();
    }

    @Override
    public int size() {
        return this.contextMap.size();
    }

    @Override
    @Nullable
    public <T> T put(AsyncContextMap.Key<T> key, @Nullable T value) {
        ContextMap.Key<?> cmKey = AsyncContextMapToContextMapAdapter.toCmKey(key);
        if (Object.class.equals(cmKey.type())) {
            return (T)this.contextMap.put(cmKey, value);
        }
        return (T)this.contextMap.put(cmKey, value);
    }

    @Override
    public void putAll(Map<AsyncContextMap.Key<?>, Object> map) {
        if (map.isEmpty()) {
            return;
        }
        HashMap cMap = new HashMap(map.size());
        for (Map.Entry<AsyncContextMap.Key<?>, Object> entry : map.entrySet()) {
            cMap.put(AsyncContextMapToContextMapAdapter.toCmKey(entry.getKey()), entry.getValue());
        }
        this.contextMap.putAll(cMap);
    }

    @Override
    @Nullable
    public <T> T remove(AsyncContextMap.Key<T> key) {
        return (T)this.contextMap.remove(AsyncContextMapToContextMapAdapter.toCmKey(key));
    }

    @Override
    public boolean removeAll(Iterable<AsyncContextMap.Key<?>> entries) {
        ArrayList cKeys = new ArrayList();
        for (AsyncContextMap.Key<?> key : entries) {
            cKeys.add(AsyncContextMapToContextMapAdapter.toCmKey(key));
        }
        return this.contextMap.removeAll(cKeys);
    }

    @Override
    public void clear() {
        this.contextMap.clear();
    }

    @Override
    @Nullable
    public AsyncContextMap.Key<?> forEach(BiPredicate<AsyncContextMap.Key<?>, Object> consumer) {
        return AsyncContextMapToContextMapAdapter.toAcmKey(this.contextMap.forEach((ContextMap.Key<?> cmKey, Object value) -> consumer.test(AsyncContextMapToContextMapAdapter.toAcmKey(cmKey), value)));
    }

    @Override
    public AsyncContextMap copy() {
        return new AsyncContextMapToContextMapAdapter(this.contextMap.copy());
    }

    public String toString() {
        return this.getClass().getSimpleName() + '-' + ContextMapUtils.toString(this.contextMap);
    }
}

