/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.api.AsyncContextExecutorPlugin;
import io.servicetalk.concurrent.api.AsyncContextMap;
import io.servicetalk.concurrent.api.AsyncContextMapToContextMapAdapter;
import io.servicetalk.concurrent.api.AsyncContextProvider;
import io.servicetalk.concurrent.api.DefaultAsyncContextProvider;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.Executors;
import io.servicetalk.concurrent.api.NoopAsyncContextProvider;
import io.servicetalk.context.api.ContextMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AsyncContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncContext.class);
    private static final int STATE_DISABLED = -1;
    private static final int STATE_INIT = 0;
    private static final int STATE_AUTO_ENABLED = 1;
    private static final int STATE_ENABLED = 2;
    private static final AtomicInteger ENABLED_STATE = new AtomicInteger(0);
    private static AsyncContextProvider provider = DefaultAsyncContextProvider.INSTANCE;

    private AsyncContext() {
    }

    static AsyncContextProvider provider() {
        return provider;
    }

    @Deprecated
    public static AsyncContextMap current() {
        return AsyncContext.provider().contextMap();
    }

    public static ContextMap context() {
        return AsyncContext.provider().context();
    }

    @Deprecated
    public static <T> void newKeyMapping(AsyncContextMap.Key<T> acmKey, ContextMap.Key<T> cmKey) {
        AsyncContextMapToContextMapAdapter.newKeyMapping(acmKey, cmKey);
    }

    @Deprecated
    public static <T> void put(AsyncContextMap.Key<T> key, @Nullable T value) {
        AsyncContext.current().put(key, value);
    }

    @Nullable
    public static <T> T put(ContextMap.Key<T> key, @Nullable T value) {
        return AsyncContext.context().put(key, value);
    }

    @Nullable
    public static <T> T putIfAbsent(ContextMap.Key<T> key, @Nullable T value) {
        return AsyncContext.context().putIfAbsent(key, value);
    }

    @Nullable
    public static <T> T computeIfAbsent(ContextMap.Key<T> key, Function<ContextMap.Key<T>, T> computeFunction) {
        return AsyncContext.context().computeIfAbsent(key, computeFunction);
    }

    public static void putAll(ContextMap map) {
        AsyncContext.context().putAll(map);
    }

    @Deprecated
    public static void putAll(Map<AsyncContextMap.Key<?>, Object> map) {
        AsyncContext.current().putAll(map);
    }

    public static void putAllFromMap(Map<ContextMap.Key<?>, Object> map) {
        AsyncContext.context().putAll(map);
    }

    @Deprecated
    public static void remove(AsyncContextMap.Key<?> key) {
        AsyncContext.current().remove(key);
    }

    @Nullable
    public static <T> T remove(ContextMap.Key<T> key) {
        return AsyncContext.context().remove(key);
    }

    @Deprecated
    public static void removeAll(Iterable<AsyncContextMap.Key<?>> entries) {
        AsyncContext.current().removeAll(entries);
    }

    public static boolean removeAllEntries(Iterable<ContextMap.Key<?>> keys) {
        return AsyncContext.context().removeAll(keys);
    }

    public static void clear() {
        AsyncContext.context().clear();
    }

    @Deprecated
    @Nullable
    public static <T> T get(AsyncContextMap.Key<T> key) {
        return AsyncContext.current().get(key);
    }

    @Nullable
    public static <T> T get(ContextMap.Key<T> key) {
        return AsyncContext.context().get(key);
    }

    @Nullable
    public static <T> T getOrDefault(ContextMap.Key<T> key, T defaultValue) {
        return AsyncContext.context().getOrDefault(key, defaultValue);
    }

    @Deprecated
    public static boolean containsKey(AsyncContextMap.Key<?> key) {
        return AsyncContext.current().containsKey(key);
    }

    public static boolean containsKey(ContextMap.Key<?> key) {
        return AsyncContext.context().containsKey(key);
    }

    public static boolean containsValue(Object value) {
        return AsyncContext.context().containsValue(value);
    }

    public static <T> boolean contains(ContextMap.Key<T> key, @Nullable T value) {
        return AsyncContext.context().contains(key, value);
    }

    public static int size() {
        return AsyncContext.context().size();
    }

    public static boolean isEmpty() {
        return AsyncContext.context().isEmpty();
    }

    @Deprecated
    @Nullable
    public static AsyncContextMap.Key<?> forEach(BiPredicate<AsyncContextMap.Key<?>, Object> consumer) {
        return AsyncContext.current().forEach(consumer);
    }

    @Nullable
    public static ContextMap.Key<?> forEachEntry(BiPredicate<ContextMap.Key<?>, Object> consumer) {
        return AsyncContext.context().forEach(consumer);
    }

    public static java.util.concurrent.Executor wrapJdkExecutor(java.util.concurrent.Executor executor) {
        return AsyncContext.provider().wrapJdkExecutor(executor);
    }

    public static Executor wrapExecutor(Executor executor) {
        return AsyncContext.provider().wrapExecutor(executor);
    }

    public static ExecutorService wrapJdkExecutorService(ExecutorService executor) {
        return AsyncContext.provider().wrapJdkExecutorService(executor);
    }

    public static ScheduledExecutorService wrapJdkScheduledExecutorService(ScheduledExecutorService executor) {
        return AsyncContext.provider().wrapJdkScheduledExecutorService(executor);
    }

    public static Runnable wrapRunnable(Runnable runnable) {
        AsyncContextProvider provider = AsyncContext.provider();
        return provider.wrapRunnable(runnable, provider.context());
    }

    public static <V> Callable<V> wrapCallable(Callable<V> callable) {
        AsyncContextProvider provider = AsyncContext.provider();
        return provider.wrapCallable(callable, provider.context());
    }

    public static <T> Consumer<T> wrapConsumer(Consumer<T> consumer) {
        AsyncContextProvider provider = AsyncContext.provider();
        return provider.wrapConsumer(consumer, provider.context());
    }

    public static <T, U> Function<T, U> wrapFunction(Function<T, U> func) {
        AsyncContextProvider provider = AsyncContext.provider();
        return provider.wrapFunction(func, provider.context());
    }

    public static <T, U> BiConsumer<T, U> wrapBiConsume(BiConsumer<T, U> consumer) {
        AsyncContextProvider provider = AsyncContext.provider();
        return provider.wrapBiConsumer(consumer, provider.context());
    }

    public static <T, U, V> BiFunction<T, U, V> wrapBiFunction(BiFunction<T, U, V> func) {
        AsyncContextProvider provider = AsyncContext.provider();
        return provider.wrapBiFunction(func, provider.context());
    }

    public static void disable() {
        if (ENABLED_STATE.getAndSet(-1) != -1) {
            AsyncContext.disable0();
        }
    }

    public static boolean isDisabled() {
        return ENABLED_STATE.get() == -1;
    }

    static void enable() {
        block1: {
            int enabledState;
            while (!ENABLED_STATE.compareAndSet(enabledState = ENABLED_STATE.get(), 2)) {
            }
            if (enabledState == 2 || enabledState == 1) break block1;
            AsyncContext.enable0();
        }
    }

    static void autoEnable() {
        if (ENABLED_STATE.compareAndSet(0, 1)) {
            AsyncContext.enable0();
        }
    }

    private static void enable0() {
        provider = DefaultAsyncContextProvider.INSTANCE;
        Executors.EXECUTOR_PLUGINS.add(AsyncContextExecutorPlugin.EXECUTOR_PLUGIN);
        LOGGER.debug("Enabled.");
        if (ENABLED_STATE.get() == -1) {
            AsyncContext.disable0();
        }
    }

    private static void disable0() {
        provider = NoopAsyncContextProvider.INSTANCE;
        Executors.EXECUTOR_PLUGINS.remove(AsyncContextExecutorPlugin.EXECUTOR_PLUGIN);
        LOGGER.info("Disabled. Features that depend on AsyncContext will stop working.");
    }
}

