/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.AbstractNoHandleSubscribePublisher;
import io.servicetalk.concurrent.api.AsyncContextProvider;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.PublisherOperator;
import io.servicetalk.concurrent.internal.SignalOffloader;
import io.servicetalk.context.api.ContextMap;
import java.util.Objects;

abstract class AbstractAsynchronousPublisherOperator<T, R>
extends AbstractNoHandleSubscribePublisher<R>
implements PublisherOperator<T, R> {
    private final Publisher<T> original;

    AbstractAsynchronousPublisherOperator(Publisher<T> original, Executor executor) {
        super(executor);
        this.original = Objects.requireNonNull(original);
    }

    @Override
    final void handleSubscribe(PublisherSource.Subscriber<? super R> subscriber, SignalOffloader signalOffloader, ContextMap contextMap, AsyncContextProvider contextProvider) {
        PublisherSource.Subscriber<? super R> operatorSubscriber = signalOffloader.offloadSubscriber(contextProvider.wrapPublisherSubscriberAndSubscription(subscriber, contextMap));
        PublisherSource.Subscriber upstreamSubscriber = signalOffloader.offloadSubscription(this.apply(operatorSubscriber));
        this.original.delegateSubscribe(upstreamSubscriber, signalOffloader, contextMap, contextProvider);
    }
}

