/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.client.api;

import io.servicetalk.client.api.AutoRetryStrategyProvider;
import io.servicetalk.client.api.LoadBalancerReadySubscriber;
import io.servicetalk.client.api.NoAvailableHostException;
import io.servicetalk.concurrent.api.AsyncCloseable;
import io.servicetalk.concurrent.api.AsyncCloseables;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.SourceAdapters;
import io.servicetalk.transport.api.RetryableException;
import javax.annotation.Nullable;

@Deprecated
public final class DefaultAutoRetryStrategyProvider
implements AutoRetryStrategyProvider {
    private final int maxRetryCount;
    private final boolean waitForLb;
    private final boolean ignoreSdErrors;
    private final boolean retryAllRetryableExceptions;

    private DefaultAutoRetryStrategyProvider(int maxRetryCount, boolean waitForLb, boolean ignoreSdErrors, boolean retryAllRetryableExceptions) {
        this.maxRetryCount = maxRetryCount;
        this.waitForLb = waitForLb;
        this.ignoreSdErrors = ignoreSdErrors;
        this.retryAllRetryableExceptions = retryAllRetryableExceptions;
    }

    @Override
    public AutoRetryStrategyProvider.AutoRetryStrategy newStrategy(Publisher<Object> lbEventStream, Completable sdStatus) {
        if (!this.waitForLb && !this.retryAllRetryableExceptions) {
            return (count, cause) -> Completable.failed(cause);
        }
        return new DefaultAutoRetryStrategy(this.maxRetryCount, this.waitForLb, this.retryAllRetryableExceptions, lbEventStream, this.ignoreSdErrors ? null : sdStatus);
    }

    private static final class DefaultAutoRetryStrategy
    implements AutoRetryStrategyProvider.AutoRetryStrategy {
        @Nullable
        private final LoadBalancerReadySubscriber loadBalancerReadySubscriber;
        @Nullable
        private final Completable sdStatus;
        private final AsyncCloseable closeAsync;
        private final int maxRetryCount;
        private final boolean retryAllRetryableExceptions;

        DefaultAutoRetryStrategy(int maxRetryCount, boolean waitForLb, boolean retryAllRetryableExceptions, Publisher<Object> lbEventStream, @Nullable Completable sdStatus) {
            this.maxRetryCount = maxRetryCount;
            this.sdStatus = sdStatus;
            this.retryAllRetryableExceptions = retryAllRetryableExceptions;
            if (waitForLb) {
                this.loadBalancerReadySubscriber = new LoadBalancerReadySubscriber();
                this.closeAsync = AsyncCloseables.toAsyncCloseable(__ -> {
                    this.loadBalancerReadySubscriber.cancel();
                    return Completable.completed();
                });
                SourceAdapters.toSource(lbEventStream).subscribe(this.loadBalancerReadySubscriber);
            } else {
                this.loadBalancerReadySubscriber = null;
                this.closeAsync = AsyncCloseables.emptyAsyncCloseable();
            }
        }

        @Override
        public Completable apply(int count, Throwable cause) {
            if (count > this.maxRetryCount) {
                return Completable.failed(cause);
            }
            if (this.loadBalancerReadySubscriber != null && cause instanceof NoAvailableHostException) {
                Completable onHostsAvailable = this.loadBalancerReadySubscriber.onHostsAvailable();
                return this.sdStatus == null ? onHostsAvailable : onHostsAvailable.ambWith(this.sdStatus);
            }
            if (this.retryAllRetryableExceptions && cause instanceof RetryableException) {
                return Completable.completed();
            }
            return Completable.failed(cause);
        }

        @Override
        public Completable closeAsync() {
            return this.closeAsync.closeAsync();
        }

        @Override
        public Completable closeAsyncGracefully() {
            return this.closeAsync.closeAsyncGracefully();
        }
    }

    @Deprecated
    public static final class Builder {
        private boolean waitForLb = true;
        private boolean ignoreSdErrors;
        private boolean retryAllRetryableExceptions = true;
        private int maxRetries = 4;

        @Deprecated
        public Builder disableWaitForLoadBalancer() {
            return this.waitForLoadBalancer(false);
        }

        public Builder waitForLoadBalancer(boolean waitForLb) {
            this.waitForLb = waitForLb;
            return this;
        }

        public Builder ignoreServiceDiscovererErrors() {
            this.ignoreSdErrors = true;
            return this;
        }

        @Deprecated
        public Builder disableRetryAllRetryableExceptions() {
            return this.retryAllRetryableExceptions(false);
        }

        public Builder retryAllRetryableExceptions(boolean retryAllRetryableExceptions) {
            this.retryAllRetryableExceptions = retryAllRetryableExceptions;
            return this;
        }

        public Builder maxRetries(int maxRetries) {
            if (maxRetries <= 0) {
                throw new IllegalArgumentException("maxRetries " + maxRetries + " (expected >0)");
            }
            this.maxRetries = maxRetries;
            return this;
        }

        public AutoRetryStrategyProvider build() {
            return new DefaultAutoRetryStrategyProvider(this.maxRetries, this.waitForLb, this.ignoreSdErrors, this.retryAllRetryableExceptions);
        }
    }
}

