/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.utils.internal;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.security.AccessController;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReflectionUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReflectionUtils.class);
    private static final int JAVA_VERSION = ReflectionUtils.javaVersion0();
    private static final boolean IS_EXPLICIT_TRY_REFLECTION_SET_ACCESSIBLE = ReflectionUtils.explicitTryReflectionSetAccessible0();

    private ReflectionUtils() {
    }

    public static Method retrieveMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        try {
            Method method = clazz.getMethod(name, parameterTypes);
            return method;
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Can not retrieve method " + name, e);
        }
    }

    @Nullable
    static Throwable trySetAccessible(AccessibleObject object, boolean checkAccessible) {
        if (checkAccessible && !IS_EXPLICIT_TRY_REFLECTION_SET_ACCESSIBLE) {
            return new UnsupportedOperationException("Reflective setAccessible(true) disabled");
        }
        try {
            object.setAccessible(true);
            return null;
        }
        catch (SecurityException e) {
            return e;
        }
        catch (RuntimeException e) {
            return ReflectionUtils.handleInaccessibleObjectException(e);
        }
    }

    private static RuntimeException handleInaccessibleObjectException(RuntimeException e) {
        if ("java.lang.reflect.InaccessibleObjectException".equals(e.getClass().getName())) {
            return e;
        }
        throw e;
    }

    private static boolean explicitTryReflectionSetAccessible0() {
        return ReflectionUtils.getBoolean("io.servicetalk.tryReflectionSetAccessible", JAVA_VERSION < 9);
    }

    static boolean getBoolean(String name, boolean def) {
        String value = System.getProperty(name);
        if (value == null || value.isEmpty()) {
            return def;
        }
        boolean result = false;
        try {
            result = Boolean.parseBoolean(value);
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            // empty catch block
        }
        return result;
    }

    private static int javaVersion0() {
        int majorVersion = ReflectionUtils.isAndroid0() ? 6 : ReflectionUtils.majorVersionFromJavaSpecificationVersion();
        LOGGER.debug("Java version: {}", (Object)majorVersion);
        return majorVersion;
    }

    private static boolean isAndroid0() {
        String vmName = System.getProperty("java.vm.name");
        boolean isAndroid = "Dalvik".equals(vmName);
        if (isAndroid) {
            LOGGER.debug("Platform: Android");
        }
        return isAndroid;
    }

    private static int majorVersionFromJavaSpecificationVersion() {
        return ReflectionUtils.majorVersion(System.getProperty("java.specification.version", "1.6"));
    }

    private static int majorVersion(String javaSpecVersion) {
        String[] components = javaSpecVersion.split("\\.");
        int[] version = new int[components.length];
        for (int i = 0; i < components.length; ++i) {
            version[i] = Integer.parseInt(components[i]);
        }
        if (version[0] == 1) {
            assert (version[1] >= 6);
            return version[1];
        }
        return version[0];
    }

    @Nullable
    static <T extends AccessibleObject> MethodHandle lookupAccessibleObject(AccessibleObjectSupplier<T> tLookup, Class<T> clazz, MethodHandleFunction<T> function) {
        Object maybeAccessibleObject = AccessController.doPrivileged(() -> {
            try {
                Object accessibleObject = tLookup.get();
                if (accessibleObject == null) {
                    return null;
                }
                Throwable cause = ReflectionUtils.trySetAccessible(accessibleObject, true);
                if (cause != null) {
                    return cause;
                }
                return accessibleObject;
            }
            catch (ClassNotFoundException | NoSuchMethodException | SecurityException e) {
                return e;
            }
        });
        if (!clazz.isInstance(maybeAccessibleObject)) {
            return null;
        }
        try {
            return function.apply(clazz.cast(maybeAccessibleObject));
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    @Nullable
    static MethodHandle extractNioBitsMethod(String methodName, MethodHandles.Lookup lookup) {
        return ReflectionUtils.lookupAccessibleObject(() -> {
            Class<?> bitsClass = Class.forName("java.nio.Bits", false, ReflectionUtils.getSystemClassLoader());
            return bitsClass.getDeclaredMethod(methodName, Long.TYPE, Integer.TYPE);
        }, Method.class, method -> {
            MethodHandle methodHandle = lookup.unreflect((Method)method);
            methodHandle.invoke(1L, 1);
            return methodHandle;
        });
    }

    private static ClassLoader getSystemClassLoader() {
        if (System.getSecurityManager() == null) {
            return ClassLoader.getSystemClassLoader();
        }
        return AccessController.doPrivileged(ClassLoader::getSystemClassLoader);
    }

    @FunctionalInterface
    static interface MethodHandleFunction<T> {
        @Nullable
        public MethodHandle apply(T var1) throws Throwable;
    }

    @FunctionalInterface
    static interface AccessibleObjectSupplier<T extends AccessibleObject> {
        @Nullable
        public T get() throws ClassNotFoundException, NoSuchMethodException;
    }
}

