/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.transport.netty.internal;

import io.netty.channel.Channel;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.servicetalk.transport.netty.internal.ChannelInitializer;
import io.servicetalk.transport.netty.internal.CopyByteBufHandlerChannelInitializer;
import io.servicetalk.transport.netty.internal.DeferSslHandler;
import io.servicetalk.transport.netty.internal.SslUtils;
import java.util.Objects;
import javax.annotation.Nullable;

public class SslClientChannelInitializer
implements ChannelInitializer {
    @Nullable
    private final String hostnameVerificationAlgorithm;
    @Nullable
    private final String hostnameVerificationHost;
    private final int hostnameVerificationPort;
    private final SslContext sslContext;
    private final boolean deferSslHandler;

    public SslClientChannelInitializer(SslContext sslContext, @Nullable String hostnameVerificationAlgorithm, @Nullable String hostnameVerificationHost, int hostnameVerificationPort, boolean deferSslHandler) {
        this.sslContext = Objects.requireNonNull(sslContext);
        this.hostnameVerificationAlgorithm = hostnameVerificationAlgorithm;
        this.hostnameVerificationHost = hostnameVerificationHost;
        this.hostnameVerificationPort = hostnameVerificationPort;
        this.deferSslHandler = deferSslHandler;
    }

    @Override
    public void init(Channel channel) {
        SslHandler sslHandler = SslUtils.newHandler(this.sslContext, CopyByteBufHandlerChannelInitializer.POOLED_ALLOCATOR, this.hostnameVerificationAlgorithm, this.hostnameVerificationHost, this.hostnameVerificationPort);
        channel.pipeline().addLast(this.deferSslHandler ? new DeferSslHandler(channel, sslHandler) : sslHandler);
    }
}

