/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.transport.netty.internal;

import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelOption;
import io.netty.channel.WriteBufferWaterMark;
import io.servicetalk.transport.api.ServiceTalkSocketOptions;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.util.Map;
import javax.annotation.Nullable;

public final class SocketOptionUtils {
    private SocketOptionUtils() {
    }

    public static <T> void addOption(Map<ChannelOption, Object> channelOpts, SocketOption<T> option, Object value) {
        if (option == StandardSocketOptions.IP_MULTICAST_IF) {
            channelOpts.put(ChannelOption.IP_MULTICAST_IF, value);
        } else if (option == StandardSocketOptions.IP_MULTICAST_LOOP) {
            channelOpts.put(ChannelOption.IP_MULTICAST_LOOP_DISABLED, (Boolean)value == false);
        } else if (option == StandardSocketOptions.IP_MULTICAST_TTL) {
            channelOpts.put(ChannelOption.IP_MULTICAST_TTL, value);
        } else if (option == StandardSocketOptions.IP_TOS) {
            channelOpts.put(ChannelOption.IP_TOS, value);
        } else if (option == StandardSocketOptions.SO_BROADCAST) {
            channelOpts.put(ChannelOption.SO_BROADCAST, value);
        } else if (option == StandardSocketOptions.SO_KEEPALIVE) {
            channelOpts.put(ChannelOption.SO_KEEPALIVE, value);
        } else if (option == StandardSocketOptions.SO_LINGER) {
            channelOpts.put(ChannelOption.SO_LINGER, value);
        } else if (option == StandardSocketOptions.SO_RCVBUF) {
            channelOpts.put(ChannelOption.SO_RCVBUF, value);
        } else if (option == StandardSocketOptions.SO_REUSEADDR) {
            channelOpts.put(ChannelOption.SO_REUSEADDR, value);
        } else if (option == StandardSocketOptions.SO_SNDBUF) {
            channelOpts.put(ChannelOption.SO_SNDBUF, value);
        } else if (option == StandardSocketOptions.TCP_NODELAY) {
            channelOpts.put(ChannelOption.TCP_NODELAY, value);
        } else if (option == ServiceTalkSocketOptions.CONNECT_TIMEOUT) {
            channelOpts.put(ChannelOption.CONNECT_TIMEOUT_MILLIS, value);
        } else if (option == ServiceTalkSocketOptions.WRITE_BUFFER_THRESHOLD) {
            int writeBufferThreshold = (Integer)value;
            channelOpts.put(ChannelOption.WRITE_BUFFER_WATER_MARK, new WriteBufferWaterMark(writeBufferThreshold >>> 1, writeBufferThreshold));
        } else {
            throw SocketOptionUtils.unsupported(option);
        }
    }

    @Nullable
    public static <T> T getOption(SocketOption<T> option, ChannelConfig config, @Nullable Long idleTimeoutMs) {
        if (option == StandardSocketOptions.IP_MULTICAST_IF) {
            return (T)config.getOption(ChannelOption.IP_MULTICAST_IF);
        }
        if (option == StandardSocketOptions.IP_MULTICAST_LOOP) {
            Boolean result = config.getOption(ChannelOption.IP_MULTICAST_LOOP_DISABLED);
            return (T)(result == null ? null : Boolean.valueOf(result == false));
        }
        if (option == StandardSocketOptions.IP_MULTICAST_TTL) {
            return (T)config.getOption(ChannelOption.IP_MULTICAST_TTL);
        }
        if (option == StandardSocketOptions.IP_TOS) {
            return (T)config.getOption(ChannelOption.IP_TOS);
        }
        if (option == StandardSocketOptions.SO_BROADCAST) {
            return (T)config.getOption(ChannelOption.SO_BROADCAST);
        }
        if (option == StandardSocketOptions.SO_KEEPALIVE) {
            return (T)config.getOption(ChannelOption.SO_KEEPALIVE);
        }
        if (option == StandardSocketOptions.SO_LINGER) {
            return (T)config.getOption(ChannelOption.SO_LINGER);
        }
        if (option == StandardSocketOptions.SO_RCVBUF) {
            return (T)config.getOption(ChannelOption.SO_RCVBUF);
        }
        if (option == StandardSocketOptions.SO_REUSEADDR) {
            return (T)config.getOption(ChannelOption.SO_REUSEADDR);
        }
        if (option == StandardSocketOptions.SO_SNDBUF) {
            return (T)config.getOption(ChannelOption.SO_SNDBUF);
        }
        if (option == StandardSocketOptions.TCP_NODELAY) {
            return (T)config.getOption(ChannelOption.TCP_NODELAY);
        }
        if (option == ServiceTalkSocketOptions.CONNECT_TIMEOUT) {
            return (T)config.getOption(ChannelOption.CONNECT_TIMEOUT_MILLIS);
        }
        if (option == ServiceTalkSocketOptions.WRITE_BUFFER_THRESHOLD) {
            WriteBufferWaterMark result = config.getOption(ChannelOption.WRITE_BUFFER_WATER_MARK);
            return (T)(result == null ? null : Integer.valueOf(result.high()));
        }
        if (option == ServiceTalkSocketOptions.IDLE_TIMEOUT) {
            return (T)idleTimeoutMs;
        }
        throw SocketOptionUtils.unsupported(option);
    }

    private static <T> IllegalArgumentException unsupported(SocketOption<T> option) {
        return new IllegalArgumentException("SocketOption(" + option.name() + ", " + option.type().getName() + ") is not supported");
    }
}

