/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.transport.netty.internal;

import io.servicetalk.transport.api.SecurityConfigurator;
import io.servicetalk.transport.api.ServerSecurityConfigurator;
import io.servicetalk.transport.netty.internal.ReadOnlyServerSecurityConfig;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Supplier;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;

public class ServerSecurityConfig
extends ReadOnlyServerSecurityConfig {
    public void trustManager(Supplier<InputStream> trustCertChainSupplier) {
        this.trustCertChainSupplier = Objects.requireNonNull(trustCertChainSupplier);
    }

    public void trustManager(TrustManagerFactory trustManagerFactory) {
        this.trustManagerFactory = Objects.requireNonNull(trustManagerFactory);
    }

    public void protocols(String ... protocols) {
        this.protocols = Arrays.asList(protocols);
    }

    public void ciphers(Iterable<String> ciphers) {
        this.ciphers = Objects.requireNonNull(ciphers);
    }

    public void sessionCacheSize(long sessionCacheSize) {
        this.sessionCacheSize = sessionCacheSize;
    }

    public void sessionTimeout(long sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    public void provider(SecurityConfigurator.SslProvider provider) {
        this.provider = Objects.requireNonNull(provider);
    }

    public void keyManager(KeyManagerFactory keyManagerFactory) {
        this.keyManagerFactory = Objects.requireNonNull(keyManagerFactory);
    }

    public void keyManager(Supplier<InputStream> keyCertChainSupplier, Supplier<InputStream> keySupplier) {
        this.keyCertChainSupplier = Objects.requireNonNull(keyCertChainSupplier);
        this.keySupplier = Objects.requireNonNull(keySupplier);
        this.keyPassword = null;
    }

    public void keyManager(Supplier<InputStream> keyCertChainSupplier, Supplier<InputStream> keySupplier, String keyPassword) {
        this.keyCertChainSupplier = Objects.requireNonNull(keyCertChainSupplier);
        this.keySupplier = Objects.requireNonNull(keySupplier);
        this.keyPassword = Objects.requireNonNull(keyPassword);
    }

    public void clientAuth(ServerSecurityConfigurator.ClientAuth clientAuth) {
        this.clientAuth = Objects.requireNonNull(clientAuth);
    }

    public ReadOnlyServerSecurityConfig asReadOnly() {
        return new ReadOnlyServerSecurityConfig(this);
    }
}

