/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.transport.netty.internal;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.BufferHolder;
import io.servicetalk.buffer.netty.BufferUtils;

@ChannelHandler.Sharable
public final class BufferHandler
extends ChannelDuplexHandler {
    public static final ChannelDuplexHandler INSTANCE = new BufferHandler();

    private BufferHandler() {
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof ByteBuf) {
            ctx.fireChannelRead(BufferUtils.newBufferFrom((ByteBuf)msg));
        } else if (msg instanceof ByteBufHolder) {
            ByteBufHolder holder = (ByteBufHolder)msg;
            ByteBuf byteBuf = holder.content();
            ctx.fireChannelRead(BufferUtils.newBufferFrom(byteBuf));
        } else {
            ctx.fireChannelRead(msg);
        }
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        if (msg instanceof Buffer) {
            ctx.write(BufferUtils.extractByteBufOrCreate((Buffer)msg), promise);
        } else if (msg instanceof BufferHolder) {
            ctx.write(BufferUtils.extractByteBufOrCreate(((BufferHolder)msg).content()), promise);
        } else {
            ctx.write(msg, promise);
        }
    }
}

