/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.tcp.netty.internal;

import io.netty.channel.ChannelOption;
import io.servicetalk.logging.api.LogLevel;
import io.servicetalk.logging.api.UserDataLoggerConfig;
import io.servicetalk.logging.slf4j.internal.DefaultUserDataLoggerConfig;
import io.servicetalk.transport.api.ServiceTalkSocketOptions;
import io.servicetalk.transport.netty.internal.FlushStrategies;
import io.servicetalk.transport.netty.internal.FlushStrategy;
import io.servicetalk.transport.netty.internal.SocketOptionUtils;
import java.net.SocketOption;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;

abstract class AbstractTcpConfig<SecurityConfig, ReadOnlyView> {
    @Nullable
    private Map<ChannelOption, Object> options;
    @Nullable
    private Long idleTimeoutMs;
    private FlushStrategy flushStrategy = FlushStrategies.defaultFlushStrategy();
    @Nullable
    private UserDataLoggerConfig wireLoggerConfig;
    @Nullable
    private SecurityConfig securityConfig;

    protected AbstractTcpConfig() {
    }

    protected AbstractTcpConfig(AbstractTcpConfig<SecurityConfig, ReadOnlyView> from) {
        this.options = from.options;
        this.idleTimeoutMs = from.idleTimeoutMs;
        this.flushStrategy = from.flushStrategy;
        this.wireLoggerConfig = from.wireLoggerConfig;
        this.securityConfig = from.securityConfig;
    }

    @Nullable
    final Map<ChannelOption, Object> options() {
        return this.options;
    }

    @Nullable
    final Long idleTimeoutMs() {
        return this.idleTimeoutMs;
    }

    final FlushStrategy flushStrategy() {
        return this.flushStrategy;
    }

    @Nullable
    final UserDataLoggerConfig wireLoggerConfig() {
        return this.wireLoggerConfig;
    }

    @Nullable
    final SecurityConfig securityConfig() {
        return this.securityConfig;
    }

    public final <T> void socketOption(SocketOption<T> option, T value) {
        Objects.requireNonNull(option);
        Objects.requireNonNull(value);
        if (option == ServiceTalkSocketOptions.IDLE_TIMEOUT) {
            this.idleTimeoutMs = (Long)value;
        } else {
            if (this.options == null) {
                this.options = new HashMap<ChannelOption, Object>();
            }
            SocketOptionUtils.addOption(this.options, option, value);
        }
    }

    public final void flushStrategy(FlushStrategy flushStrategy) {
        this.flushStrategy = Objects.requireNonNull(flushStrategy);
    }

    public final void enableWireLogging(String loggerName) {
        this.enableWireLogging(loggerName, LogLevel.TRACE, () -> false);
    }

    public final void enableWireLogging(String loggerName, LogLevel logLevel, BooleanSupplier logUserData) {
        this.wireLoggerConfig = new DefaultUserDataLoggerConfig(loggerName, logLevel, logUserData);
    }

    public final void secure(SecurityConfig securityConfig) {
        this.securityConfig = Objects.requireNonNull(securityConfig);
    }

    public abstract ReadOnlyView asReadOnly(List<String> var1);
}

