/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.netty.channel.Channel;
import io.servicetalk.buffer.netty.BufferUtils;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.http.api.HttpExecutionContext;
import io.servicetalk.http.api.HttpProtocolVersion;
import io.servicetalk.http.netty.HeaderUtils;
import io.servicetalk.http.netty.HttpClientChannelInitializer;
import io.servicetalk.http.netty.HttpDebugUtils;
import io.servicetalk.http.netty.ReadOnlyHttpClientConfig;
import io.servicetalk.tcp.netty.internal.TcpClientChannelInitializer;
import io.servicetalk.tcp.netty.internal.TcpConnector;
import io.servicetalk.transport.api.ConnectionObserver;
import io.servicetalk.transport.api.TransportObserver;
import io.servicetalk.transport.netty.internal.ChannelInitializer;
import io.servicetalk.transport.netty.internal.CloseHandler;
import io.servicetalk.transport.netty.internal.DefaultNettyConnection;
import io.servicetalk.transport.netty.internal.NettyConnection;

final class StreamingConnectionFactory {
    private StreamingConnectionFactory() {
    }

    static <ResolvedAddress> Single<? extends NettyConnection<Object, Object>> buildStreaming(HttpExecutionContext executionContext, ResolvedAddress resolvedAddress, ReadOnlyHttpClientConfig roConfig, TransportObserver observer) {
        return TcpConnector.connect(null, resolvedAddress, roConfig.tcpConfig(), false, executionContext, (channel, connectionObserver) -> StreamingConnectionFactory.createConnection(channel, executionContext, roConfig, new TcpClientChannelInitializer(roConfig.tcpConfig(), (ConnectionObserver)connectionObserver, roConfig.hasProxy()), connectionObserver), observer);
    }

    static Single<? extends DefaultNettyConnection<Object, Object>> createConnection(Channel channel, HttpExecutionContext executionContext, ReadOnlyHttpClientConfig config, ChannelInitializer initializer, ConnectionObserver connectionObserver) {
        CloseHandler closeHandler = CloseHandler.forPipelinedRequestResponse(true, channel.config());
        assert (config.h1Config() != null);
        return HttpDebugUtils.showPipeline(DefaultNettyConnection.initChannel(channel, executionContext.bufferAllocator(), executionContext.executor(), HeaderUtils.LAST_CHUNK_PREDICATE, closeHandler, config.tcpConfig().flushStrategy(), config.tcpConfig().idleTimeoutMs(), initializer.andThen(new HttpClientChannelInitializer(BufferUtils.getByteBufAllocator(executionContext.bufferAllocator()), config.h1Config(), closeHandler)), executionContext.executionStrategy(), HttpProtocolVersion.HTTP_1_1, connectionObserver, true), HttpProtocolVersion.HTTP_1_1, channel);
    }
}

