/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.Http2Flags;
import io.netty.handler.codec.http2.Http2FrameLogger;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Settings;
import io.servicetalk.logging.api.LogLevel;
import io.servicetalk.logging.slf4j.internal.FixedLevelLogger;
import java.util.function.BooleanSupplier;

final class ServiceTalkHttp2FrameLogger
extends Http2FrameLogger {
    private static final int BUFFER_LENGTH_THRESHOLD = 64;
    private final FixedLevelLogger logger;
    private final BooleanSupplier logUserDataSupplier;

    ServiceTalkHttp2FrameLogger(FixedLevelLogger logger, BooleanSupplier logUserDataSupplier) {
        super(io.netty.handler.logging.LogLevel.ERROR);
        this.logger = logger;
        this.logUserDataSupplier = logUserDataSupplier;
    }

    @Override
    public boolean isEnabled() {
        return this.logger.isEnabled();
    }

    @Override
    public void logData(Http2FrameLogger.Direction direction, ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endStream) {
        if (this.logger.isEnabled()) {
            if (this.logUserDataSupplier.getAsBoolean()) {
                this.logger.log("{} {} DATA: streamId={} padding={} endStream={} length={} bytes={}", ctx.channel(), direction.name(), streamId, padding, endStream, data.readableBytes(), this.toString(data));
            } else {
                this.logger.log("{} {} DATA: streamId={} padding={} endStream={} length={}", ctx.channel(), direction.name(), streamId, padding, endStream, data.readableBytes());
            }
        }
    }

    @Override
    public void logHeaders(Http2FrameLogger.Direction direction, ChannelHandlerContext ctx, int streamId, Http2Headers headers, int padding, boolean endStream) {
        if (this.logger.isEnabled()) {
            this.logger.log("{} {} HEADERS: streamId={} headers={} padding={} endStream={}", ctx.channel(), direction.name(), streamId, this.toString(headers), padding, endStream);
        }
    }

    @Override
    public void logHeaders(Http2FrameLogger.Direction direction, ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endStream) {
        if (this.logger.isEnabled()) {
            this.logger.log("{} {} HEADERS: streamId={} headers={} streamDependency={} weight={} exclusive={} padding={} endStream={}", ctx.channel(), direction.name(), streamId, this.toString(headers), streamDependency, weight, exclusive, padding, endStream);
        }
    }

    @Override
    public void logPriority(Http2FrameLogger.Direction direction, ChannelHandlerContext ctx, int streamId, int streamDependency, short weight, boolean exclusive) {
        if (this.logger.isEnabled()) {
            this.logger.log("{} {} PRIORITY: streamId={} streamDependency={} weight={} exclusive={}", ctx.channel(), direction.name(), streamId, streamDependency, weight, exclusive);
        }
    }

    @Override
    public void logRstStream(Http2FrameLogger.Direction direction, ChannelHandlerContext ctx, int streamId, long errorCode) {
        if (this.logger.isEnabled()) {
            this.logger.log("{} {} RST_STREAM: streamId={} errorCode={}", ctx.channel(), direction.name(), streamId, errorCode);
        }
    }

    @Override
    public void logSettingsAck(Http2FrameLogger.Direction direction, ChannelHandlerContext ctx) {
        if (this.logger.isEnabled()) {
            this.logger.log("{} {} SETTINGS: ack=true", (Object)ctx.channel(), (Object)direction.name());
        }
    }

    @Override
    public void logSettings(Http2FrameLogger.Direction direction, ChannelHandlerContext ctx, Http2Settings settings) {
        if (this.logger.isEnabled()) {
            this.logger.log("{} {} SETTINGS: ack=false settings={}", ctx.channel(), direction.name(), settings.toString());
        }
    }

    @Override
    public void logPing(Http2FrameLogger.Direction direction, ChannelHandlerContext ctx, long data) {
        if (this.logger.isEnabled()) {
            this.logger.log("{} {} PING: ack=false bytes={}", ctx.channel(), direction.name(), data);
        }
    }

    @Override
    public void logPingAck(Http2FrameLogger.Direction direction, ChannelHandlerContext ctx, long data) {
        if (this.logger.isEnabled()) {
            this.logger.log("{} {} PING: ack=true bytes={}", ctx.channel(), direction.name(), data);
        }
    }

    @Override
    public void logPushPromise(Http2FrameLogger.Direction direction, ChannelHandlerContext ctx, int streamId, int promisedStreamId, Http2Headers headers, int padding) {
        if (this.logger.isEnabled()) {
            this.logger.log("{} {} PUSH_PROMISE: streamId={} promisedStreamId={} headers={} padding={}", ctx.channel(), direction.name(), streamId, promisedStreamId, this.toString(headers), padding);
        }
    }

    @Override
    public void logGoAway(Http2FrameLogger.Direction direction, ChannelHandlerContext ctx, int lastStreamId, long errorCode, ByteBuf debugData) {
        if (this.logger.isEnabled()) {
            if (this.logUserDataSupplier.getAsBoolean()) {
                this.logger.log("{} {} GO_AWAY: lastStreamId={} errorCode={} length={} bytes={}", ctx.channel(), direction.name(), lastStreamId, errorCode, debugData.readableBytes(), this.toString(debugData));
            } else {
                this.logger.log("{} {} GO_AWAY: lastStreamId={} errorCode={} length={}", ctx.channel(), direction.name(), lastStreamId, errorCode, debugData.readableBytes());
            }
        }
    }

    @Override
    public void logWindowsUpdate(Http2FrameLogger.Direction direction, ChannelHandlerContext ctx, int streamId, int windowSizeIncrement) {
        if (this.logger.isEnabled()) {
            this.logger.log("{} {} WINDOW_UPDATE: streamId={} windowSizeIncrement={}", ctx.channel(), direction.name(), streamId, windowSizeIncrement);
        }
    }

    @Override
    public void logUnknownFrame(Http2FrameLogger.Direction direction, ChannelHandlerContext ctx, byte frameType, int streamId, Http2Flags flags, ByteBuf data) {
        if (this.logger.isEnabled()) {
            if (this.logUserDataSupplier.getAsBoolean()) {
                this.logger.log("{} {} UNKNOWN: frameType={} streamId={} flags={} length={} bytes={}", ctx.channel(), direction.name(), frameType & 0xFF, streamId, flags.value(), data.readableBytes(), this.toString(data));
            } else {
                this.logger.log("{} {} UNKNOWN: frameType={} streamId={} flags={} length={}", ctx.channel(), direction.name(), frameType & 0xFF, streamId, flags.value(), data.readableBytes());
            }
        }
    }

    private String toString(Http2Headers headers) {
        return this.logUserDataSupplier.getAsBoolean() ? headers.toString() : String.valueOf(headers.size());
    }

    private String toString(ByteBuf buf) {
        if (this.logger.logLevel() == LogLevel.TRACE || buf.readableBytes() <= 64) {
            return ByteBufUtil.hexDump(buf);
        }
        return ByteBufUtil.hexDump(buf, buf.readerIndex(), 64) + "...";
    }
}

