/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.servicetalk.client.api.internal.RequestConcurrencyController;
import io.servicetalk.client.api.internal.ReservableRequestConcurrencyController;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.http.api.FilterableStreamingHttpLoadBalancedConnection;
import io.servicetalk.http.api.HttpApiConversions;
import io.servicetalk.http.api.HttpConnectionContext;
import io.servicetalk.http.api.HttpEventKey;
import io.servicetalk.http.api.HttpExecutionContext;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpExecutionStrategyInfluencer;
import io.servicetalk.http.api.HttpRequestMethod;
import io.servicetalk.http.api.ReservedBlockingHttpConnection;
import io.servicetalk.http.api.ReservedBlockingStreamingHttpConnection;
import io.servicetalk.http.api.ReservedHttpConnection;
import io.servicetalk.http.api.ReservedStreamingHttpConnection;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.api.StreamingHttpResponseFactory;
import java.util.Objects;

final class LoadBalancedStreamingHttpConnection
implements FilterableStreamingHttpLoadBalancedConnection,
ReservedStreamingHttpConnection,
ReservableRequestConcurrencyController,
HttpExecutionStrategyInfluencer {
    private final ReservableRequestConcurrencyController limiter;
    private final FilterableStreamingHttpLoadBalancedConnection filteredConnection;
    private final HttpExecutionStrategy streamingStrategy;
    private final HttpExecutionStrategyInfluencer strategyInfluencer;

    LoadBalancedStreamingHttpConnection(FilterableStreamingHttpLoadBalancedConnection filteredConnection, ReservableRequestConcurrencyController limiter, HttpExecutionStrategy streamingStrategy, HttpExecutionStrategyInfluencer strategyInfluencer) {
        this.filteredConnection = filteredConnection;
        this.limiter = Objects.requireNonNull(limiter);
        this.streamingStrategy = streamingStrategy;
        this.strategyInfluencer = strategyInfluencer;
    }

    @Override
    public boolean tryReserve() {
        return this.limiter.tryReserve();
    }

    @Override
    public RequestConcurrencyController.Result tryRequest() {
        return this.limiter.tryRequest();
    }

    @Override
    public void requestFinished() {
        this.limiter.requestFinished();
    }

    @Override
    public Completable releaseAsync() {
        return this.limiter.releaseAsync();
    }

    @Override
    public Single<StreamingHttpResponse> request(StreamingHttpRequest request) {
        return this.filteredConnection.request(this.streamingStrategy, request);
    }

    @Override
    public HttpConnectionContext connectionContext() {
        return this.filteredConnection.connectionContext();
    }

    @Override
    public <T> Publisher<? extends T> transportEventStream(HttpEventKey<T> eventKey) {
        return this.filteredConnection.transportEventStream(eventKey);
    }

    @Override
    public Single<StreamingHttpResponse> request(HttpExecutionStrategy strategy, StreamingHttpRequest request) {
        return this.filteredConnection.request(strategy, request);
    }

    @Override
    public HttpExecutionContext executionContext() {
        return this.filteredConnection.executionContext();
    }

    @Override
    public StreamingHttpResponseFactory httpResponseFactory() {
        return this.filteredConnection.httpResponseFactory();
    }

    @Override
    public Completable onClose() {
        return this.filteredConnection.onClose();
    }

    @Override
    public Completable closeAsync() {
        return this.filteredConnection.closeAsync();
    }

    @Override
    public Completable closeAsyncGracefully() {
        return this.filteredConnection.closeAsyncGracefully();
    }

    @Override
    public StreamingHttpRequest newRequest(HttpRequestMethod method, String requestTarget) {
        return this.filteredConnection.newRequest(method, requestTarget);
    }

    @Override
    public ReservedHttpConnection asConnection() {
        return HttpApiConversions.toReservedConnection(this, this.strategyInfluencer);
    }

    @Override
    public ReservedBlockingStreamingHttpConnection asBlockingStreamingConnection() {
        return HttpApiConversions.toReservedBlockingStreamingConnection(this, this.strategyInfluencer);
    }

    @Override
    public ReservedBlockingHttpConnection asBlockingConnection() {
        return HttpApiConversions.toReservedBlockingConnection(this, this.strategyInfluencer);
    }

    @Override
    public HttpExecutionStrategy influenceStrategy(HttpExecutionStrategy strategy) {
        return this.strategyInfluencer.influenceStrategy(strategy);
    }

    @Override
    public int score() {
        return this.filteredConnection.score();
    }
}

