/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.servicetalk.client.api.LoadBalancer;
import io.servicetalk.client.api.internal.RequestConcurrencyController;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.api.TerminalSignalConsumer;
import io.servicetalk.http.api.FilterableStreamingHttpClient;
import io.servicetalk.http.api.HttpExecutionContext;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpRequestMetaData;
import io.servicetalk.http.api.HttpRequestMethod;
import io.servicetalk.http.api.ReservedStreamingHttpConnection;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpRequestResponseFactory;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.api.StreamingHttpResponseFactory;
import io.servicetalk.http.netty.LoadBalancedStreamingHttpConnection;
import io.servicetalk.http.utils.BeforeFinallyHttpOperator;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;

final class LoadBalancedStreamingHttpClient
implements FilterableStreamingHttpClient {
    private static final Predicate<LoadBalancedStreamingHttpConnection> SELECTOR_FOR_REQUEST = conn -> conn.tryRequest() == RequestConcurrencyController.Result.Accepted;
    private static final Predicate<LoadBalancedStreamingHttpConnection> SELECTOR_FOR_RESERVE = LoadBalancedStreamingHttpConnection::tryReserve;
    private final HttpExecutionContext executionContext;
    private final LoadBalancer<LoadBalancedStreamingHttpConnection> loadBalancer;
    private final StreamingHttpRequestResponseFactory reqRespFactory;

    LoadBalancedStreamingHttpClient(HttpExecutionContext executionContext, LoadBalancer<LoadBalancedStreamingHttpConnection> loadBalancer, StreamingHttpRequestResponseFactory reqRespFactory) {
        this.executionContext = Objects.requireNonNull(executionContext);
        this.loadBalancer = Objects.requireNonNull(loadBalancer);
        this.reqRespFactory = Objects.requireNonNull(reqRespFactory);
    }

    @Override
    public Single<StreamingHttpResponse> request(HttpExecutionStrategy strategy, StreamingHttpRequest request) {
        return this.loadBalancer.selectConnection(SELECTOR_FOR_REQUEST).flatMap(c -> c.request(strategy, request).liftSync(new BeforeFinallyHttpOperator(new TerminalSignalConsumer((LoadBalancedStreamingHttpConnection)c){
            final /* synthetic */ LoadBalancedStreamingHttpConnection val$c;
            {
                this.val$c = loadBalancedStreamingHttpConnection;
            }

            @Override
            public void onComplete() {
                this.val$c.requestFinished();
            }

            @Override
            public void onError(Throwable throwable) {
                this.val$c.requestFinished();
            }

            @Override
            public void cancel() {
                if (this.val$c.connectionContext().protocol().major() <= 1) {
                    this.val$c.closeAsync().subscribe();
                } else {
                    this.val$c.requestFinished();
                }
            }
        })).subscribeShareContext());
    }

    public Single<ReservedStreamingHttpConnection> reserveConnection(HttpExecutionStrategy strategy, HttpRequestMetaData metaData) {
        return strategy.offloadReceive(this.executionContext.executor(), this.loadBalancer.selectConnection(SELECTOR_FOR_RESERVE).map(Function.identity()));
    }

    @Override
    public HttpExecutionContext executionContext() {
        return this.executionContext;
    }

    @Override
    public StreamingHttpResponseFactory httpResponseFactory() {
        return this.reqRespFactory;
    }

    @Override
    public Completable onClose() {
        return this.loadBalancer.onClose();
    }

    @Override
    public Completable closeAsync() {
        return this.loadBalancer.closeAsync();
    }

    @Override
    public Completable closeAsyncGracefully() {
        return this.loadBalancer.closeAsyncGracefully();
    }

    @Override
    public StreamingHttpRequest newRequest(HttpRequestMethod method, String requestTarget) {
        return this.reqRespFactory.newRequest(method, requestTarget);
    }
}

