/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.servicetalk.http.netty.HttpConfig;
import io.servicetalk.http.netty.ReadOnlyHttpClientConfig;
import io.servicetalk.tcp.netty.internal.TcpClientConfig;
import javax.annotation.Nullable;

final class HttpClientConfig {
    private final TcpClientConfig tcpConfig;
    private final HttpConfig protocolConfigs;
    @Nullable
    private CharSequence connectAddress;

    HttpClientConfig() {
        this.tcpConfig = new TcpClientConfig();
        this.protocolConfigs = new HttpConfig();
    }

    HttpClientConfig(HttpClientConfig from) {
        this.tcpConfig = new TcpClientConfig(from.tcpConfig());
        this.protocolConfigs = new HttpConfig(from.protocolConfigs());
        this.connectAddress = from.connectAddress;
    }

    TcpClientConfig tcpConfig() {
        return this.tcpConfig;
    }

    HttpConfig protocolConfigs() {
        return this.protocolConfigs;
    }

    boolean isH2PriorKnowledge() {
        return this.protocolConfigs.h2Config() != null && this.protocolConfigs.h1Config() == null;
    }

    @Nullable
    CharSequence connectAddress() {
        return this.connectAddress;
    }

    void connectAddress(@Nullable CharSequence connectAddress) {
        this.connectAddress = connectAddress;
    }

    ReadOnlyHttpClientConfig asReadOnly() {
        ReadOnlyHttpClientConfig roConfig = new ReadOnlyHttpClientConfig(this);
        if (roConfig.tcpConfig().sslContext() == null && roConfig.h1Config() != null && roConfig.h2Config() != null) {
            throw new IllegalStateException("Cleartext HTTP/1.1 -> HTTP/2 (h2c) upgrade is not supported");
        }
        return roConfig;
    }
}

