/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2FrameStream;
import io.netty.handler.codec.http2.Http2FrameStreamException;
import io.netty.handler.codec.http2.Http2NoMoreStreamIdsException;
import io.netty.handler.codec.http2.Http2ResetFrame;
import io.servicetalk.transport.api.RetryableException;
import java.io.IOException;

class Http2Exception
extends IOException {
    private static final long serialVersionUID = 745695232431963628L;

    Http2Exception(String message) {
        super(message);
    }

    Http2Exception(Throwable cause) {
        super(cause);
    }

    static Throwable wrapIfNecessary(Throwable cause) {
        if (cause instanceof io.netty.handler.codec.http2.Http2Exception) {
            io.netty.handler.codec.http2.Http2Exception h2Cause = (io.netty.handler.codec.http2.Http2Exception)cause;
            return Http2Exception.isRetryable(h2Cause) ? new RetryableStacklessHttp2Exception(h2Cause) : new StacklessHttp2Exception(h2Cause);
        }
        if (cause instanceof Http2FrameStreamException) {
            return new StacklessHttp2Exception((Http2FrameStreamException)cause);
        }
        return cause;
    }

    private static boolean isRetryable(io.netty.handler.codec.http2.Http2Exception cause) {
        return cause.error() == Http2Error.REFUSED_STREAM || cause instanceof Http2NoMoreStreamIdsException;
    }

    static H2StreamResetException newStreamResetException(Http2ResetFrame resetFrame) {
        Http2FrameStream stream = resetFrame.stream();
        assert (stream != null);
        if (resetFrame.errorCode() == Http2Error.REFUSED_STREAM.code()) {
            return new H2StreamRefusedException("RST_STREAM received for streamId=" + stream.id() + ", stream refused");
        }
        return new H2StreamResetException("RST_STREAM received for streamId=" + stream.id() + " with error code: " + resetFrame.errorCode());
    }

    static class H2StreamResetException
    extends Http2Exception {
        private static final long serialVersionUID = -2000223857660046560L;

        H2StreamResetException(String message) {
            super(message);
        }
    }

    private static final class H2StreamRefusedException
    extends H2StreamResetException
    implements RetryableException {
        private static final long serialVersionUID = 615309480184187428L;

        H2StreamRefusedException(String message) {
            super(message);
        }
    }

    private static final class RetryableStacklessHttp2Exception
    extends Http2Exception
    implements RetryableException {
        private static final long serialVersionUID = -5874594718640129904L;

        RetryableStacklessHttp2Exception(io.netty.handler.codec.http2.Http2Exception cause) {
            super(cause);
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }

    private static final class StacklessHttp2Exception
    extends Http2Exception {
        private static final long serialVersionUID = 7794465950455688900L;

        StacklessHttp2Exception(io.netty.handler.codec.http2.Http2Exception cause) {
            super(cause);
        }

        StacklessHttp2Exception(Http2FrameStreamException cause) {
            super(cause);
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }
}

