/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.servicetalk.client.api.ConnectionFactory;
import io.servicetalk.client.api.ConnectionFactoryFilter;
import io.servicetalk.client.api.internal.ReservableRequestConcurrencyController;
import io.servicetalk.concurrent.api.AsyncCloseables;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.ListenableAsyncCloseable;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.http.api.FilterableStreamingHttpConnection;
import io.servicetalk.http.api.FilterableStreamingHttpLoadBalancedConnection;
import io.servicetalk.http.api.HttpConnectionContext;
import io.servicetalk.http.api.HttpExecutionContext;
import io.servicetalk.http.api.HttpExecutionStrategyInfluencer;
import io.servicetalk.http.api.HttpProtocolVersion;
import io.servicetalk.http.api.StreamingHttpConnectionFilterFactory;
import io.servicetalk.http.api.StreamingHttpRequestResponseFactory;
import io.servicetalk.http.netty.LoadBalancedStreamingHttpConnection;
import io.servicetalk.http.netty.ReadOnlyHttpClientConfig;
import io.servicetalk.transport.api.TransportObserver;
import io.servicetalk.transport.api.TransportObservers;
import io.servicetalk.transport.netty.internal.NettyConnectionContext;
import io.servicetalk.transport.netty.internal.NoopTransportObserver;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

abstract class AbstractLBHttpConnectionFactory<ResolvedAddress>
implements ConnectionFactory<ResolvedAddress, LoadBalancedStreamingHttpConnection> {
    private final ListenableAsyncCloseable close = AsyncCloseables.emptyAsyncCloseable();
    @Nullable
    final StreamingHttpConnectionFilterFactory connectionFilterFunction;
    final ReadOnlyHttpClientConfig config;
    final HttpExecutionContext executionContext;
    final Function<HttpProtocolVersion, StreamingHttpRequestResponseFactory> reqRespFactoryFunc;
    final HttpExecutionStrategyInfluencer strategyInfluencer;
    final ConnectionFactory<ResolvedAddress, FilterableStreamingHttpConnection> filterableConnectionFactory;
    private final Function<FilterableStreamingHttpConnection, FilterableStreamingHttpLoadBalancedConnection> protocolBinding;

    AbstractLBHttpConnectionFactory(ReadOnlyHttpClientConfig config, HttpExecutionContext executionContext, @Nullable StreamingHttpConnectionFilterFactory connectionFilterFunction, Function<HttpProtocolVersion, StreamingHttpRequestResponseFactory> reqRespFactoryFunc, HttpExecutionStrategyInfluencer strategyInfluencer, ConnectionFactoryFilter<ResolvedAddress, FilterableStreamingHttpConnection> connectionFactoryFilter, Function<FilterableStreamingHttpConnection, FilterableStreamingHttpLoadBalancedConnection> protocolBinding) {
        this.connectionFilterFunction = connectionFilterFunction;
        this.config = Objects.requireNonNull(config);
        this.executionContext = Objects.requireNonNull(executionContext);
        this.reqRespFactoryFunc = Objects.requireNonNull(reqRespFactoryFunc);
        this.strategyInfluencer = strategyInfluencer;
        this.filterableConnectionFactory = connectionFactoryFilter.create(new ConnectionFactory<ResolvedAddress, FilterableStreamingHttpConnection>(){

            @Override
            public Single<FilterableStreamingHttpConnection> newConnection(ResolvedAddress ra, @Nullable TransportObserver observer) {
                return AbstractLBHttpConnectionFactory.this.newFilterableConnection(ra, observer == null ? NoopTransportObserver.INSTANCE : TransportObservers.asSafeObserver(observer));
            }

            @Override
            public Completable onClose() {
                return AbstractLBHttpConnectionFactory.this.close.onClose();
            }

            @Override
            public Completable closeAsync() {
                return AbstractLBHttpConnectionFactory.this.close.closeAsync();
            }

            @Override
            public Completable closeAsyncGracefully() {
                return AbstractLBHttpConnectionFactory.this.close.closeAsyncGracefully();
            }
        });
        this.protocolBinding = protocolBinding;
    }

    @Override
    public final Single<LoadBalancedStreamingHttpConnection> newConnection(ResolvedAddress resolvedAddress, @Nullable TransportObserver observer) {
        return this.filterableConnectionFactory.newConnection(resolvedAddress, observer).map(conn -> {
            FilterableStreamingHttpConnection filteredConnection = this.connectionFilterFunction != null ? this.connectionFilterFunction.create((FilterableStreamingHttpConnection)conn) : conn;
            HttpConnectionContext ctx = filteredConnection.connectionContext();
            Completable onClosing = ctx instanceof NettyConnectionContext ? ((NettyConnectionContext)((Object)ctx)).onClosing() : filteredConnection.onClose();
            return new LoadBalancedStreamingHttpConnection(this.protocolBinding.apply(filteredConnection), this.newConcurrencyController(filteredConnection, onClosing), this.executionContext.executionStrategy(), this.strategyInfluencer);
        });
    }

    abstract Single<FilterableStreamingHttpConnection> newFilterableConnection(ResolvedAddress var1, TransportObserver var2);

    abstract ReservableRequestConcurrencyController newConcurrencyController(FilterableStreamingHttpConnection var1, Completable var2);

    @Override
    public final Completable onClose() {
        return this.filterableConnectionFactory.onClose();
    }

    @Override
    public final Completable closeAsync() {
        return this.filterableConnectionFactory.closeAsync();
    }

    @Override
    public final Completable closeAsyncGracefully() {
        return this.filterableConnectionFactory.closeAsyncGracefully();
    }
}

