/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.internal;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public final class ConcurrentUtils {
    private static final long REENTRANT_LOCK_ZERO_THREAD_ID = 0L;
    private static final int CONCURRENT_IDLE = 0;
    private static final int CONCURRENT_EMITTING = 1;
    private static final int CONCURRENT_PENDING = 2;

    private ConcurrentUtils() {
    }

    public static <T> boolean tryAcquireLock(AtomicIntegerFieldUpdater<T> lockUpdater, T owner) {
        while (true) {
            int prevEmitting;
            if ((prevEmitting = lockUpdater.get(owner)) == 0) {
                if (!lockUpdater.compareAndSet(owner, 0, 1)) continue;
                return true;
            }
            if (lockUpdater.compareAndSet(owner, prevEmitting, 2)) break;
        }
        return false;
    }

    public static <T> boolean releaseLock(AtomicIntegerFieldUpdater<T> lockUpdater, T owner) {
        return lockUpdater.getAndSet(owner, 0) == 1;
    }

    public static <T> long tryAcquireReentrantLock(AtomicLongFieldUpdater<T> lockUpdater, T owner) {
        long threadId = Thread.currentThread().getId();
        while (true) {
            long prevThreadId;
            if ((prevThreadId = lockUpdater.get(owner)) == 0L) {
                if (!lockUpdater.compareAndSet(owner, 0L, threadId)) continue;
                return threadId;
            }
            if (prevThreadId == threadId || prevThreadId == -threadId) {
                return -threadId;
            }
            if (lockUpdater.compareAndSet(owner, prevThreadId, prevThreadId > 0L ? -prevThreadId : prevThreadId)) break;
        }
        return 0L;
    }

    public static <T> boolean releaseReentrantLock(AtomicLongFieldUpdater<T> lockUpdater, long acquireId, T owner) {
        assert (acquireId != 0L);
        return acquireId < 0L || lockUpdater.getAndSet(owner, 0L) == acquireId;
    }
}

