/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.internal;

import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.internal.ConcurrentUtils;
import io.servicetalk.concurrent.internal.FlowControlUtils;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public class ConcurrentSubscription
implements PublisherSource.Subscription {
    private static final AtomicLongFieldUpdater<ConcurrentSubscription> pendingDemandUpdater = AtomicLongFieldUpdater.newUpdater(ConcurrentSubscription.class, "pendingDemand");
    private static final AtomicLongFieldUpdater<ConcurrentSubscription> subscriptionLockUpdater = AtomicLongFieldUpdater.newUpdater(ConcurrentSubscription.class, "subscriptionLock");
    private static final long CANCELLED = Long.MIN_VALUE;
    private final PublisherSource.Subscription subscription;
    private volatile long pendingDemand;
    private volatile long subscriptionLock;

    protected ConcurrentSubscription(PublisherSource.Subscription subscription) {
        this.subscription = Objects.requireNonNull(subscription);
    }

    public static ConcurrentSubscription wrap(PublisherSource.Subscription subscription) {
        return subscription instanceof ConcurrentSubscription ? (ConcurrentSubscription)subscription : new ConcurrentSubscription(subscription);
    }

    @Override
    public void request(long n) {
        long acquireId = ConcurrentUtils.tryAcquireReentrantLock(subscriptionLockUpdater, this);
        if (acquireId != 0L) {
            this.subscription.request(n);
            if (!ConcurrentUtils.releaseReentrantLock(subscriptionLockUpdater, acquireId, this)) {
                this.drainPending();
            }
        } else {
            this.addPending(n);
            this.drainPending();
        }
    }

    @Override
    public void cancel() {
        this.pendingDemand = Long.MIN_VALUE;
        if (ConcurrentUtils.tryAcquireReentrantLock(subscriptionLockUpdater, this) != 0L) {
            this.subscription.cancel();
        }
    }

    private void addPending(long n) {
        if (!SubscriberUtils.isRequestNValid(n)) {
            this.pendingDemand = ConcurrentSubscription.mapInvalidRequestN(n);
        } else {
            pendingDemandUpdater.accumulateAndGet(this, n, FlowControlUtils::addWithOverflowProtectionIfNotNegative);
        }
    }

    private void drainPending() {
        long acquireId;
        while ((acquireId = ConcurrentUtils.tryAcquireReentrantLock(subscriptionLockUpdater, this)) != 0L) {
            long prevPendingDemand = pendingDemandUpdater.getAndSet(this, 0L);
            if (prevPendingDemand == Long.MIN_VALUE) {
                this.subscription.cancel();
            } else if (prevPendingDemand != 0L) {
                this.subscription.request(prevPendingDemand);
            }
            if (!ConcurrentUtils.releaseReentrantLock(subscriptionLockUpdater, acquireId, this)) continue;
        }
    }

    private static long mapInvalidRequestN(long n) {
        return n == Long.MIN_VALUE ? -9223372036854775807L : (n == 0L ? -1L : n);
    }
}

