/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api.internal;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.Executor;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.internal.SignalOffloader;
import io.servicetalk.concurrent.internal.SignalOffloaderFactory;
import io.servicetalk.concurrent.internal.SignalOffloaders;
import java.util.Objects;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;

public final class OffloaderAwareExecutor
implements io.servicetalk.concurrent.api.Executor,
SignalOffloaderFactory {
    private final io.servicetalk.concurrent.api.Executor delegate;
    private final SignalOffloaderFactory offloaderFactory;

    public OffloaderAwareExecutor(io.servicetalk.concurrent.api.Executor delegate, SignalOffloaderFactory offloaderFactory) {
        this.delegate = Objects.requireNonNull(delegate);
        this.offloaderFactory = Objects.requireNonNull(offloaderFactory);
    }

    @Override
    public Cancellable execute(Runnable task) throws RejectedExecutionException {
        return this.delegate.execute(task);
    }

    @Override
    public Cancellable schedule(Runnable task, long delay, TimeUnit unit) throws RejectedExecutionException {
        return this.delegate.schedule(task, delay, unit);
    }

    @Override
    public Completable onClose() {
        return this.delegate.onClose();
    }

    @Override
    public Completable closeAsync() {
        return this.delegate.closeAsync();
    }

    @Override
    public SignalOffloader newSignalOffloader(Executor executor) {
        return this.offloaderFactory.newSignalOffloader(executor);
    }

    @Override
    public boolean hasThreadAffinity() {
        return this.offloaderFactory.hasThreadAffinity();
    }

    public static io.servicetalk.concurrent.api.Executor ensureThreadAffinity(io.servicetalk.concurrent.api.Executor executor) {
        if (SignalOffloaders.hasThreadAffinity(executor)) {
            return executor;
        }
        return new OffloaderAwareExecutor(executor, new SignalOffloaderFactory(){

            @Override
            public SignalOffloader newSignalOffloader(Executor executor) {
                return SignalOffloaders.newThreadBasedOffloader(executor);
            }

            @Override
            public boolean hasThreadAffinity() {
                return true;
            }
        });
    }
}

