/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.AbstractNoHandleSubscribePublisher;
import io.servicetalk.concurrent.api.AsyncContextMap;
import io.servicetalk.concurrent.api.AsyncContextProvider;
import io.servicetalk.concurrent.api.DelayedCancellableThenSubscription;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.internal.SignalOffloader;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

final class SingleFlatMapPublisher<T, R>
extends AbstractNoHandleSubscribePublisher<R> {
    private final Single<T> original;
    private final Function<? super T, ? extends Publisher<? extends R>> nextFactory;

    SingleFlatMapPublisher(Single<T> original, Function<? super T, ? extends Publisher<? extends R>> nextFactory, Executor executor) {
        super(executor);
        this.original = Objects.requireNonNull(original);
        this.nextFactory = Objects.requireNonNull(nextFactory);
    }

    @Override
    void handleSubscribe(PublisherSource.Subscriber<? super R> subscriber, SignalOffloader signalOffloader, AsyncContextMap contextMap, AsyncContextProvider contextProvider) {
        this.original.delegateSubscribe(new SubscriberImpl<T, R>(subscriber, this.nextFactory, signalOffloader, contextMap, contextProvider), signalOffloader, contextMap, contextProvider);
    }

    private static final class SubscriberImpl<T, R>
    extends DelayedCancellableThenSubscription
    implements SingleSource.Subscriber<T>,
    PublisherSource.Subscriber<R> {
        private final PublisherSource.Subscriber<? super R> subscriber;
        private final Function<? super T, ? extends Publisher<? extends R>> nextFactory;
        private final SignalOffloader signalOffloader;
        private final AsyncContextMap contextMap;
        private final AsyncContextProvider contextProvider;

        SubscriberImpl(PublisherSource.Subscriber<? super R> subscriber, Function<? super T, ? extends Publisher<? extends R>> nextFactory, SignalOffloader signalOffloader, AsyncContextMap contextMap, AsyncContextProvider contextProvider) {
            this.subscriber = subscriber;
            this.nextFactory = Objects.requireNonNull(nextFactory);
            this.signalOffloader = signalOffloader;
            this.contextMap = contextMap;
            this.contextProvider = contextProvider;
        }

        @Override
        public void onSubscribe(Cancellable cancellable) {
            this.delayedCancellable(cancellable);
            this.subscriber.onSubscribe(this);
        }

        @Override
        public void onSubscribe(PublisherSource.Subscription s) {
            this.delayedSubscription(s);
        }

        @Override
        public void onSuccess(@Nullable T result) {
            Publisher<R> next;
            try {
                next = Objects.requireNonNull(this.nextFactory.apply(result));
            }
            catch (Throwable cause) {
                this.subscriber.onError(cause);
                return;
            }
            next.subscribeInternal(this.signalOffloader.offloadSubscriber(this.contextProvider.wrapPublisherSubscriber(this, this.contextMap)));
        }

        @Override
        public void onNext(R r) {
            this.subscriber.onNext(r);
        }

        @Override
        public void onError(Throwable t) {
            this.subscriber.onError(t);
        }

        @Override
        public void onComplete() {
            this.subscriber.onComplete();
        }
    }
}

